<?php
/**
 * Displays a no content message
 *
 * @file           content-none.php
 * @package        Luminescence-Lite 
 * @author         Styled Themes 
 * @copyright      2013 Styledthemes.com
 * @license        license.txt
 * @version        Release: 1.2.0
 */
?>

<header class="page-header">
	<h1 class="page-title"><?php _e( 'No Articles Found', 'luminescence-lite' ); ?></h1>
</header>

<div class="page-content">
	<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

	<p><?php printf( __( 'You are ready to publish your first post! <a href="%1$s">Get started here</a>.', 'luminescence-lite' ), admin_url( 'post-new.php' ) ); ?></p>

	<?php elseif ( is_search() ) : ?>

	<p><?php _e( 'Unfortunately nothing matched your search terms. Please try again with different keywords.', 'luminescence-lite' ); ?></p>
	<?php get_search_form(); ?>

	<?php else : ?>

	<p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'luminescence-lite' ); ?></p>
	<?php get_search_form(); ?>

	<?php endif; ?>
</div><!-- .page-content -->