<?php $options = get_option('lu_options'); ?>
<?php /* No Post */ ?>
<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php _e( 'Not Found', 'lukoo' ); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'lukoo' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php while ( have_posts() ) : the_post(); ?>

<?php /* Normal Post */ ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'lukoo' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

			<div class="entry-meta">
				<?php lukoo_posted_on(); ?>
				<span class="meta-sep">|</span>
				<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'lukoo' ), __( '1 Comment', 'lukoo' ), __( '% Comments', 'lukoo' ) ); ?></span>
				<?php if ( count( get_the_category() ) ) : ?>
				<span class="meta-sep">|</span>
					<span class="cat-links">
						<?php printf( __( '%2$s', 'lukoo' ), 'entry-utility-prep entry-utility-prep-cat-links', get_the_category_list( ', ' ) ); ?>
					</span>
				<?php endif; ?>
				<?php edit_post_link( __( 'Edit', 'lukoo' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
			</div><!-- .entry-meta -->
<?php if (($options['lu_archive_format'])=='') : ?>
	<?php if ( is_archive() || is_search() ) : // Only display excerpts for archives and search. ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
			<div class="clearfix"></div>
	<?php else : ?>
			<div class="entry-content">
				<div class="thumbnail <?php if (($options['lu_thumbnail_pos'])=='') : ?>aligncenter<?php elseif (($options['lu_thumbnail_pos'])=='1') : ?>alignleft<?php elseif (($options['lu_thumbnail_pos'])=='2') : ?>alignright<?php endif; ?>"><?php the_post_thumbnail(); ?></div>
				<?php if (($options['lu_index_format'])=='') : ?>
				<?php the_content( __( 'Continue reading', 'lukoo' ) ); ?>
				<?php else : ?>
				<?php the_excerpt(); ?>
				<?php endif; ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'lukoo' ), 'after' => '</div>' ) ); ?>
			</div><!-- .entry-content -->
			<div class="clearfix"></div>
	<?php endif; ?>
<?php elseif (($options['lu_archive_format'])=='1') : ?>
			<div class="entry-content">
				<div class="thumbnail <?php if (($options['lu_thumbnail_pos'])=='') : ?>aligncenter<?php elseif (($options['lu_thumbnail_pos'])=='1') : ?>alignleft<?php elseif (($options['lu_thumbnail_pos'])=='2') : ?>alignright<?php endif; ?>"><?php the_post_thumbnail(); ?></div>
				<?php the_content( __( 'Continue reading', 'lukoo' ) ); ?>
				<div class="clearfix"></div>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'lukoo' ), 'after' => '</div>' ) ); ?>
			</div><!-- .entry-content -->
			<div class="clearfix"></div>
<?php endif; ?>

		</div><!-- #post-## -->

		<?php comments_template( '', true ); ?>


<?php endwhile; // End the loop. ?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if (  $wp_query->max_num_pages > 1 ) : ?>
				<div id="nav-below" class="navigation">
				<?php if ($options['lu_custompagenav_enable']) : ?>
					<div class="default_page_nav">
						<div class="post-nex"><div class="post-nex-text"><?php next_posts_link(__('<div class="post-nex-icon"></div> Older posts','lukoo')) ?></div></div>
						<div class="post-pre"><div class="post-pre-text"><?php previous_posts_link(__('<div class="post-pre-icon"></div> Newer posts','lukoo')) ?></div></div>
					</div><!-- .default_page_nav -->
				<?php else : ?>
					<ul class="page-numbers">
					<?php if ($options['lu_pagenav_no']) : ?><?php $custom_pageno = $options['lu_pagenav_no']; ?><?php else : ?><?php $custom_pageno = 6; ?><?php endif; ?>
					<?php pagenavi($custom_pageno); ?>
					</ul>
				<?php endif; ?>
				</div><!-- #nav-below -->
<?php endif; ?>
