<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php echo bloginfo('template_url').'/reset.css'; ?>" />
<link rel="stylesheet" type="text/css" media="all" href="<?php echo get_stylesheet_uri() ?>" />
<?php $options = get_option('lu_options'); ?>
<style type="text/css">
<?php if ($options['lu_customcss_enable']) : ?>
<?php echo stripslashes($options['lu_customcss']); ?>
<?php endif; ?>
<?php if ($options['lu_postcolor_h']) : ?>
h2.entry-title a {
	color: #<?php echo $options['lu_postcolor_h']; ?>;
}
<?php endif; ?>
<?php if ($options['lu_postcolor_a']) : ?>
div.entry-content a {
	color: #<?php echo $options['lu_postcolor_a']; ?>;
}
<?php endif; ?>
<?php if ($options['lu_postcolor_p']) : ?>
div.entry-content p {
	color: #<?php echo $options['lu_postcolor_p']; ?>;
}
<?php endif; ?>
<?php if (isset($options['lu_sidecolor_a'])) { ?>
<?php if ($options['lu_sidecolor_a']) : ?>
#body_side_wid ul li ul a {
	color: #<?php echo $options['lu_sidecolor_a']; ?>;
}
<?php endif; ?>
<?php } ?>
</style>
<?php if ($options['lu_favicon']) { ?>
<link rel="Shortcut Icon" type="image/x-icon" href="<?php echo stripslashes($options['lu_favicon']); ?>" />
<?php } ?> 
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<script type="text/javascript">
<?php if ($options['lu_ajaxcomment_edit_enable']) : ?>
var ajaxcomment_editmode = '0';
<?php else : ?>
var ajaxcomment_editmode = '1';
<?php endif; ?>
</script>
<?php
	wp_enqueue_script( 'jquery' );
	wp_enqueue_script('lukoo_function', WP_THEME_URL . '/js/functions.js' );
if (isset($options['lu_ajaxcomment_enable'])) {
if ($options['lu_ajaxcomment_enable']) {
	if (is_singular()) :
		if (preg_match('/zh-tw|zh-hk/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'])) :
		wp_enqueue_script('lukoo_ajax_comment', WP_THEME_URL . '/js/comments-ajax-tw.js' );
		elseif (preg_match('/zh-cn/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'])) :
		wp_enqueue_script('lukoo_ajax_comment', WP_THEME_URL . '/js/comments-ajax-cn.js' );
		else :
		wp_enqueue_script('lukoo_ajax_comment', WP_THEME_URL . '/js/comments-ajax-en.js' );
		endif;
	endif;
} else {
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
}
}
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<div id="global_wrap" class="hfeed">
	<div id="header_wrap">
		<div id="header_bar">
			<?php if ($options['lu_customlogo_enable']) { ?>
			<a href="<?php echo home_url( '/' ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo stripslashes($options['lu_customlogo']); ?>" id="custom_header_logo" title="<?php bloginfo( 'name' ); ?>" alt="<?php bloginfo( 'name' ); ?>" /></a>
			<?php } else { ?>
			<a href="<?php echo home_url( '/' ); ?>" id="header_logo" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
			<?php } ?>
			<?php if (isset($options['lu_title_des_enable'])) { ?>
			<?php if ($options['lu_title_des_enable']) : ?>
			<h1 id="header_name"><a href="<?php echo home_url( '/' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
			<h3 id="header_description"><?php bloginfo( 'description' ); ?></h3>
			<?php endif; ?>
			<?php } ?>
			<div id="header_nav">
			<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'primary' ) ); ?>
			</div><!-- #header_nav -->
			<?php if ($options['lu_loginpanel_enable']) : ?>
			<?php else : ?>
			<div id="header_user">
				<?php if ( is_user_logged_in() ) { ?>
					<div id="signup_loginpanel"><?php _e('Login as', 'lukoo') ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php global $current_user;get_currentuserinfo();echo $current_user->user_login;?></a>. | </div><a id="show_loginpanel">Show Panel</a>
				<?php } else { ?>
					<div id="show_loginpanel"><?php _e('Login', 'lukoo') ?></div><div id="signup_loginpanel"> | <a href="<?php echo get_option('home'); ?>/wp-login.php?action=register" rel="external"><?php _e('Signup', 'lukoo') ?></a> | <a href="<?php echo get_option('home'); ?>/wp-login.php?action=lostpassword" rel="external"><?php _e('Lost Password', 'lukoo') ?></a></div>
				<?php } ?>
			</div><!-- #header_user -->
			<div id="header_login">
				<div id="loginform_close"></div>
                <div id="loginform_wrap">
				<?php if ( is_user_logged_in() ) { ?>
					<div id="loginform_message">
						<?php _e('Login as', 'lukoo') ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php global $current_user;get_currentuserinfo();echo $current_user->user_login;?></a>. <a href="<?php echo home_url( '/wp-admin/' ); ?>"><?php _e('Admin Panel', 'lukoo') ?></a> |
					<?php if(is_home()): ?>
                        <a href="<?php echo wp_logout_url( get_bloginfo('url') ); ?>"><?php _e('Logout', 'lukoo') ?></a>
                    <?php else: ?>
                        <a href="<?php echo wp_logout_url( get_permalink() ); ?>"><?php _e('Logout', 'lukoo') ?></a>
                    <?php endif; ?>
					</div>
				<?php } else { ?>
					<?php wp_login_form(); ?>
				<?php } ?>
				</div><!-- #loginform_wrap -->
			</div><!-- #header_login -->            <?php endif; ?>
			<?php if ($options['lu_customfeed_enable']) { ?>
			<a href="<?php echo stripslashes($options['lu_customfeed']); ?>" id="header_feed" title="RSS Feed" >RSS Feed</a>
			<?php } else { ?>
			<a href="<?php echo get_feed_link( 'rss2' ); ?>" id="header_feed" title="RSS Feed" >RSS Feed</a>
			<?php } ?>
		</div><!-- #header_bar -->
	</div><!-- #header -->
	<?php if ($options['lu_ads_header_enable']) : ?>
	<div class="ads_code ads_code_a">
		<?php echo stripslashes($options['lu_ads_header']); ?>
	</div>
	<?php endif; ?>
	<div id="body_wrap">
		<div id="body_con_wrap">
			<div id="body_con_top"></div>
			<div id="body_con_mid">
				<div id="body_con_con" role="main">
