<?php
$options = get_option('lu_options');
if ( ! isset( $content_width ) )
	$content_width = 550;

/** Tell WordPress to run lukoo_setup() when the 'after_setup_theme' hook is run. */
add_action( 'after_setup_theme', 'lukoo_setup' );

if ( ! function_exists( 'lukoo_setup' ) ):
function lukoo_setup() {

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );
	
	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'lukoo', TEMPLATEPATH . '/languages' );

	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'lukoo' ),
	) );

	// This theme allows users to set a custom background
	add_custom_background();

}
endif;


/**
 * Define WP_THEME_URL
 *
 */
if(!defined('WP_THEME_URL')) {
define( 'WP_THEME_URL', get_bloginfo('stylesheet_directory'));
}

/**
 * jQuery CDN
 *
 */
if ($options['lu_cdn_enable']) :
function lukoo_jquery_cdn() {
	if ( !is_admin() ) {
    wp_deregister_script( 'jquery' );
	$options = get_option('lu_options');
	if (($options['lu_cdn'])=='') :
    wp_register_script( 'jquery', 'http://code.jquery.com/jquery-1.4.2.min.js');
	elseif (($options['lu_cdn'])=='1') :
    wp_register_script( 'jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js');
	elseif (($options['lu_cdn'])=='2') :
    wp_register_script( 'jquery', 'http://ajax.microsoft.com/ajax/jquery/jquery-1.4.2.min.js');
	else :
	endif;
	}
}    
add_action('init', 'lukoo_jquery_cdn');
else :
endif;
/**
 * Posts Thumbnail
 *
 */
if ( function_exists( 'add_theme_support' ) ) {
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 500, 500, true );
}

/**
 * LuKoo's Default Gravatar
 *
 */
function lukoo_gravatar( $avatar_defaults ) {
    $myavatar = get_bloginfo('template_directory') . '/images/gravatar/gravatar.png';
    $avatar_defaults[$myavatar] = 'Default Gravatar for LuKoo';
    return $avatar_defaults;
}
add_filter( 'avatar_defaults', 'lukoo_gravatar' );

/**
 */
 
function lukoo_filter_wp_title( $title, $separator ) {
	// Don't affect wp_title() calls in feeds.
	if ( is_feed() )
		return $title;

	// The $paged global variable contains the page number of a listing of posts.
	// The $page global variable contains the page number of a single post that is paged.
	// We'll display whichever one applies, if we're not looking at the first page.
	global $paged, $page;

	if ( is_search() ) {
		// If we're a search, let's start over:
		$title = sprintf( __( 'Search results for %s', 'lukoo' ), '"' . get_search_query() . '"' );
		// Add a page number if we're on page 2 or more:
		if ( $paged >= 2 )
			$title .= " $separator " . sprintf( __( 'Page %s', 'lukoo' ), $paged );
		// Add the site name to the end:
		$title .= " $separator " . get_bloginfo( 'name', 'display' );
		// We're done. Let's send the new title back to wp_title():
		return $title;
	}

	// Otherwise, let's start by adding the site name to the end:
	$title .= get_bloginfo( 'name', 'display' );

	// If we have a site description and we're on the home/front page, add the description:
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title .= " $separator " . $site_description;

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		$title .= " $separator " . sprintf( __( 'Page %s', 'lukoo' ), max( $paged, $page ) );

	// Return the new title to wp_title():
	return $title;
}
add_filter( 'wp_title', 'lukoo_filter_wp_title', 10, 2 );

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * To override this in a child theme, remove the filter and optionally add
 * your own function tied to the wp_page_menu_args filter hook.
 *
 */
function lukoo_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'lukoo_page_menu_args' );

/**
 * Length of excerpt
 *
 */

function lukoo_excerpt_length( $length ) {
$options = get_option('lu_options');
	if (isset($options['lu_excerptlength'])) {
	$lu_except_length = $options['lu_excerptlength'];
	} else {
	$lu_except_length = 40;
	}
	return $lu_except_length;
}
add_filter( 'excerpt_length', 'lukoo_excerpt_length' );

/**
 * Returns a "Continue Reading" link for excerpts
 *
 */
function lukoo_continue_reading_link() {
	return ' <a href="'. get_permalink() . '" class="more-link">' . __( 'Continue reading', 'lukoo' ) . '</a>';
}

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with an ellipsis and lukoo_continue_reading_link().
 *
 * To override this in a child theme, remove the filter and add your own
 * function tied to the excerpt_more filter hook.
 *
 */
function lukoo_auto_excerpt_more( $more ) {
	return ' &hellip;' . lukoo_continue_reading_link();
}
add_filter( 'excerpt_more', 'lukoo_auto_excerpt_more' );

/**
 * Adds a pretty "Continue Reading" link to custom post excerpts.
 *
 * To override this link in a child theme, remove the filter and add your own
 * function tied to the get_the_excerpt filter hook.
 *
 */
function lukoo_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= lukoo_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'lukoo_custom_excerpt_more' );

/**
 * Page Navigation
 *
 */

function pagenavi($range = 6){
	// $paged - number of the current page
	global $paged, $wp_query;
	// How much pages do we have?
	$max_page = $wp_query->max_num_pages;
	// We need the pagination only if there are more than 1 page
	if($max_page > 1){
		
		if(!$paged){
			$paged = 1;
		}

		/* 
		if(!$paged){
			$paged = 1;
		}
		echo '<span><strong>導航頁碼:&nbsp;&nbsp;&nbsp;</strong>'.$paged.' / '.$max_page.'</span>'; 
		*/
		
		// On the first page, don't put the First page link
		if($paged != 1 && $max_page != $range){
			echo "<li><a href='" . get_pagenum_link(1) . "' class='extend' title='First Page'> ‹ </a></li>";
		}
		// To the previous page
		// previous_posts_link(' ‹ ');
		// We need the sliding effect only if there are more pages than is the sliding range
		if($max_page > $range){
			// When closer to the beginning
			if($paged < $range){
				for($i = 1; $i <= ($range + 1); $i++){
					echo "<li><a href='" . get_pagenum_link($i) ."'";
					if($i == $paged) echo " class='current'";
					echo ">$i</a></li>";
				}
			}
			// When closer to the end
			elseif($paged >= ($max_page - ceil(($range/2)))){
				for($i = $max_page - $range; $i <= $max_page; $i++){
					echo "<li><a href='" . get_pagenum_link($i) ."'";
					if($i == $paged) echo " class='current'";
					echo ">$i</a></li>";
				}
			}
			// Somewhere in the middle
			elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
				for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){
					echo "<li><a href='" . get_pagenum_link($i) ."'";
					if($i == $paged) echo " class='current'";
					echo ">$i</a></li>";
				}
			}
		}
		// Less pages than the range, no sliding effect needed
		else{
			for($i = 1; $i <= $max_page; $i++){
				echo "<li><a href='" . get_pagenum_link($i) ."'";
				if($i == $paged) echo " class='current'";
				echo ">$i</a></li>";
			}
		}
		// Next page
		// next_posts_link(' › ');
		// On the last page, don't put the Last page link
		if($paged != $max_page && $max_page != $range){
			echo "<li><a href='" . get_pagenum_link($max_page) . "' class='extend' title='Last Page'> › </a></li>";
		}
	}
}


if ( ! function_exists( 'lukoo_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 */
function lukoo_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
    <div id="comment-<?php comment_ID(); ?>" class="comment-hcom">
		<div class="comment-content">
			<div class="comment-author">
				<div class="comment-avatar">
					<?php echo get_avatar($comment,$size='60' ); ?> 
				</div><!-- .comment-avatar -->
				 <div class="comment-info">
					<span class="comment-author-link"><?php printf(__('%s '), get_comment_author_link()) ?></span><br /><span class="comment-date"><?php printf(__('%1$s'), get_comment_date()) ?></span>
				</div><!-- .comment-info -->
			</div><!-- .comment-author -->
            <div class="comment-arrow"></div>
            <div class="comment-reply">
                <?php edit_comment_link(__('(Edit)'),'  ','') ?>
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div><!-- .comment-reply -->
            <div class="clearfix"></div>
            <?php if ($comment->comment_approved == '0') : ?>
                <div class="comment-approved"><?php _e('Your comment is awaiting moderation.') ?></div>
                <div class="clearfix"></div>
            <?php endif; ?>
    
            <div class="comment-text">
                <?php comment_text() ?>
            </div><!-- .comment-text -->
            <div class="clearfix"></div>
        </div><!-- .comment-content -->
        <div class="clearfix"></div>
    </div><!-- .comment-hcom -->
<?php } 
?>
<?php
// Ping Style
function lukoo_pings($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
    <div id="comment-<?php comment_ID(); ?>" class="comment-hcom">
        <div class="comment-author">
            <?php printf(__('%s '), get_comment_author_link()) ?><br />
            <?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?>
        </div><!-- .comment-author -->
    
        <div class="comment-text">
            <?php comment_text() ?>
        </div><!-- .comment-text -->
    </div><!-- .comment-hcom -->
<?php } 
endif;

/**
 * Comment Mail Notify
 * By Willin Kan
 */
if (isset($options['lu_mailnotify_enable'])) {
if ($options['lu_mailnotify_enable']) {
function comment_mail_notify($comment_id) {
$options = get_option('lu_options');
	if (isset($options['lu_email_mailnotify'])) {
	if ($options['lu_email_mailnotify']) {
		$admin_notify = '1';
	} else {
		$admin_notify = '0';
	}
	}
	$admin_email = get_bloginfo('admin_email');
	$comment = get_comment($comment_id);
	$comment_author_email = trim($comment->comment_author_email);
	$parent_id = $comment->comment_parent ? $comment->comment_parent : '';
	$get_comment_id = get_comment($parent_id);
	global $wpdb;
	if ($wpdb->query("Describe {$wpdb->comments} comment_mail_notify") == '')
		$wpdb->query("ALTER TABLE {$wpdb->comments} ADD COLUMN comment_mail_notify TINYINT NOT NULL DEFAULT 0;");
	if (($comment_author_email != $admin_email && isset($_POST['comment_mail_notify'])) || ($comment_author_email == $admin_email && $admin_notify == '1'))
		$wpdb->query("UPDATE {$wpdb->comments} SET comment_mail_notify='1' WHERE comment_ID='$comment_id'");
	$notify = $parent_id ? $get_comment_id->comment_mail_notify : '0';
	$spam_confirmed = $comment->comment_approved;
	if ($parent_id != '' && $spam_confirmed != 'spam' && $notify == '1') {
		$wp_email = 'no-reply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME'])); // e-mail 發出點, no-reply 可改為可用的 e-mail.
		$to = trim($get_comment_id->comment_author_email);
		$subject = __('Hello, you have a new reply in [','lukoo') . get_option("blogname") . ']';
		$message = '
		<div style="background-color:#eef2fa; border:1px solid #d8e3e8; color:#111; padding:0 15px; -moz-border-radius:5px; -webkit-border-radius:5px; -khtml-border-radius:5px;">
			<p>' . __('Hello ','lukoo') . trim($get_comment_id->comment_author) . ',</p>
			<p>' . __('Yours comment in','lukoo') . ' 《' . get_the_title($comment->comment_post_ID) . '》 ' . __('has been replied by ','lukoo') . trim($comment->comment_author) . ',</p>
			<p style="border-left:3px solid #ccc;padding:10px;">' . trim($get_comment_id->comment_content) . '</p>
			<p>' . __('The following is ','lukoo') . trim($comment->comment_author) . __('’s reply:','lukoo') . '</p>
			<p style="border-left:3px solid #ccc;padding:10px;">' . trim($comment->comment_content) . '</p>
			<p><a href="' . htmlspecialchars(get_comment_link($parent_id, array('type' => 'comment'))) . '">'. __('Click Here','lukoo') . '</a>' . __(' to read the complete reply.','lukoo') . '</p>
			<p>' . __('Be reminded that, this e-mail is sent automatically, please do not reply. Thank you.','lukoo') . '</p>
			<p><a href="' . get_option('home') . '">' . get_option('blogname') . '</a></p>
		</div>';
		$from = "From: \"" . get_option('blogname') . "\" <$wp_email>";
		$headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";
		wp_mail( $to, $subject, $message, $headers );
	}
}
add_action('comment_post', 'comment_mail_notify');

/* Added Check Box */
function add_checkbox() {
	echo '<span ><input type="checkbox" name="comment_mail_notify" id="comment_mail_notify" value="comment_mail_notify" checked="checked" style="margin-top:20px;" /><label for="comment_mail_notify" style="color: #888;">' . __('Notify me when somebody is replied.','lukoo') . '</label></span>';
}
add_action('comment_form', 'add_checkbox');
}
}
/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override lukoo_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 *
 */
function lukoo_widgets_init() {
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => __( 'Primary Widget Area', 'lukoo' ),
		'id' => 'primary-widget-area',
		'description' => __( 'The primary widget area', 'lukoo' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 2, located below the Primary Widget Area in the sidebar. Empty by default.
	register_sidebar( array(
		'name' => __( 'Secondary Widget Area', 'lukoo' ),
		'id' => 'secondary-widget-area',
		'description' => __( 'The secondary widget area', 'lukoo' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
/** Register sidebars by running lukoo_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'lukoo_widgets_init' );


if ( ! function_exists( 'lukoo_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post—date/time and author.
 *
 */
function lukoo_posted_on() {
	printf( __( '<span class="%1$s">Posted on</span> %2$s <span class="meta-sep">by</span> %3$s', 'lukoo' ),
		'meta-prep meta-prep-author',
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span></a>',
			get_permalink(),
			esc_attr( get_the_time() ),
			get_the_date()

		),
		sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
			get_author_posts_url( get_the_author_meta( 'ID' ) ),
			sprintf( esc_attr__( 'View all posts by %s', 'lukoo' ), get_the_author() ),
			get_the_author()
		)
	);
}
endif;

if ( ! function_exists( 'lukoo_posted_in' ) ) :
/**
 * Prints HTML with meta information for the current post (category, tags and permalink).
 *
 */
function lukoo_posted_in() {
	// Retrieves tag list of current post, separated by commas.
	$tag_list = get_the_tag_list( '', ', ' );
	if ( $tag_list ) {
		$posted_in = __( 'Tags: %2$s.', 'lukoo' );
	} else {
		$posted_in = __( 'No tags.', 'lukoo' );
	}
	// Prints the string, replacing the placeholders.
	printf(
		$posted_in,
		get_the_category_list( ', ' ),
		$tag_list,
		get_permalink(),
		the_title_attribute( 'echo=0' )
	);
}
endif;
/**
 * ShortCode
 *
 */
if ($options["lu_ads_custom_a_enable"]) :
	function ad1_shortcode() {
		$options = get_option('lu_options');
		return '<span class="ads_code_c">' . $options["lu_ads_custom_a"] . '</span>';
	}
	add_shortcode('ad1', 'ad1_shortcode');
endif;

if ($options["lu_ads_custom_b_enable"]) :
	function ad2_shortcode() {
		$options = get_option('lu_options');
		return '<span class="ads_code_c">' . $options["lu_ads_custom_b"] . '</span>';
	}
	add_shortcode('ad2', 'ad2_shortcode');
endif;

/**
 * Custom Login
 *
 */
function lukoo_custom_login() {
	echo '<link rel="stylesheet" type="text/css" href="'.get_bloginfo('template_directory').'/login/custom_login.css" />';
$options = get_option('lu_options');
if ($options['lu_customlogo_enable']) :
	echo '<style type="text/css">h1 a{background:transparent url('.stripslashes($options['lu_customlogo']).') no-repeat top center;}</style>';
endif;
}
add_action('login_head', 'lukoo_custom_login');
?>
<?php
// Theme Option Function
	include('function-admin.php');
?>