<?php
/**
 * Create custom plugin settings menu
 *
 */
	
add_action('admin_menu', 'lukoo_admin_menu');

function lukoo_admin_menu() {

	//create new top-level menu
	add_theme_page(__( 'LuKoo Theme Settings', 'lukoo' ), __( 'LuKoo Settings', 'lukoo' ), 'edit_themes', basename(__FILE__), 'lukoo_settings_page');

	//call register settings function
	add_action( 'admin_init', 'register_lukoo_settings' );
}

function register_lukoo_settings() {
	//register our settings
	register_setting( 'lukoo-settings-group', 'lu_options' );
}

function lukoo_admin_init() {
	// add custom css n js
	wp_enqueue_style("lukoo_css", WP_THEME_URL."/admin/lukoo_admin.css", false, "all");
	wp_enqueue_script("lukoo_function_scripts", WP_THEME_URL."/admin/lukoo_admin.js", array('jquery'), "all");
	wp_enqueue_script("lukoo_function_colorani", WP_THEME_URL."/admin/colorani.js", array('jquery'), "all");
}
add_action('admin_init', 'lukoo_admin_init');

function lukoo_settings_page() {
if ( isset($_REQUEST['updated']) ) echo '<div id="message" class="updated fade lu_settings_saved"><p><strong> Lukoo settings saved.</strong></p></div>';
if( 'reset' == isset($_REQUEST['reset']) ) {
	delete_option('lu_options');
	if( $_GET['update']= 'true') echo '<script>jQuery(".lu_settings_saved").hide();</script>';
	echo '<div id="message" class="updated fade lu_settings_reset"><p><strong> Lukoo settings reset.</strong></p></div>';
}
?>
<div id="loading-mask" style="position:fixed !important;position:absolute;top:0;left:0;height:100%; width:100%; z-index:999; background:#000; opacity:0.6; filter:alpha(opacity=60);font-size:14px;line-height:20px;" onclick="javascript:turnoff('loading')"><noscript><p style="color:#fff;position:absolute;top:50%;left:50%;margin:0 0 0 -180px;padding:3px 10px;text-align:center;"><?php _e('JavaScript module required. Please enable the JavaScript module of your browser.','lukoo') ?></p></noscript><p id="loading-mask-text" style="color:#fff;position:absolute;top:50%;left:50%;margin:20px 0 0 -50px;padding:3px 10px;text-align:center;" onclick="javascript:turnoff('loading')"><?php _e('Loading...','lukoo') ?></p></div>
<script type="text/javascript">
jQuery(window).load(function(){
  jQuery('#loading-mask-text').empty().append('<?php _e('Loading Complete','lukoo') ?>').parent().fadeOut(1000);
});
</script>
<script type="text/javascript">
	var lukoo_current_version = '<?php $theme_data = get_theme_data(ABSPATH . 'wp-content/themes/lukoo/style.css');echo $theme_data['Version'];?>';
</script>
<script type="text/javascript" src="http://lukoo.googlecode.com/svn/trunk/latest_version/lukoo_latest_version.js"></script>
<script type="text/javascript">
jQuery(document).ready(function(){
	jQuery("span.lukoo_lastest_version_no").text(lukoo_latest_version);
	if(lukoo_current_version < lukoo_latest_version ){
		jQuery(".lu_admin_update_warning").fadeIn(1000);
	}
	else {
		jQuery(".lu_admin_uptodate").fadeIn(1000);
	};
});
</script>
<div class="wrap">
	<h2 class="option-title"><?php _e('Lukoo Settings','lukoo') ?></h2>
	<div class="lu_admin_update_warning lu_nodisplay updated fade"><p><strong> <?php _e('LuKoo Version','lukoo') ?> <span class="lukoo_lastest_version_no"></span> <?php _e('is available.','lukoo') ?> <a href="http://lukoo.googlecode.com/files/latest_lukoo.zip" title="Latest Version of LuKoo" rel="external"><?php _e('Download updated version','lukoo') ?></a> <?php _e('or','lukoo') ?> <a href="http://code.google.com/p/lukoo/wiki/ChangeLog" title="View ChangeLog of LuKoo" rel="external"><?php _e('View ChangeLog','lukoo') ?></a></strong></p></div>
	<div id="lu_admin_ie_warning" class="lu_nodisplay updated fade"><p><strong> <?php _e('Suggestion: You may have a better experience on other browsers instead of Internet Explorer.','lukoo') ?><span id="lu_admin_ie_warning_disable">Close [X]</span></strong></p></div>
		<form method="post" action="options.php">
		<?php settings_fields( 'lukoo-settings-group' ); ?>
		<?php $options = get_option('lu_options'); ?>
		<div id="lu_nav_list">
			<ul class="lu_tabs_js">
				<li class="tabs_general" title="#lu-tab-general"><?php _e('General','lukoo') ?></li>
				<li class="tabs_general" title="#lu-tab-header"><?php _e('Header','lukoo') ?></li>
				<li class="tabs_post" title="#lu-tab-post"><?php _e('Post','lukoo') ?></li>
				<li class="tabs_post" title="#lu-tab-comment"><?php _e('Comment','lukoo') ?></li>
				<li class="tabs_sidebar" title="#lu-tab-sidebar"><?php _e('Sidebar','lukoo') ?></li>
				<li class="tabs_footer" title="#lu-tab-footer"><?php _e('Footer','lukoo') ?></li>
				<li class="tabs_advertisement" title="#lu-tab-advertisement"><?php _e('Advertisement','lukoo') ?></li>
				<li class="tabs_help" title="#lu-tab-help"><?php _e('Help','lukoo') ?></li>
			</ul>
			<div class="clearfix"></div>
			<div class="lu_inside">
				<ul id="lu-tab-general" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('General','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_favicon]"><?php _e('Favicon','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<input type="text" name="lu_options[lu_favicon]" value="<?php echo $options['lu_favicon']; ?>" />
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the URL of your Favicon .ico.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_customfeed_enable]"><?php _e('Custom Feed','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_customfeed_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_customfeed_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_customfeed_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_customfeed_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Using external feedburner.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_customfeed]"><?php _e('External Feed URL','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<input type="text" name="lu_options[lu_customfeed]" value="<?php echo $options['lu_customfeed']; ?>"/>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your external Feed URL','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_cdn_enable]"><a href="http://wikipedia.org/wiki/Content_delivery_network" title="<?php _e('Meaning of CDN','lukoo') ?>" rel="external">CDN</a> <?php _e('Hosted jQuery','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<span class="radio_options"><input type="radio" name="lu_options[lu_cdn_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_cdn_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
										<span class="radio_options"><input type="radio" name="lu_options[lu_cdn_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_cdn_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Load jQuery file with CDN instead of Localhost','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_cnd]"><?php _e('CDN','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
											<span class="radio_options"><input type="radio" name="lu_options[lu_cdn]" value="" <?php checked('', $options['lu_cdn']); ?>/> <?php _e('jQuery CDN','lukoo') ?></span>
											<span class="radio_options"><input type="radio" name="lu_options[lu_cdn]" value="1" <?php checked('1', $options['lu_cdn']); ?>/> <?php _e('Google Ajax API CDN','lukoo') ?></span>
											<span class="radio_options"><input type="radio" name="lu_options[lu_cdn]" value="2" <?php checked('2', $options['lu_cdn']); ?>/> <?php _e('Microsoft CDN','lukoo') ?></span>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Select the CDN.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_custompagenav_enable]"><?php _e('Custom Page Navigation','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_custompagenav_enable]" class="lu_cbradio_cl" value="1" <?php checked('1', $options['lu_custompagenav_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_custompagenav_enable]" class="lu_cbradio_op" value="" <?php checked('', $options['lu_custompagenav_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Using Custom Page Navigation. Disable will use the default WordPress Page Navigation.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_pagenav_no]"><?php _e('Number of Pages to Display','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<input type="text" name="lu_options[lu_pagenav_no]" value="<?php if (isset($options['lu_pagenav_no'])) : ?><?php echo $options['lu_pagenav_no']; ?><?php else : ?>6<?php endif; ?>"/>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter the number of pages to display on the Page Navigation System.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-general -->

				<ul id="lu-tab-header" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Header','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
									<label for="lu_options[lu_customlogo_enable]"><?php _e('Custom Logo','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_customlogo_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_customlogo_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_customlogo_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_customlogo_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Using your own Logo','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_customlogo]"><?php _e('Logo URL','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<input type="text" name="lu_options[lu_customlogo]" value="<?php echo $options['lu_customlogo']; ?>"/>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Logo URL.<br />Max-height: 125px.<br />Max-width: 350px.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_title_des_enable]"><?php _e('Title and Description','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_title_des_enable]" class="lu_cbradio_cl" value="" <?php if (isset($options['lu_title_des_enable'])) { ?><?php checked('', $options['lu_title_des_enable']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_title_des_enable]" class="lu_cbradio_op" value="1" <?php if (isset($options['lu_title_des_enable'])) { ?><?php checked('1', $options['lu_title_des_enable']); ?><?php } ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Display the Blog Title and Description besides the logo.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_loginpanel_enable]"><?php _e('Login Panel','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_loginpanel_enable]" class="lu_cbradio_cl" value="1" <?php checked('1', $options['lu_loginpanel_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_loginpanel_enable]" class="lu_cbradio_op" value="" <?php checked('', $options['lu_loginpanel_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Showing the Login Panel.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-header -->

				<ul id="lu-tab-post" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Post','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_postcolor_h]"><?php _e('Post Title Color','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<div class="colorp_left">
										#<input type="text" name="lu_options[lu_postcolor_h]" class="color_sel_field" maxlength="6" value="<?php if (isset($options['lu_postcolor_h'])) : ?><?php echo $options['lu_postcolor_h']; ?><?php else : ?>444444<?php endif; ?>"/>
									</div>
									<div class="colorp_right">
										<div class="color_sel_display" style="background: #<?php if (isset($options['lu_postcolor_h'])) : ?><?php echo $options['lu_postcolor_h']; ?><?php else : ?>444444<?php endif; ?>;"></div>
									</div>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the Hex Code of your Post Title Color.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_postcolor_p]"><?php _e('Post Texts Color','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<div class="colorp_left">
										#<input type="text" name="lu_options[lu_postcolor_p]" class="color_sel_field" maxlength="6" value="<?php if (isset($options['lu_postcolor_p'])) : ?><?php echo $options['lu_postcolor_p']; ?><?php else : ?>555555<?php endif; ?>"/>
									</div>
									<div class="colorp_right">
										<div class="color_sel_display" style="background: #<?php if (isset($options['lu_postcolor_p'])) : ?><?php echo $options['lu_postcolor_p']; ?><?php else : ?>555555<?php endif; ?>;"></div>
									</div>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the Hex Code of your Post Texts Color.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_postcolor_p]"><?php _e('Post Links Color','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<div class="colorp_left">
										#<input type="text" name="lu_options[lu_postcolor_a]" class="color_sel_field" maxlength="6" value="<?php if (isset($options['lu_postcolor_a'])) : ?><?php echo $options['lu_postcolor_a']; ?><?php else : ?>83b820<?php endif; ?>"/>
									</div>
									<div class="colorp_right">
										<div class="color_sel_display" style="background: #<?php if (isset($options['lu_postcolor_a'])) : ?><?php echo $options['lu_postcolor_a']; ?><?php else : ?>83b820<?php endif; ?>;"></div>
									</div>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the Hex Code of your Post Links Color.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_thumbnail_pos]"><?php _e('Thumbnails Position','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<span class="radio_options"><input type="radio" name="lu_options[lu_thumbnail_pos]" value="1" <?php checked('1', $options['lu_thumbnail_pos']); ?>/> <?php _e('Left','lukoo') ?></span>
										<span class="radio_options"><input type="radio" name="lu_options[lu_thumbnail_pos]" value="" <?php checked('', $options['lu_thumbnail_pos']); ?>/> <?php _e('Centered','lukoo') ?></span>
										<span class="radio_options"><input type="radio" name="lu_options[lu_thumbnail_pos]" value="2" <?php checked('2', $options['lu_thumbnail_pos']); ?>/> <?php _e('Right','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Positioning your thumbnails.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_index_format]"><?php _e('Index Format','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<span class="radio_options"><input type="radio" name="lu_options[lu_index_format]" value="1" <?php checked('1', $options['lu_index_format']); ?>/> <?php _e('Excerpt','lukoo') ?></span>
										<span class="radio_options"><input type="radio" name="lu_options[lu_index_format]" value="" <?php checked('', $options['lu_index_format']); ?>/> <?php _e('Complete','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Selecting the format of post in index page.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_archive_format]"><?php _e('Archive Format','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<span class="radio_options"><input type="radio" name="lu_options[lu_archive_format]" value="" <?php checked('', $options['lu_archive_format']); ?>/> <?php _e('Excerpt','lukoo') ?></span>
										<span class="radio_options"><input type="radio" name="lu_options[lu_archive_format]" value="1" <?php checked('1', $options['lu_archive_format']); ?>/> <?php _e('Complete','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Selecting the format of post in archive category and search page.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_excerptlength]"><?php _e('Post Excerpt Length','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<input type="text" name="lu_options[lu_excerptlength]" value="<?php if (isset($options['lu_excerptlength'])) : ?><?php echo $options['lu_excerptlength']; ?><?php else : ?>40<?php endif; ?>" />
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the length of your Post Excerpt.<br />Default: 40 words.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_customcss_enable]"><?php _e('Custom CSS','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_customcss_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_customcss_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_customcss_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_customcss_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Using custom CSS.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_customcss]"><?php _e('Custom CSS','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_customcss]"><?php echo $options['lu_customcss']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your custom CSS.<br />Eg. a:hover{color:red;}','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-post -->

				<ul id="lu-tab-comment" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Comment','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_comment_box_style]"><?php _e('Respond comment box style','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_comment_box_style]" class="lu_cbradio_cl" value="" <?php if (isset($options['lu_comment_box_style'])) { ?><?php checked('', $options['lu_comment_box_style']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Style 1','lukoo') ?><div class="tooltips_img"><span id="img_comment_style_1"></span></div></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_comment_box_style]" class="lu_cbradio_op" value="1" <?php if (isset($options['lu_comment_box_style'])) { ?><?php checked('1', $options['lu_comment_box_style']); ?><?php } ?>/> <?php _e('Style 2','lukoo') ?><div class="tooltips_img"><span id="img_comment_style_2"></span></div></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Select the style of the Respond comment box.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ajaxcomment_enable]"><?php _e('Ajax Comment','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ajaxcomment_enable]" class="lu_cbradio_cl" value="" <?php if (isset($options['lu_ajaxcomment_enable'])) { ?><?php checked('', $options['lu_ajaxcomment_enable']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ajaxcomment_enable]" class="lu_cbradio_op" value="1" <?php if (isset($options['lu_ajaxcomment_enable'])) { ?><?php checked('1', $options['lu_ajaxcomment_enable']); ?><?php } ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Using Ajax to submit comment.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ajaxcomment_edit_enable]"><?php _e('Re-Edit Mode','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
											<span class="radio_options"><input type="radio" name="lu_options[lu_ajaxcomment_edit_enable]" value="1" <?php if (isset($options['lu_ajaxcomment_edit_enable'])) { ?><?php checked('1', $options['lu_ajaxcomment_edit_enable']); ?><?php } ?>/> <?php _e('Disable','lukoo') ?></span>
											<span class="radio_options"><input type="radio" name="lu_options[lu_ajaxcomment_edit_enable]" value="" <?php if (isset($options['lu_ajaxcomment_edit_enable'])) { ?><?php checked('', $options['lu_ajaxcomment_edit_enable']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Enable','lukoo') ?></span>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Re-Edit is available after comment is submitted.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_mailnotify_enable]"><?php _e('Comment Notification Email','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_mailnotify_enable]" class="lu_cbradio_cl" value="" <?php if (isset($options['lu_mailnotify_enable'])) { ?><?php checked('', $options['lu_mailnotify_enable']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_mailnotify_enable]" class="lu_cbradio_op" value="1" <?php if (isset($options['lu_mailnotify_enable'])) { ?><?php checked('1', $options['lu_mailnotify_enable']); ?><?php } ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Notify repliers when their comment has been replied.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_email_mailnotify]"><?php _e('Admin Notify Mode','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
											<span class="radio_options"><input type="radio" name="lu_options[lu_email_mailnotify]" value="1" <?php if (isset($options['lu_email_mailnotify'])) { ?><?php checked('1', $options['lu_email_mailnotify']); ?><?php } ?>/> <?php _e('Disable','lukoo') ?></span>
											<span class="radio_options"><input type="radio" name="lu_options[lu_email_mailnotify]" value=""<?php if (isset($options['lu_email_mailnotify'])) { ?> <?php checked('', $options['lu_email_mailnotify']); ?><?php }else{ ?>checked<?php } ?>/> <?php _e('Enable','lukoo') ?></span>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Administrator will receive an notification email when Admin’s comment has been reply.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-comment -->

				<ul id="lu-tab-sidebar" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Sidebar','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_sidecolor_a]"><?php _e('Sidebar Links Color','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<div class="colorp_left">
										#<input type="text" name="lu_options[lu_sidecolor_a]" class="color_sel_field" maxlength="6" value="<?php if (isset($options['lu_sidecolor_a'])) : ?><?php echo $options['lu_sidecolor_a']; ?><?php else : ?>666666<?php endif; ?>"/>
									</div>
									<div class="colorp_right">
										<div class="color_sel_display" style="background: #<?php if (isset($options['lu_sidecolor_a'])) : ?><?php echo $options['lu_sidecolor_a']; ?><?php else : ?>666666<?php endif; ?>;"></div>
									</div>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter the Hex Code of your Sidebar Links Color.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_recentcomment_enable]"><?php _e('Recent Comment','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_recentcomment_enable]" class="lu_cbradio_cl" value="1" <?php checked('1', $options['lu_recentcomment_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_recentcomment_enable]" class="lu_cbradio_op" value="" <?php checked('', $options['lu_recentcomment_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Recent Comment Function in Sidebar.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_recentcomment_no]"><?php _e('Number of Comments to Display','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<input type="text" name="lu_options[lu_recentcomment_no]" value="<?php if (isset($options['lu_recentcomment_no'])) : ?><?php echo $options['lu_recentcomment_no']; ?><?php else : ?>3<?php endif; ?>"/>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter the number of recent comments to display on the Sidebar.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-sidebar -->

				<ul id="lu-tab-footer" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Footer','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_footer_copyright]"><?php _e('Footer Copyright Text','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
										<textarea  type="textarea" name="lu_options[lu_footer_copyright]"><?php echo $options['lu_footer_copyright']; ?></textarea>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Enter your Copyright Text, it will be displayed in footer.<br />HTML available.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_statistics_enable]"><?php _e('Statistics','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_statistics_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_statistics_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_statistics_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_statistics_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Statistic Code to your site.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_statistics]"><?php _e('Statistics Code','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_statistics]"><?php echo $options['lu_statistics']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Statistic Code.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-footer -->

				<ul id="lu-tab-advertisement" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Advertisement','lukoo') ?></h2>
						</div>

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ads_custom_a_enable]"><?php _e('Custom Ad One [ad1]','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_custom_a_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_ads_custom_a_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_custom_a_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_ads_custom_a_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Custom Ad in your post.<br />By typing the ','lukoo') ?> <a href="http://codex.wordpress.org/Shortcode_API" title="WordPress Codex - ShortCode API" rel="external">ShortCode</a><?php _e(' [ad1] in your post, the script will be shown on the position where you entered.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ads_custom_a]"><?php _e('Ad ShortCode','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_ads_custom_a]"><?php echo $options['lu_ads_custom_a']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Ad ShortCode.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ads_custom_b_enable]"><?php _e('Custom Ad Two [ad2]','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_custom_b_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_ads_custom_b_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_custom_b_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_ads_custom_b_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Custom Ad in your post.<br />By typing the ','lukoo') ?> <a href="http://codex.wordpress.org/Shortcode_API" title="WordPress Codex - ShortCode API" rel="external">ShortCode</a><?php _e(' [ad2] in your post, the script will be shown on the position where you entered.','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ads_custom_b]"><?php _e('Ad ShortCode','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_ads_custom_b]"><?php echo $options['lu_ads_custom_b']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Ad ShortCode.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ads_header_enable]"><?php _e('Header Ad','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_header_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_ads_header_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_header_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_ads_header_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Ad to your site.<br />Max-width: 1000px','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ads_header]"><?php _e('Ad Code','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_ads_header]"><?php echo $options['lu_ads_header']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Ad Code.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ads_sidebar_enable]"><?php _e('Sidebar Ad','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_sidebar_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_ads_sidebar_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_sidebar_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_ads_sidebar_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Ad to your site.<br />Max-width: 210px','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ads_sidebar]"><?php _e('Ad Code','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_ads_sidebar]"><?php echo $options['lu_ads_sidebar']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Ad Code.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

						<div class="lukoo_option">
								<div class="lukoo_option_l">
										<label for="lu_options[lu_ads_footer_enable]"><?php _e('Footer Ad','lukoo') ?></label>
								</div>
								<div class="lukoo_option_m">
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_footer_enable]" class="lu_cbradio_cl" value="" <?php checked('', $options['lu_ads_footer_enable']); ?>/> <?php _e('Disable','lukoo') ?></span>
									<span class="radio_options"><input type="radio" name="lu_options[lu_ads_footer_enable]" class="lu_cbradio_op" value="1" <?php checked('1', $options['lu_ads_footer_enable']); ?>/> <?php _e('Enable','lukoo') ?></span>
								</div>
								<div class="lukoo_option_r">
										<small><?php _e('Adding Ad to your site.<br />Max-width: 1000px','lukoo') ?></small>
								</div>
								<div class="clearfix"></div>
								<div class="cbradio_checked lu_nodisplay">
										<div class="lukoo_option_l">
												<label for="lu_options[lu_ads_footer]"><?php _e('Ad Code','lukoo') ?></label>
										</div>
										<div class="lukoo_option_m">
												<textarea  type="textarea" name="lu_options[lu_ads_footer]"><?php echo $options['lu_ads_footer']; ?></textarea>
										</div>
										<div class="lukoo_option_r">
												<small><?php _e('Enter your Ad Code.','lukoo') ?></small>
										</div>
										<div class="clearfix"></div>
								</div>
						</div><!-- .lukoo_option -->

					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-advertisement -->

				<ul id="lu-tab-help" class="list lu-tab-list">
					<div class="lukoo_option_wrap">
						<div class="lukoo_option_section">
							<h2><?php _e('Help','lukoo') ?></h2>
						</div>
						<div class="lukoo_helppage">
							<p><?php _e('You are now using','lukoo') ?> <?php $theme_data = get_theme_data(ABSPATH . 'wp-content/themes/lukoo/style.css');echo $theme_data['Title']; echo $theme_data['Version'];?> by <a href="http://wsqsite.com/" title="WSQSITE" rel="external">WSQ</a>.</p> <p class="lu_admin_uptodate" style="display: none;color: #21759b;"><?php _e('Your LuKoo theme version is up to date.','lukoo') ?></p><p class="lu_admin_update_warning" style="display: none; color: red;"><?php _e('The latest available version of LuKoo is','lukoo') ?> <span class="lukoo_lastest_version_no"></span>. <a href="http://lukoo.googlecode.com/files/latest_lukoo.zip" title="Latest Version of LuKoo" rel="external"><?php _e('Download updated version','lukoo') ?></a></p><br />
							<p><?php _e('Theme Released page :','lukoo') ?> <a href="http://wsqsite.com/blog/lukoo/" title="Released page" rel="external">WSQSITE</a> </p>
							<p><?php _e('Theme Download Version List :','lukoo') ?> <a href="http://code.google.com/p/lukoo/downloads/list" title="Download Version List from GoogleCode" rel="external"><?php _e('Download Version List','lukoo') ?></a></p>
							<p><?php _e('Theme ChangeLog :','lukoo') ?> <a href="http://code.google.com/p/lukoo/wiki/ChangeLog" title="ChangeLog from GoogleCode" rel="external"><?php _e('View ChangeLog','lukoo') ?></a></p>
							<p><?php _e('Theme Update Feed :','lukoo') ?> <a href="http://code.google.com/feeds/p/lukoo/downloads/basic" title="RSS Update Feed" rel="external"><?php _e('RSS Update Feed','lukoo') ?></a></p><br />
							<p><?php _e('If you meet any problems, you can read the','lukoo') ?> <a href="http://code.google.com/p/lukoo/w/list" title="Help Page from GoogleCode" rel="external"><?php _e('Help Page','lukoo') ?></a></p>
							<p><?php _e('If you have any further questions, you can use the','lukoo') ?> <a href="http://wsqsite.com/contact/" title="Contact Form" rel="external"><?php _e('Contact Form','lukoo') ?></a> <?php _e('to contact me.','lukoo') ?></p>
						</div>
					</div><!-- .lukoo_option_wrap -->
				</ul><!-- #lu-tab-help -->

			</div><!-- .lu_inside -->
		</div><!-- #lu_nav_list -->
		<div class="lu_submit_form">
			<input type="submit" class="button-primary lu_submit_form_btn" name="save" value="<?php _e('Save Changes') ?>"/>
		</div>
		<div class="lu_submit_form_loading" style="display: none;">Loading...</div>
	</form>
	<form method="post">
		<div class="lu_reset_form">
			<input type="submit" name="reset" value="<?php _e('Reset') ?>" class="button-secondary lu_reset_form_btn"/>
			<input type="hidden" name="reset" value="reset" />
		</div>
		<div class="lu_reset_form_loading" style="display: none;">Loading...</div>
	</form>
<div class="clearfix"></div>
</div><!-- .wrap -->
<?php } ?>