<?php
/**
 * The template used for displaying page content in page.php
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php lovewp_article_schema( 'CreativeWork' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * lovewp_before_content hook.
		 *
		 *
		 * @hooked lovewp_featured_page_header_inside_single - 10
		 */
		do_action( 'lovewp_before_content' );

		if ( lovewp_show_title() ) : ?>

			<header class="entry-header">
				<?php the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' ); ?>
			</header><!-- .entry-header -->

		<?php endif;

		/**
		 * lovewp_after_entry_header hook.
		 *
		 *
		 * @hooked lovewp_post_image - 10
		 */
		do_action( 'lovewp_after_entry_header' );
		?>

		<div class="entry-content" itemprop="text">
			<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'lovewp' ),
				'after'  => '</div>',
			) );
			?>
		</div><!-- .entry-content -->

		<?php
		/**
		 * lovewp_after_content hook.
		 *
		 */
		do_action( 'lovewp_after_content' );
		?>
	</div><!-- .inside-article -->
</article><!-- #post-## -->
