<?php
/**
 * Builds our admin page.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'lovewp_create_menu' ) ) {
	add_action( 'admin_menu', 'lovewp_create_menu' );
	/**
	 * Adds our "LoveWP" dashboard menu item
	 *
	 */
	function lovewp_create_menu() {
		$lovewp_page = add_theme_page( 'LoveWP', 'LoveWP', apply_filters( 'lovewp_dashboard_page_capability', 'edit_theme_options' ), 'lovewp-options', 'lovewp_settings_page' );
		add_action( "admin_print_styles-$lovewp_page", 'lovewp_options_styles' );
	}
}

if ( ! function_exists( 'lovewp_options_styles' ) ) {
	/**
	 * Adds any necessary scripts to the LoveWP dashboard page
	 *
	 */
	function lovewp_options_styles() {
		wp_enqueue_style( 'lovewp-options', get_template_directory_uri() . '/css/admin/style.css', array(), LOVEWP_VERSION );
	}
}

if ( ! function_exists( 'lovewp_settings_page' ) ) {
	/**
	 * Builds the content of our LoveWP dashboard page
	 *
	 */
	function lovewp_settings_page() {
		?>
		<div class="wrap">
			<div class="metabox-holder">
				<div class="lovewp-masthead clearfix">
					<div class="lovewp-container">
						<div class="lovewp-title">
							<a href="<?php echo esc_url(LOVEWP_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'LoveWP', 'lovewp' ); ?></a> <span class="lovewp-version"><?php echo LOVEWP_VERSION; ?></span>
						</div>
						<div class="lovewp-masthead-links">
							<?php if ( ! defined( 'LOVEWP_PREMIUM_VERSION' ) ) : ?>
								<a class="lovewp-masthead-links-bold" href="<?php echo esc_url(LOVEWP_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Premium', 'lovewp' );?></a>
							<?php endif; ?>
							<a href="<?php echo esc_url(LOVEWP_WPKOI_AUTHOR_URL); ?>" target="_blank"><?php esc_html_e( 'WPKoi', 'lovewp' ); ?></a>
                            <a href="<?php echo esc_url(LOVEWP_DOCUMENTATION); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'lovewp' ); ?></a>
						</div>
					</div>
				</div>

				<?php
				/**
				 * lovewp_dashboard_after_header hook.
				 *
				 */
				 do_action( 'lovewp_dashboard_after_header' );
				 ?>

				<div class="lovewp-container">
					<div class="postbox-container clearfix" style="float: none;">
						<div class="grid-container grid-parent">

							<?php
							/**
							 * lovewp_dashboard_inside_container hook.
							 *
							 */
							 do_action( 'lovewp_dashboard_inside_container' );
							 ?>

							<div class="form-metabox grid-70" style="padding-left: 0;">
								<h2 style="height:0;margin:0;"><!-- admin notices below this element --></h2>
								<form method="post" action="options.php">
									<?php settings_fields( 'lovewp-settings-group' ); ?>
									<?php do_settings_sections( 'lovewp-settings-group' ); ?>
									<div class="customize-button hide-on-desktop">
										<?php
										printf( '<a id="lovewp_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
											esc_url( admin_url( 'customize.php' ) ),
											esc_html__( 'Customize', 'lovewp' )
										);
										?>
									</div>

									<?php
									/**
									 * lovewp_inside_options_form hook.
									 *
									 */
									 do_action( 'lovewp_inside_options_form' );
									 ?>
								</form>

								<?php
								$modules = array(
									'Backgrounds' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Blog' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Colors' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Disable Elements' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Demo Import' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Hooks' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Import / Export' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Menu Plus' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Page Header' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Secondary Nav' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Sections' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Spacing' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Typography' => array(
											'url' => LOVEWP_THEME_URL,
									),
									'Elementor Addon' => array(
											'url' => LOVEWP_THEME_URL,
									)
								);

								if ( ! defined( 'LOVEWP_PREMIUM_VERSION' ) ) : ?>
									<div class="postbox lovewp-metabox">
										<h3 class="hndle"><?php esc_html_e( 'Premium Modules', 'lovewp' ); ?></h3>
										<div class="inside" style="margin:0;padding:0;">
											<div class="premium-addons">
												<?php foreach( $modules as $module => $info ) { ?>
												<div class="add-on activated lovewp-clear addon-container grid-parent">
													<div class="addon-name column-addon-name" style="">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php echo esc_html( $module ); ?></a>
													</div>
													<div class="addon-action addon-addon-action" style="text-align:right;">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php esc_html_e( 'Learn more', 'lovewp' ); ?></a>
													</div>
												</div>
												<div class="lovewp-clear"></div>
												<?php } ?>
											</div>
										</div>
									</div>
								<?php
								endif;

								/**
								 * lovewp_options_items hook.
								 *
								 */
								do_action( 'lovewp_options_items' );
								?>
							</div>

							<div class="lovewp-right-sidebar grid-30" style="padding-right: 0;">
								<div class="customize-button hide-on-mobile">
									<?php
									printf( '<a id="lovewp_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
										esc_url( admin_url( 'customize.php' ) ),
										esc_html__( 'Customize', 'lovewp' )
									);
									?>
								</div>

								<?php
								/**
								 * lovewp_admin_right_panel hook.
								 *
								 */
								 do_action( 'lovewp_admin_right_panel' );

								  ?>
                                
                                <div class="wpkoi-doc">
                                	<h3><?php esc_html_e( 'LoveWP documentation', 'lovewp' ); ?></h3>
                                	<p><?php esc_html_e( 'If You`ve stuck, the documentation may help on WPKoi.com', 'lovewp' ); ?></p>
                                    <a href="<?php echo esc_url(LOVEWP_DOCUMENTATION); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'LoveWP documentation', 'lovewp' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-social">
                                	<h3><?php esc_html_e( 'WPKoi on Facebook', 'lovewp' ); ?></h3>
                                	<p><?php esc_html_e( 'If You want to get useful info about WordPress and the theme, follow WPKoi on Facebook.', 'lovewp' ); ?></p>
                                    <a href="<?php echo esc_url(LOVEWP_WPKOI_SOCIAL_URL); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Go to Facebook', 'lovewp' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-review">
                                	<h3><?php esc_html_e( 'Help with You review', 'lovewp' ); ?></h3>
                                	<p><?php esc_html_e( 'If You like LoveWP theme, show it to the world with Your review. Your feedback helps a lot.', 'lovewp' ); ?></p>
                                    <a href="<?php echo esc_url(LOVEWP_WORDPRESS_REVIEW); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Add my review', 'lovewp' ); ?></a>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'lovewp_admin_errors' ) ) {
	add_action( 'admin_notices', 'lovewp_admin_errors' );
	/**
	 * Add our admin notices
	 *
	 */
	function lovewp_admin_errors() {
		$screen = get_current_screen();

		if ( 'appearance_page_lovewp-options' !== $screen->base ) {
			return;
		}

		if ( isset( $_GET['settings-updated'] ) && 'true' == $_GET['settings-updated'] ) {
			 add_settings_error( 'lovewp-notices', 'true', esc_html__( 'Settings saved.', 'lovewp' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'imported' == $_GET['status'] ) {
			 add_settings_error( 'lovewp-notices', 'imported', esc_html__( 'Import successful.', 'lovewp' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'reset' == $_GET['status'] ) {
			 add_settings_error( 'lovewp-notices', 'reset', esc_html__( 'Settings removed.', 'lovewp' ), 'updated' );
		}

		settings_errors( 'lovewp-notices' );
	}
}
