<?php
$slider_section_page  = get_theme_mod( 'spiral-lite-one-page_ed_slider_section' );
$slider_section_images = get_theme_mod( 'lora_lite_one_page_slider_section_images' );

// Sanitize HTML content when saving via get_theme_mod()
$cation1 = get_theme_mod( 'slider-cations-1', wp_kses_post( __( "<h1>Creative <span>Ideas</span></h1>", 'lora-lite-one-page' ) ) );
$cation2 = get_theme_mod( 'slider-cations-2', wp_kses_post( __( "<h1>Creative <span>Design</span></h1>", 'lora-lite-one-page' ) ) );
$cation3 = get_theme_mod( 'slider-cations-3', wp_kses_post( __( "<h1>Creative <span>Solutions</span></h1>", 'lora-lite-one-page' ) ) );

$btn1_text = get_theme_mod('loralite_btn1text', __('Learn More', 'lora-lite-one-page'));
$btn1_url = get_theme_mod('loralite_btn1url', '#');
$btn2_text = get_theme_mod('loralite_btn2text', __('Buy Theme Now >', 'lora-lite-one-page'));
$btn2_url = get_theme_mod('loralite_btn2url', '#');
	
$main_bg = get_theme_mod('landing-page-bg'); // Retrieve the default header image

// If the header image is not set, use a fallback
if (!$main_bg) {
	$main_bg = get_template_directory_uri() . '/images/bg.jpg'; // Default image URL
} ?>

<!-- Parallax Slide -->
<?php if( $slider_section_page ) {

    if( $slider_section_images ) {
        $image_srcs = explode( ',', $slider_section_images );
        echo '<div class="hero-slider">';
        if( is_array( $image_srcs ) ) {
            foreach( $image_srcs as $image_src ) {             
                echo '<div class="hiddenslide" data-src="' . esc_url( $image_src ) . '"></div>';
            }
        }
        echo '</div>';
    }
?>

<!-- Parallax Slide -->
<section id="primary" class="hero parallax">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="flexslider home-slider">
                    <ul class="slides">

                     <?php if ( ! empty( $cation1 ) ) : ?>
                    <li><?php echo $cation1; ?></li>  <!-- No need for wp_kses_post here since the content is already sanitized -->
                     <?php endif; ?>

                     <?php if ( ! empty( $cation2 ) ) : ?>
                    <li><?php echo $cation2; ?></li>  <!-- No need for wp_kses_post here -->
                     <?php endif; ?>

                     <?php if ( ! empty( $cation3 ) ) : ?>
                    <li><?php echo $cation3; ?></li>  <!-- No need for wp_kses_post here -->
                     <?php endif; ?>
                    
                    </ul>
                </div> <!-- End Flexslider -->
                <div class="home-btn">
                    <p>
                        <a class="btn btn-outline-light btn-big" href="<?php echo esc_url($btn1_url); ?>">
                            <?php echo esc_html($btn1_text); ?>
                        </a>
                        <a class="btn btn-big left-margin" href="<?php echo esc_url($btn2_url); ?>">
                            <?php echo esc_html($btn2_text); ?>
                        </a>
                    </p>
                </div>
            </div> <!-- End Column 12 -->
        </div> <!-- End Row -->
    </div> <!-- End Container -->
</section>

<?php } ?>
