<?php
/**
 * Template part for displaying About Section
 *
 * @package Spiral_Lite_One_Page
 */

$about_subtitle = get_theme_mod( 'spiral_lite_one_page_about_section_subtitle', __( "Spiral is customizable fully responsive", 'lora-lite-one-page' ) );
$about_pretitle = get_theme_mod( 'spiral_lite_one_page_about_section_pretitle', __( "Pellentesque sapien purus, sagittis eu accumsan convallis, vehicula ut lectus. Fusce accumsan <strong>purus pretium ligula</strong> vehicula, ut interdum nisl vulputate. Vivamus ultrices luctus quam eu feugiat", 'lora-lite-one-page' ) );

// Set a default image URL
$default_about_image = get_template_directory_uri() . '/images/about.jpg';

// Get the custom image or use the default if not set
$about_image = get_theme_mod('spiral_lite_one_page_about_section_image', $default_about_image);
$about_content = get_theme_mod('spiral_lite_one_page_about_section_content', __( 
    '<h2>Responsive Layout</h2>
     <p class="lead">donec porttitor velit eget lectus ac turpis.</p>
     <hr />
     <h2>Clean & Modern Design</h2>
     <p class="lead">donec porttitor velit eget lectus ac turpis.</p>
     <hr />
     <h2>Free Premium Support</h2>
     <p class="lead">donec porttitor velit eget lectus ac turpis.</p>', 
    'spiral-lite-one-page' ) );
?>


  <!-- Title-->
  <div class="text-center">
				
				<h1 class="title"><?php echo esc_html( get_theme_mod( 'spiral_lite_one_page_about_section_page_title', 'ABOUT US' ) ); ?></h1>

				<div class="icon"><i class="fa fa-<?php echo esc_html( get_theme_mod( 'spiral_lite_one_page_about_section_icon', 'heart-o' ) ); ?>"></i></div>
                 
                 
                <?php

if ( ! empty( $about_subtitle ) ) : ?>
    <h2 class="subtitle" style="color: #666666;"><?php echo esc_html( $about_subtitle ); ?></h2>
<?php endif; ?>

<?php if ( ! empty( $about_pretitle ) ) :?>
    <p class="pretitle"><?php echo wp_kses_post( $about_pretitle ); ?></p>
<?php endif; ?>
                 </div> <!-- End Title -->

 <!-- Row -->
                     <div class="row">
                     <?php if ($about_image) : ?>
                        <div class="col-lg-6">
                        <img class="img-fluid" src="<?php echo esc_url($about_image); ?>" alt="About">
                    </div> 
               <?php endif; ?>
               <?php if ($about_content) : ?>
                    <div class="col-lg-6">
                    <?php echo wp_kses_post($about_content); ?>
                    </div> 
                    <?php endif; ?>
                </div> <!-- End Row -->




          