<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;
/**
 * Lora One Page Child Theme functions and definitions
 */

 function lora_lite_one_page_child_theme_setup() {
    // Add support for the title tag
    add_theme_support( 'title-tag' );

    // Add support for automatic feed links
    add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'lora_lite_one_page_child_theme_setup' );

function lora_lite_one_page_child_theme_widgets_init() {
    register_sidebar( array(
       'name'          => esc_html__( 'Sidebar', 'lora-lite-one-page' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'lora-lite-one-page' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'lora_lite_one_page_child_theme_widgets_init' );

 function lora_lite_one_page_child_enqueue_styles() {
    // Enqueue parent theme stylesheet
    wp_enqueue_style('spiral-lite-one-page-parent-style', get_template_directory_uri() . '/style.css');

    // Enqueue child theme stylesheet
    wp_enqueue_style('lora-one-page-child-style', get_stylesheet_directory_uri() . '/css/style.css', array('spiral-lite-one-page-parent-style'));

    // Enqueue custom script
    wp_enqueue_script(
        'custom-js',
        get_stylesheet_directory_uri() . '/js/custom.js',
        array('jquery'),
        '1.0.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'lora_lite_one_page_child_enqueue_styles', 20);


add_action( 'wp_enqueue_scripts', 'lora_lite_one_page_child_enqueue_styles', 20 );

function lora_lite_one_page_child_admin_css() {
    // If your admin-style.css is in the child theme root:
    wp_enqueue_style( 'lora-lite-one-page-child-admin', get_stylesheet_directory_uri() . '/css/admin-style.css', array(), '1.0', 'all' );

    // If your admin-style.css is in a subfolder (e.g., /css/):
    // wp_enqueue_style( 'lora-lite-one-page-child-admin', get_stylesheet_directory_uri() . '/css/admin-style.css', array(), '1.0', 'all' );
}
add_action( 'admin_enqueue_scripts', 'lora_lite_one_page_child_admin_css' );

// Remove the additional customizer settings from the parent theme
/*function lora_lite_one_page_child_remove_customizer_settings() {
    // Remove the customizer settings registered by the parent theme
    remove_action( 'customize_register', 'spiral_lite_one_page_my_register_additional_customizer_settings' );
}
add_action( 'init', 'lora_lite_one_page_child_remove_customizer_settings' );
*/

function lora_lite_one_page_remove_parent_theme_settings($wp_customize) {
    // remove Pretitle fileds 
    $wp_customize->remove_control('spiral_lite_one_page_about_section_pretitle');
    $wp_customize->remove_control('spiral_lite_one_page_services_section_pretitle');
    // Remove sections or controls here
    // Remove sections or controls here
    $wp_customize->remove_control('theme_info_theme');
    $wp_customize->remove_section('spirallite_landing_page_settings');
}
add_action('customize_register', 'lora_lite_one_page_remove_parent_theme_settings', 20);

function lora_lite_one_page_child_customize_register( $wp_customize ) {
    // Remove the parent theme's PRO section
   $wp_customize->remove_section( 'spiral-lite-one-page' );

    // Re-add the section with modifications
    $wp_customize->add_section(
        new spiral_lite_one_page_Customize_Section_Pro(
            $wp_customize,
            'lora-lite-one-one-child-theme',
            array(
                'title'    => esc_html__( 'PRO Available', 'lora-lite-one-page' ),
                'pro_text' => esc_html__( 'Get Pro Version Now!', 'lora-lite-one-page' ),
                'pro_url'  => esc_url( 'https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/' ) // Modify this as needed
            )
        )
    );
}
add_action( 'customize_register', 'lora_lite_one_page_child_customize_register', 11 );


// Customizer settings for the child theme
function lora_lite_one_page_child_register_additional_customizer_settings( $wp_customize ) {
    // Add your customizer settings here
    $wp_customize->add_section( 'theme_info', array(
        'title'       => __( 'Demo & Documentation', 'lora-lite-one-page' ),
        'priority'    => 6,
    ) );

    /** Important Links */
    $wp_customize->add_setting( 'theme_info_theme_child',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $theme_info = '';
    $theme_info .= sprintf( '<p>' . __( 'Demo Link: %1$sClick here.%2$s', 'lora-lite-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/previews/?theme=lora-lite' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( '<p>' . __( 'Pro Demo Link: %1$sClick here.%2$s', 'lora-lite-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/previews/?theme=lora' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( '<p>' . __( 'Documentation Link: %1$sClick here.%2$s', 'lora-lite-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/docs/spirallite/' ) . '" target="_blank">', '</a>' );
    
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize,
        'theme_info_theme_child',
        array(
            'section'     => 'theme_info',
            'description' => $theme_info,
            'type'        => 'hidden',
        )
    ));
}
add_action( 'customize_register', 'lora_lite_one_page_child_register_additional_customizer_settings' );

function lora_lite_one_page_child_theme_customize_register( $wp_customize ) {
    // Overriding the $upgrade_description from the parent theme.
    $upgrade_description = sprintf( 
        __( '%1$sUnlock the full potential of the section by upgrading to Pro.%2$s %3$sUnlock Now%4$s ', 'lora-lite-one-page' ),
        '<div class="pro-version-button"><span>',
        '</span>',
        '<a href="https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/" target="_blank">',
        '</a></div>'
    );
    
    // Modify the existing control if necessary.
    $wp_customize->get_control('team_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('portfolio_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('client_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('testimonials_sec_unlock')->description = $upgrade_description;
}

add_action( 'customize_register', 'lora_lite_one_page_child_theme_customize_register', 20 );

add_action('customize_register', function($wp_customize) {
    // Slider Section
    $wp_customize->add_section(
        'spiral_lite_one_page_slider_section',
        array(
            'title' => __('Slider Section', 'lora-lite-one-page'),
            'priority' => 20,
            'panel' => 'spiral_lite_one_page_home_page_settings',
        )
    );

    // Slider Header Section
    $wp_customize->add_setting(
        'slider_head_setting_options',
        array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'spirallite_sanitize_text',
            'priority' => 2,
        )
    );

    $wp_customize->add_control(
        'slider_head_setting_options',
        array(
            'type' => 'hidden',
            'label' => __('Settings', 'lora-lite-one-page'),
            'section' => 'spiral_lite_one_page_slider_section',
        )
    );

    // Enable/Disable Slider Section
    $wp_customize->add_setting(
        'spiral-lite-one-page_ed_slider_section',
        array(
            'default' => '',
            'sanitize_callback' => 'spiral_lite_one_page_sanitize_checkbox',
        )
    );

    $wp_customize->add_control(
        'spiral-lite-one-page_ed_slider_section',
        array(
            'label' => __('Enable Slider Section', 'lora-lite-one-page'),
            'section' => 'spiral_lite_one_page_slider_section',
            'type' => 'checkbox',
        )
    );

     // Slider Images Header Section
     $wp_customize->add_setting(
        'slider_head_images_setting_options',
        array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'spirallite_sanitize_text',
            'priority' => 3,
        )
    );

    $wp_customize->add_control(
        'slider_head_images_setting_options',
        array(
            'type' => 'hidden',
            'label' => __('Images', 'lora-lite-one-page'),
            'section' => 'spiral_lite_one_page_slider_section',
        )
    );


        // Slider Images //
$wp_customize->add_setting(
	'lora_lite_one_page_slider_section_images',
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Spiral_Lite_One_Page_Multi_Image_Customize_Control( $wp_customize, 'lora_lite_one_page_slider_section_images', array(
	'label'       => __( 'Select Slider Images', 'lora-lite-one-page' ),
	'section'     => 'spiral_lite_one_page_slider_section',
   ) )
);

 // Slider Captions Header Section
 $wp_customize->add_setting(
    'slider_head_captions_setting_options',
    array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'spirallite_sanitize_text',
        'priority' => 5,
    )
);

$wp_customize->add_control(
    'slider_head_captions_setting_options',
    array(
        'type' => 'hidden',
        'label' => __('Captions', 'lora-lite-one-page'),
        'section' => 'spiral_lite_one_page_slider_section',
    )
);

$wp_customize->add_setting(
	'slider-cations-1',
	array(
		'default'           => __( '<h1>Creative <span>Ideas</span></h1>', 'lora-lite-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-1',
	array(
		'label' => __( 'Slider Cation 1', 'lora-lite-one-page' ),
		'section' => 'spiral_lite_one_page_slider_section',
		'type' => 'text',
	)
);

$wp_customize->add_setting(
	'slider-cations-2',
	array(
		'default'           => __( '<h1>Creative <span>Design</span>', 'lora-lite-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-2',
	array(
		'label' => __( 'Slider Cation 2', 'lora-lite-one-page' ),
		'section' => 'spiral_lite_one_page_slider_section',
		'type' => 'text',
	)
);

$wp_customize->add_setting(
	'slider-cations-3',
	array(
		'default'           => __( '<h1>Creative <span>Solutions</span>', 'lora-lite-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-3',
	array(
		'label' => __( 'Slider Cation 3', 'lora-lite-one-page' ),
		'section' => 'spiral_lite_one_page_slider_section',
		'type' => 'text',
	)
);


      // Slider Buttons Header Section
      $wp_customize->add_setting(
        'slider_head_button_setting_options',
        array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'spirallite_sanitize_text',
            'priority' => 5,
        )
    );

    $wp_customize->add_control(
        'slider_head_button_setting_options',
        array(
            'type' => 'hidden',
            'label' => __('Buttons', 'lora-lite-one-page'),
            'section' => 'spiral_lite_one_page_slider_section',
        )
    );

    /** BUTTON 1 TEXT */
		$wp_customize->add_setting(
			'loralite_btn1text',
			array(
				'default' => 'Learn More',
		        'sanitize_callback' => 'sanitize_text_field',
			)
		);
	
			$wp_customize->add_control(
				'loralite_btn1text',
				array(
					'label' => __( 'Button 1 Text', 'lora-lite-one-page' ),
					'section' => 'spiral_lite_one_page_slider_section',
					'type' => 'text',
				)
			);

		/** BUTTON 1 URL */
		$wp_customize->add_setting(
			'loralite_btn1url',
			array(
				'default' => '#',
		        'sanitize_callback' => 'esc_url_raw',
			)
		);
	
			$wp_customize->add_control(
				'loralite_btn1url',
				array(
					'label' => __( 'Button 1 URL', 'lora-lite-one-page' ),
					'section' => 'spiral_lite_one_page_slider_section',
					'type' => 'text',
				)
			);

			/** BUTTON 2 TEXT */
		$wp_customize->add_setting(
			'loralite_btn2text',
			array(
				'default' => 'Buy Theme Now >',
		        'sanitize_callback' => 'sanitize_text_field',
			)
		);
	
			$wp_customize->add_control(
				'loralite_btn2text',
				array(
					'label' => __( 'Button 2 Text', 'lora-lite-one-page' ),
					'section' => 'spiral_lite_one_page_slider_section',
					'type' => 'text',
				)
			);

		/** BUTTON 2 URL */
		$wp_customize->add_setting(
			'loralite_btn2url',
			array(
				'default' => '#',
		        'sanitize_callback' => 'esc_url_raw',
			)
		);
	
	$wp_customize->add_control(
				'loralite_btn2url',
				array(
					'label' => __( 'Button 2 URL', 'lora-lite-one-page' ),
					'section' => 'spiral_lite_one_page_slider_section',
					'type' => 'text',
		)
	);

    if ( ! class_exists( 'SpiralLite_Note_Control_Note_Control' ) ) {
        require_once get_template_directory() . '/inc/custom-controls/note/class-note-control.php';
    }

/** Note */
$wp_customize->add_setting(
	'slider_sec_unlock',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post' 
	)
);

$wp_customize->add_control(
	new SpiralLite_Note_Control_Note_Control( 
		$wp_customize,
		'slider_sec_unlock',
		array(
			'section'     => 'spiral_lite_one_page_slider_section',
            'description' => sprintf( __( '%1$sUnlimited feature Captions, Images is available in Pro version.%2$s %3$sUpgrade to Pro%4$s ', 'lora-lite-one-page' ),'<div class="pro-version-button"><span>', '</span>', '<a href="https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/" target="_blank">', '</a></div>' ),

		)
	)
 );	

});



/**
 * Admin Notice for Spiral Lite One Page Theme (Child Theme)
 */

function lora_lite_one_page_child_theme_remove_parent_admin_notice() {
    remove_action('admin_notices', 'spiral_lite_one_page_admin_notice');
}

add_action('init', 'lora_lite_one_page_child_theme_remove_parent_admin_notice'); // Remove the parent theme's notice

function spiral_lite_one_page_child_admin_notice() {			
    echo '<div class="service_section">
        <div class="service_box"><h3>Installation Video Tutorial Spiral Lite</h3><p>Import demo content and build and customize the Ello Lite Photography</p><center><a target="_blank" rel="nofollow noopener" href="https://www.youtube.com/watch?v=0qTJryLZLuo" class="learn_more" title="Watch Now" data-wpel-link="external">Watch Now</a></center></div>
        <div class="service_box"><h3>SEO Services</h3><p>Increase your ranking and traffic through SEO on & off page services</p><center><a target="_blank" rel="nofollow noopener" href="https://seoengineinc.com/" class="learn_more" title="Learn More" data-wpel-link="external">Learn More</a></center></div>
        <div class="service_box"><h3>WordPress Customization Service</h3><p>Order The Service Add more custom features and designs!</p><center><a target="_blank" rel="nofollow noopener" href="https://pixelonetry.com/services/" class="learn_more" title="Learn More" data-wpel-link="external">Learn More</a></center></div>
    </div><br/><a href="https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/" target="_blank"><input type="button" value="Upgrade to Pro, unlock all features" class="button button-primary button-large req_btn"></a>';
}

add_action('admin_notices', 'spiral_lite_one_page_child_admin_notice');
?>


