<?php

// Sanitize HTML content when saving via get_theme_mod()
$cation1 = get_theme_mod( 'slider-cations-1', wp_kses_post( __( "<h1>Creative <span>Ideas</span></h1>", 'lora-business-one-page' ) ) );
$cation2 = get_theme_mod( 'slider-cations-2', wp_kses_post( __( "<h1>Creative <span>Design</span></h1>", 'lora-business-one-page' ) ) );
$cation3 = get_theme_mod( 'slider-cations-3', wp_kses_post( __( "<h1>Creative <span>Solutions</span></h1>", 'lora-business-one-page' ) ) );

$btn1_text = get_theme_mod('spirallite_btn1text', __('Learn More', 'lora-business-one-page'));
$btn1_url = get_theme_mod('spirallite_btn1url', '#');
$btn2_text = get_theme_mod('spirallite_btn2text', __('Buy Theme Now >', 'lora-business-one-page'));
$btn2_url = get_theme_mod('spirallite_btn2url', '#');
	
$slider_bg_1 = get_theme_mod('slider-bg-1', get_stylesheet_directory_uri() . '/images/slider/slider1.jpg');
$slider_bg_2 = get_theme_mod('slider-bg-2', get_stylesheet_directory_uri() . '/images/slider/slider2.jpg');
$slider_bg_3 = get_theme_mod('slider-bg-3', get_stylesheet_directory_uri() . '/images/slider/slider3.jpg');


?>
<!-- Parallax Slide -->
<div class="hero-slider">
<?php if ( ! empty( $slider_bg_1 ) ) : ?>
    <div class="hiddenslide" data-src="<?php echo $slider_bg_1; ?>"></div>
<?php endif; ?>

<?php if ( ! empty( $slider_bg_2 ) ) : ?>
    <div class="hiddenslide" data-src="<?php echo $slider_bg_2; ?>"></div>
<?php endif; ?>

<?php if ( ! empty( $slider_bg_3 ) ) : ?>
    <div class="hiddenslide" data-src="<?php echo $slider_bg_3; ?>"></div>
<?php endif; ?>
</div> <!-- End Parallax Slide -->

<!-- Parallax Slide -->
<section id="primary" class="hero parallax">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="flexslider home-slider">
                    <ul class="slides">

                     <?php if ( ! empty( $cation1 ) ) : ?>
                    <li><?php echo $cation1; ?></li>  <!-- No need for wp_kses_post here since the content is already sanitized -->
                     <?php endif; ?>

                     <?php if ( ! empty( $cation2 ) ) : ?>
                    <li><?php echo $cation2; ?></li>  <!-- No need for wp_kses_post here -->
                     <?php endif; ?>

                     <?php if ( ! empty( $cation3 ) ) : ?>
                    <li><?php echo $cation3; ?></li>  <!-- No need for wp_kses_post here -->
                     <?php endif; ?>
                    
                    </ul>
                </div> <!-- End Flexslider -->
                <div class="home-btn">
                    <p>
                        <a class="btn btn-outline-light btn-big" href="<?php echo esc_url($btn1_url); ?>">
                            <?php echo esc_html($btn1_text); ?>
                        </a>
                        <a class="btn btn-big left-margin" href="<?php echo esc_url($btn2_url); ?>">
                            <?php echo esc_html($btn2_text); ?>
                        </a>
                    </p>
                </div>
            </div> <!-- End Column 12 -->
        </div> <!-- End Row -->
    </div> <!-- End Container -->
</section>


