<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;
/**
 * Lora One Page Child Theme functions and definitions
 */

 function lora_business_one_page_child_theme_setup() {
    // Add support for the title tag
    add_theme_support( 'title-tag' );

    // Add support for automatic feed links
    add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'lora_business_one_page_child_theme_setup' );

function lora_business_one_page_child_theme_widgets_init() {
    register_sidebar( array(
       'name'          => esc_html__( 'Sidebar', 'lora-business-one-page' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'lora-business-one-page' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'lora_business_one_page_child_theme_widgets_init' );

 function lora_business_one_page_child_enqueue_styles() {
    // Enqueue parent theme stylesheet
    wp_enqueue_style('spiral-lite-one-page-parent-style', get_template_directory_uri() . '/style.css');

    // Enqueue child theme stylesheet
    wp_enqueue_style('lora-one-page-child-style', get_stylesheet_directory_uri() . '/css/style.css', array('spiral-lite-one-page-parent-style'));

    // Enqueue custom script
    wp_enqueue_script(
        'custom-js',
        get_stylesheet_directory_uri() . '/js/custom.js',
        array('jquery'),
        '1.0.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'lora_business_one_page_child_enqueue_styles', 20);


add_action( 'wp_enqueue_scripts', 'lora_business_one_page_child_enqueue_styles', 20 );

function lora_business_one_page_child_admin_css() {
    // If your admin-style.css is in the child theme root:
    wp_enqueue_style( 'lora-business-one-page-child-admin', get_stylesheet_directory_uri() . '/css/admin-style.css', array(), '1.0', 'all' );

    // If your admin-style.css is in a subfolder (e.g., /css/):
    // wp_enqueue_style( 'lora-business-one-page-child-admin', get_stylesheet_directory_uri() . '/css/admin-style.css', array(), '1.0', 'all' );
}
add_action( 'admin_enqueue_scripts', 'lora_business_one_page_child_admin_css' );

// Remove the additional customizer settings from the parent theme
/*function lora_business_one_page_child_remove_customizer_settings() {
    // Remove the customizer settings registered by the parent theme
    remove_action( 'customize_register', 'spiral_lite_one_page_my_register_additional_customizer_settings' );
}
add_action( 'init', 'lora_business_one_page_child_remove_customizer_settings' );
*/

function lora_business_one_page_remove_parent_theme_settings($wp_customize) {
    // remove Content
    $wp_customize->remove_control('spirallite_content');
    $wp_customize->remove_control('landing-page-bg');
    // remove Pretitle fileds 
    $wp_customize->remove_control('spiral_lite_one_page_about_section_pretitle');
    $wp_customize->remove_control('spiral_lite_one_page_services_section_pretitle');
    // Remove sections or controls here
    $wp_customize->remove_control('theme_info_theme');
}
add_action('customize_register', 'lora_business_one_page_remove_parent_theme_settings', 20);

function lora_business_one_page_child_customize_register( $wp_customize ) {
    // Remove the parent theme's PRO section
   $wp_customize->remove_section( 'spiral-lite-one-page' );

    // Re-add the section with modifications
    $wp_customize->add_section(
        new spiral_lite_one_page_Customize_Section_Pro(
            $wp_customize,
            'lora-business-one-page-child-theme',
            array(
                'title'    => esc_html__( 'PRO Available', 'lora-business-one-page' ),
                'pro_text' => esc_html__( 'Get Pro Version Now!', 'lora-business-one-page' ),
                'pro_url'  => esc_url( 'https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/' ) // Modify this as needed
            )
        )
    );
}
add_action( 'customize_register', 'lora_business_one_page_child_customize_register', 11 );


// Customizer settings for the child theme
function lora_business_one_page_child_register_additional_customizer_settings( $wp_customize ) {
    // Add your customizer settings here
    $wp_customize->add_section( 'theme_info', array(
        'title'       => __( 'Demo & Documentation', 'lora-business-one-page' ),
        'priority'    => 6,
    ) );

    /** Important Links */
    $wp_customize->add_setting( 'theme_info_theme_child',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $theme_info = '';
    $theme_info .= sprintf( '<p>' . __( 'Pro Demo Link: %1$sClick here.%2$s', 'lora-business-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/previews/?theme=lora' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( '<p>' . __( 'Documentation Link: %1$sClick here.%2$s', 'lora-business-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/docs/spirallite/' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( '<p>' . __( 'Video Tutorial Link: %1$sClick here.%2$s', 'lora-business-one-page' ) . '</p>', '<a href="' . esc_url( 'https://www.youtube.com/watch?v=6FyecnWnJtk' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( '<p>' . __( 'Get support: %1$sClick here.%2$s', 'lora-business-one-page' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.freshdesk.com/support/tickets/new' ) . '" target="_blank">', '</a>' );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize,
        'theme_info_theme_child',
        array(
            'section'     => 'theme_info',
            'description' => $theme_info,
            'type'        => 'hidden',
        )
    ));
}
add_action( 'customize_register', 'lora_business_one_page_child_register_additional_customizer_settings' );

function lora_business_one_page_child_theme_customize_register( $wp_customize ) {
    // Overriding the $upgrade_description from the parent theme.
    $upgrade_description = sprintf( 
        __( '%1$sUnlock the full potential of the section by upgrading to Pro.%2$s %3$sUnlock Now%4$s ', 'lora-business-one-page' ),
        '<div class="pro-version-button"><span>',
        '</span>',
        '<a href="https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/" target="_blank">',
        '</a></div>'
    );
    
    // Modify the existing control if necessary.
    $wp_customize->get_control('team_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('portfolio_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('client_sec_unlock')->description = $upgrade_description;
    $wp_customize->get_control('testimonials_sec_unlock')->description = $upgrade_description;
}

add_action( 'customize_register', 'lora_business_one_page_child_theme_customize_register', 20 );

add_action('customize_register', function($wp_customize) {
   
     // Landing Page Section
      // Slider Buttons Header Section
    $wp_customize->add_setting(
        'slider_head_img_setting_options',
        array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'spirallite_sanitize_text',
            'priority' => 4,
        )
    );
    
    $wp_customize->add_control(
        'slider_head_img_setting_options',
        array(
            'type' => 'hidden',
            'label' => __('Slider Images', 'lora-business-one-page'),
            'section' => 'spirallite_landing_page_settings',
        )
    );
     // Slider Image
    $wp_customize->add_setting(
        'slider-bg-1',
        array(
        //  'default'           => '',
            'default'           => get_stylesheet_directory_uri() . '/images//slider/slider1.jpg', // Default image URL
            'transport'         => 'refresh',
            'sanitize_callback' => 'esc_url_raw', // Ensure it's a valid URL
        )
    );

    // Add the control
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'slider-bg-1',
            array(
                'label'    => __( 'Slider Img 1', 'lora-business-one-page' ),
                'section'  => 'spirallite_landing_page_settings',
                'settings' => 'slider-bg-1', // Corrected to match the setting ID
            )
        )
    );

     // Slider Image 2
     $wp_customize->add_setting(
        'slider-bg-2',
        array(
        //  'default'           => '',
            'default'           => get_stylesheet_directory_uri() . '/images/slider/slider2.jpg', // Default image URL
            'transport'         => 'refresh',
            'sanitize_callback' => 'esc_url_raw', // Ensure it's a valid URL
        )
    );

    // Add the control
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'slider-bg-2',
            array(
                'label'    => __( 'Slider Img 2', 'lora-business-one-page' ),
                'section'  => 'spirallite_landing_page_settings',
                'settings' => 'slider-bg-2', // Corrected to match the setting ID
            )
        )
    );

    // Slider Image 3
    $wp_customize->add_setting(
        'slider-bg-3',
        array(
        //  'default'           => '',
            'default'           => get_stylesheet_directory_uri() . '/images/slider/slider3.jpg', // Default image URL
            'transport'         => 'refresh',
            'sanitize_callback' => 'esc_url_raw', // Ensure it's a valid URL
        )
    );

    // Add the control
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'slider-bg-3',
            array(
                'label'    => __( 'Slider Img 3', 'lora-business-one-page' ),
                'section'  => 'spirallite_landing_page_settings',
                'settings' => 'slider-bg-3',
            )
        )
    );

    // Slider Captions Header Section
 $wp_customize->add_setting(
    'slider_head_captions_setting_options',
    array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'spirallite_sanitize_text',
        'priority' => 5,
    )
);

$wp_customize->add_control(
    'slider_head_captions_setting_options',
    array(
        'type' => 'hidden',
        'label' => __('Captions', 'lora-business-one-page'),
        'section' => 'spirallite_landing_page_settings',
    )
);

$wp_customize->add_setting(
	'slider-cations-1',
	array(
		'default'           => __( '<h1>Creative <span>Ideas</span></h1>', 'lora-business-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-1',
	array(
		'label' => __( 'Slider Cation 1', 'lora-business-one-page' ),
		'section' => 'spirallite_landing_page_settings',
		'type' => 'text',
	)
);

$wp_customize->add_setting(
	'slider-cations-2',
	array(
		'default'           => __( '<h1>Creative <span>Design</span>', 'lora-business-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-2',
	array(
		'label' => __( 'Slider Cation 2', 'lora-business-one-page' ),
		'section' => 'spirallite_landing_page_settings',
		'type' => 'text',
	)
);

$wp_customize->add_setting(
	'slider-cations-3',
	array(
		'default'           => __( '<h1>Creative <span>Solutions</span>', 'lora-business-one-page' ),
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'slider-cations-3',
	array(
		'label' => __( 'Slider Cation 3', 'lora-business-one-page' ),
		'section' => 'spirallite_landing_page_settings',
		'type' => 'text',
	)
);

if ( ! class_exists( 'SpiralLite_Note_Control_Note_Control' ) ) {
    require_once get_template_directory() . '/inc/custom-controls/note/class-note-control.php';
}

/** Note */
$wp_customize->add_setting(
'slider_sec_unlock',
array(
    'default'           => '',
    'sanitize_callback' => 'wp_kses_post' 
)
);

$wp_customize->add_control(
new SpiralLite_Note_Control_Note_Control( 
    $wp_customize,
    'slider_sec_unlock',
    array(
        'section'     => 'spirallite_landing_page_settings',
        'description' => sprintf( __( '%1$sUnlimited feature Captions, Images is available in Pro version.%2$s %3$sUpgrade to Pro%4$s ', 'lora-business-one-page' ),'<div class="pro-version-button"><span>', '</span>', '<a href="https://pixelonetry.com/downloads/lora-creative-one-page-parallax-wordpress-theme/" target="_blank">', '</a></div>' ),

    )
)
);	

});



/**
 * Admin Notice for Spiral Lite One Page Theme (Child Theme)
 */

function lora_business_one_page_child_theme_remove_parent_admin_notice() {
    remove_action('admin_notices', 'spiral_lite_one_page_admin_notice');
}

add_action('init', 'lora_business_one_page_child_theme_remove_parent_admin_notice'); // Remove the parent theme's notice


/**
 * EXTRAS
 */
// 1. REMOVE THE PARENT THEME FUNCTION
function lora_business_one_page_remove_parent_social_action() {
    remove_action( 'spirallite_social', 'spirallite_social_cb' );
}
add_action( 'after_setup_theme', 'lora_business_one_page_remove_parent_social_action' );

// 2. NEW default FUCNTIONS
function lora_social_cb() {
    $facebook  = get_theme_mod( 'spirallite_facebook' );
    $twitter   = get_theme_mod( 'spirallite_twitter' );
    $pinterest = get_theme_mod( 'spirallite_pinterest' );
    $linkedin  = get_theme_mod( 'spirallite_linkedin' );
    $instagram = get_theme_mod( 'spirallite_instagram' );
    $youtube   = get_theme_mod( 'spirallite_youtube' );
    $tiktok    = get_theme_mod( 'spirallite_tiktok' );

    if ( $facebook || $twitter || $pinterest || $linkedin || $instagram || $youtube || $tiktok ) { ?>
        <div class="icons">
            <?php 
                if ( $facebook ) echo '<a href="' . esc_url( $facebook ) . '" target="_blank" title="' . esc_attr__( 'Facebook', 'spiral-lite-one-page' ) . '"><i class="fa fa-facebook"></i></a>';
                if ( $twitter ) echo '<a href="' . esc_url( $twitter ) . '" target="_blank" title="' . esc_attr__( 'Twitter', 'spiral-lite-one-page' ) . '"><i class="fa fa-twitter"></i></a>'; 
                if ( $pinterest ) echo '<a href="' . esc_url( $pinterest ) . '" target="_blank" title="' . esc_attr__( 'Pinterest', 'spiral-lite-one-page' ) . '"><i class="fa fa-pinterest-p"></i></a>';
                if ( $linkedin ) echo '<a href="' . esc_url( $linkedin ) . '" target="_blank" title="' . esc_attr__( 'LinkedIn', 'spiral-lite-one-page' ) . '"><i class="fa fa-linkedin"></i></a>';
                if ( $instagram ) echo '<a href="' . esc_url( $instagram ) . '" target="_blank" title="' . esc_attr__( 'Instagram', 'spiral-lite-one-page' ) . '"><i class="fa fa-instagram"></i></a>';
                if ( $youtube ) echo '<a href="' . esc_url( $youtube ) . '" target="_blank" title="' . esc_attr__( 'YouTube', 'spiral-lite-one-page' ) . '"><i class="fa fa-youtube"></i></a>';
                if ( $tiktok ) echo '<a href="' . esc_url( $tiktok ) . '" target="_blank" title="' . esc_attr__( 'TikTok', 'spiral-lite-one-page' ) . '"><i class="fab fa-tiktok"></i></a>';
            ?>
        </div>
    <?php }
}
// 3. CONNECT THE `spirallite_social` hook's
add_action( 'spirallite_social', 'lora_social_cb' );

// 1. REMOVE THE PARENT THEME FUNCTION
function lora_business_one_page_remove_parent_social_top_action() {
    remove_action( 'spirallite_social_top', 'spirallite_social__header' );
}
add_action( 'after_setup_theme', 'lora_business_one_page_remove_parent_social_top_action' );

// 2. NEW default FUCNTIONS
function lora_social__header() {
    $facebook  = get_theme_mod( 'spirallite_facebook' );
    $twitter   = get_theme_mod( 'spirallite_twitter' );
    $pinterest = get_theme_mod( 'spirallite_pinterest' );
    $linkedin  = get_theme_mod( 'spirallite_linkedin' );
    $instagram = get_theme_mod( 'spirallite_instagram' );
    $youtube   = get_theme_mod( 'spirallite_youtube' );
    $tiktok    = get_theme_mod( 'spirallite_tiktok' );

    if ( $facebook || $twitter || $pinterest || $linkedin || $instagram || $youtube || $tiktok ) { ?>
       <div class="social-icon fa-social-hover">
		<?php 
            if( $facebook ) echo '<a href="'. esc_url( $facebook ) .'" target="_blank" title="'. esc_attr__( 'Facebook', 'spiral-lite-one-page' ) .'"><i class="fa fa-facebook"></i></a>';
            if( $twitter ) echo '<a href="'. esc_url( $twitter ) .'" target="_blank" title="'. esc_attr__( 'Twitter', 'spiral-lite-one-page' ) .'"><i class="fa fa-twitter"></i></a>'; 
            if( $pinterest ) echo '<a href="'. esc_url( $pinterest ) .'" target="_blank" title="'. esc_attr__( 'Pinterest', 'spiral-lite-one-page' ) .'"><i class="fa fa-pinterest-p"></i></a>';
            if( $linkedin ) echo '<a href="'. esc_url( $linkedin ) .'" target="_blank" title="'. esc_attr__( 'LinkedIn', 'spiral-lite-one-page' ) .'"><i class="fa fa-linkedin"></i></a>';
            if( $instagram ) echo '<a href="'. esc_url( $instagram ) .'" target="_blank" title="'. esc_attr__( 'Instagram', 'spiral-lite-one-page' ) .'"><i class="fa fa-instagram"></i></a>';
            if( $youtube ) echo '<a href="'. esc_url( $youtube ) .'" target="_blank" title="'. esc_attr__( 'YouTube', 'spiral-lite-one-page' ) .'"><i class="fa fa-youtube"></i></a>';
            if( $tiktok ) echo '<a href="'. esc_url( $tiktok ) .'" target="_blank" title="'. esc_attr__( 'Tiktok', 'spiral-lite-one-page' ) .'"><i class="fab fa-tiktok"></i></a>';
        ?>
	</div>
    <?php }
}
// 3. CONNECT THE `spirallite_social` hook's
add_action( 'spirallite_social_top', 'lora_social__header' );

?>


