<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package loose
 */

get_header(); ?>
<div class="row">
		<div id="primary" class="content-area col-lg-8
		<?php
		if ( ! is_active_sidebar( 'sidebar-1' ) ) {
			echo ' col-lg-push-2'; }
		?>
">
		<main id="main" class="site-main row" role="main">

			<?php
			while ( have_posts() ) :
				the_post();
				?>

							<article id="post-<?php the_ID(); ?>" <?php post_class( 'col-md-12' ); ?>>

									<header class="entry-header">

											<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

									</header><!-- .entry-header -->


									<div class="entry-content">
											<?php the_content(); ?>
											<?php
													wp_link_pages(
														array(
															'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'loose' ),
															'after'  => '</div>',
														)
													);
											?>
									</div><!-- .entry-content -->

									<footer class="entry-footer">
											<?php edit_post_link( esc_html__( 'Edit', 'loose' ), '<span class="edit-link">', '</span>' ); ?>
									</footer><!-- .entry-footer -->

							</article><!-- #post-## -->

				<?php
					// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
					endif;
				?>

			<?php endwhile; // End of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
</div><!-- .row -->
<?php get_footer(); ?>
