<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */
get_header();
?>
<!-- *** Single Post Starts *** -->
<!-- ***breadcrum Starts*** -->
<div single-post>
<?php lookway_breadcrum_block() ?>
<!-- ***breadcrum ends*** -->
<div class="blogpost-wrapper">
        <div class="single-post">
            <div class="blogpost-content">
                <div class="col-md-8 single-blogpost">
                    <!-- *** Post loop starts *** -->
                    <!-- *** Post1 Starts *** -->
					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?> 
							<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
								<div class="post-page">
									<h3 class="post-page-head"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php echo PERMANENT_LINK; ?><?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
									
									<div class="post-content">
									<?php the_post_thumbnail( 'thumbnail', array( 'class' => 'alignleft' ) ); ?>
									<?php the_content(); ?>
								
									
									<ul class="post-meta">
										<li><?php echo POSTED_DATE;?><?php
											$archive_year = get_the_time( 'Y' );
											$archive_month = get_the_time( 'm' );
											$archive_day = get_the_time( 'd' );
											?>
											<a href="<?php
											echo get_day_link( $archive_year, $archive_month, $archive_day );
											?>"><?php echo esc_html( get_the_date() ) ?></a> </li>
										<li><?php echo POSTED_BY;?>&nbsp;<?php the_author_posts_link(); ?>&nbsp;</li>
										<li><?php echo POSTED_CATE;?>&nbsp;<?php the_category( ', ' ); ?>&nbsp;</li>
										<li class="comments"><?php echo POSTED_COMMENT; ?><?php
											comments_popup_link( '0', '1', '%' );
											?></li>
										<div class="clearfix"></div>
									</ul>
								</div>
									<nav id="nav-single"> <span class="nav-previous"> 
											<?php previous_post_link( '%link', __( '<span class="meta-nav">&larr;</span> Previous Post ', 'lookway' ) ); ?> 
										</span> <span class="nav-next"> 
											<?php next_post_link( '%link', __( 'Next Post <span class="meta-nav">&rarr;</span>', 'lookway' ) ); ?> 
										</span> 
									</nav>
									<?php wp_link_pages(); ?>
									<ol class="commentlist">
										<?php wp_list_comments(); ?>
									</ol>
									<?php comments_template(); ?>
									<?php comment_form(); ?>
								</div>
							</div>
							<?php
						endwhile;
					else:
						?>
						<div>
							<p>
								<?php echo SORRY_NO_POSTS; ?>
							</p>
						</div>
					<?php endif; ?>
                    <div class="clearfix"></div>
                </div>
                <div class="col-md-4">
                    <!-- *** Sidebar Starts *** -->
					<?php get_sidebar(); ?>
                    <!-- *** Sidebar Ends *** -->
                </div>
            </div>
        </div>
</div>
</div>
<div class="clearfix"></div>

<?php get_footer(); ?>