<?php
/**
 * @package LookWay
 * @since LookWay 1.0
 */
get_header();
?>
<!-- Header -->
<div class="clearfix"></div>
<header id="head">
	<div class="">
		<div class="row">
			<div class=' col-md-12 sliderimg'>
				<a href="<?php echo esc_url( get_theme_mod( 'lookway_banner_image' ) ); ?>" ><?php if ( get_theme_mod( 'lookway_banner_image' ) != '' ) { ?><img src="<?php echo esc_url( get_theme_mod( 'lookway_banner_image' ) ); ?>" alt="<?php echo IMAGE_HOME_PAGE; ?>"/>
					<?php } else { ?>
						<img src="<?php echo get_template_directory_uri(); ?>/images/222.jpg" alt="<?php echo IMAGE_HOME_PAGE; ?>"/><?php } ?></a>
				<div class="col-md-3 caption conference">
                    <h2><a href="
						<?php if ( get_theme_mod( 'lookway_banner_link' ) != '' ) { ?>
							<?php echo esc_html( get_theme_mod( 'lookway_banner_link' ) ); ?>
						<?php } else { ?>
							<?php echo esc_url( home_url() ); ?>
						<?php } ?>
						   ">
							   <?php if ( get_theme_mod( 'lookway_banner_heading' ) != '' ) { ?>
								   <?php echo esc_html( get_theme_mod( 'lookway_banner_heading' ) ); ?>
							   <?php } else { ?>
								Complete Business Solution
							<?php } ?>
						</a></h2>
					<?php if ( get_theme_mod( 'lookway_banner_description' ) != '' ) { ?>
						<p><?php echo esc_html( get_theme_mod( 'lookway_banner_description' ) ); ?></p>
					<?php } else { ?>
						<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</header>
<!-- /Header -->
<!-- Intro -->
<div class="text-center myheading zoomInUp animated">
	<h1 class="thin ">
		<?php if ( get_theme_mod( 'lookway_welcome_Heading' ) != '' ) { ?>
			<?php echo esc_html( get_theme_mod( 'lookway_welcome_Heading' ) ); ?>
		<?php } else { ?>
			Elegant and Simple Responsive WordPress Theme.
		<?php } ?>
	</h1>
	<p class="text-muted">
		<?php if ( get_theme_mod( 'lookway_welcome_description' ) != '' ) { ?>
			<?php echo esc_html( get_theme_mod( 'lookway_welcome_description' ) ); ?>
		<?php } else { ?>
			Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
		<?php } ?>
	</p>
</div>
<!-- /Intro-->
<!-- Highlights - jumbotron -->
<?php
$option = get_theme_mod( "lookway_feature_setting" );
if (isset($option)) {
	?>
	<div class="">
		<div class="or-spacer">
			<div class="mask"></div>
		</div>
		<h2 class="text-center thin section-heading">
			<?php if ( get_theme_mod( 'lookway_feature_area_heading' ) != '' ) { ?>
				<?php echo sanitize_text_field( get_theme_mod( 'lookway_feature_area_heading' ) ); ?>
			<?php } else { ?>
				What We Do
			<?php } ?>
		</h2>
		<div class="feature">
			<div class="row">
				<div class="col-md-12 col-sm-12 ">	
					<?php
					lookway_feature_area_items();
					?>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
		<!-- /row  -->
	</div>
	<!-- /Highlights -->
<?php } ?>
<?php
$option = get_theme_mod( "lookway_middle_setting" );
if (isset($option)) {
	?>
	<div class="or-spacer">
		<div class="mask"></div>
	</div>
	<div class="col-md-12 about-project-section">
		<div class="col-md-6 fadeInLeft animated">				
			<h2 class="text-center thin section-heading">			
				<?php
				if ( get_theme_mod( 'lookway_aboutus_heading' ) ) : echo esc_attr( get_theme_mod( 'lookway_aboutus_heading' ) );
				else: echo 'About Us';
				endif;
				?>
			</h2>
			<div class="text-muted">
				<?php if ( get_theme_mod( 'lookway_aboutus_description' ) != '' ) { ?>
					<?php echo sanitize_text_field( get_theme_mod( 'lookway_aboutus_description' ) ); ?>		
				<?php } else { ?>			
					Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.
				<?php } ?>
			</div>	
		</div>
		<div class="col-md-6 fadeInRight animated">
			<h2 class="text-center thin section-heading">
				<?php
				if ( get_theme_mod( 'lookway_project_Heading' ) ) : echo esc_attr( get_theme_mod( 'lookway_project_Heading' ) );
				else: echo 'Latest Project';
				endif;
				?>
			</h2>		
			<div class="home-project-image">
				<img src="<?php
				if ( get_theme_mod( 'lookway_project_image' ) ) : echo esc_attr( get_theme_mod( 'lookway_project_image' ) );
				else: echo get_template_directory_uri() . '/images/41.png';
				endif;
				?> " alt="<?php echo IMAGE_HOME_PAGE; ?>" />

			</div>			
		</div>
	</div>
<?php } ?>
<div class="">
	<?php
	$option = get_theme_mod( "lookway_blog_setting" );
	if (isset($option)) {
		?>
		<div class="col-md-12 zoomInUp animated">
			<div class="or-spacer">
				<div class="mask"></div>
			</div>
			<div class="">
				<h2 class="blog_head text-center thin"><?php
					if ( get_theme_mod( 'lookway_blog_Heading' ) ) : echo esc_attr( get_theme_mod( 'lookway_blog_Heading' ) );
					else: echo 'Latest Article';
					endif;
					?></h2>
				<?php get_template_part( 'loop', 'index' ); ?>
			</div>
		</div>
	<?php } ?>
</div>
<?php get_footer(); ?>