<?php
/**
 * @package LookWay
 * @since LookWay 1.0
 */
?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
	<!--<![endif]-->
	<html lang="en">
		<head>
			<meta charset="<?php bloginfo( 'charset' ); ?>">
			<meta name="viewport" content="width=device-width">
			<title><?php wp_title( '|', true, 'right' ); ?></title>
			<link rel="profile" href="http://gmpg.org/xfn/11">
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
			<?php
			wp_head();
			?>
		</head>
		<body background="" <?php body_class(); ?>>
			<div class="container mainouterdiv">
				<div class="header row" background="<?php esc_html(header_textcolor()); ?>"	>
					<div class="col-md-5">
						<div class=" logo">
							<a href="<?php echo esc_url( home_url() ); ?>">
								<h1><?php esc_html( bloginfo( 'name' ) ); ?></h1>
								<p><?php esc_html( bloginfo( 'description' ) ); ?> </p>
							</a>
						</div>
						<div class="clearfix"></div>
					</div>
					<!-- Fixed navbar -->
					<div class="col-md-7">
						<div class="navbar-header">
							<div class="menu-bar" id="primary_nav_wrap">
								<?php
								lookway_nav();
								?>
							</div>
							
							
							
						</div>
					</div>
				</div>
				<div class="clearfix"></div>
