<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
/***Adds the individual sections, settings, and controls to the theme customizer**/
add_action( 'customize_register', 'lookway_theme_customize' );
function lookway_theme_customize( $wp_customize ) {
/***Adds textarea support to the theme customizer**/
	class lookway_Customize_Textarea_Control extends WP_Customize_Control {
		public $type = 'textarea';
		public function render_content() {
			?>
			<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
			</label>
			<?php
		}
	}
/***BANNER IMAGE SETTINGS**/
	$wp_customize->add_section( 'lookway_banner_section', array(
		'title' => Banner_Image_Setting,
		'priority' => 25,
		'description' => Banner_Image_Setting_detail_desc,
	) );
   $wp_customize->add_setting( 'lookway_banner_image', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_banner_image', array(
		'label' => Banner_Image,
		'section' => 'lookway_banner_section',
		'settings' => 'lookway_banner_image',
		'priority' => 1,
	) ) );
	$wp_customize->add_setting( 'lookway_banner_heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_banner_heading', array(
		'label' => Banner_Heading,
		'section' => 'lookway_banner_section',
		'settings' => 'lookway_banner_heading',
		'priority' => 2,
			))
	);
	$wp_customize->add_setting( 'lookway_banner_link', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( 'lookway_banner_link', array(
		'label' => Banner_Link,
		'section' => 'lookway_banner_section',
		'type' => 'text',
		'settings' => 'lookway_banner_link',
		'priority' => 3,
	) );
	$wp_customize->add_setting( 'lookway_banner_description'
			, array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_banner_description', array(
		'label' => Banner_Description,
		'section' => 'lookway_banner_section',
		'settings' => 'lookway_banner_description',
		'priority' => 4,
			))
	);
/*****BANNER IMAGE SETTINGS END***/
/*****WELCOME SECTION SETTINGS***/
	$wp_customize->add_section( 'lookway_welcome_section', array(
		'title' => Welcome_Section_Setting,
		'priority' => 35,
		'description' => Welcome_Section_Setting_desc,
	) );
	$wp_customize->add_setting( 'lookway_welcome_Heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_welcome_Heading', array(
		'label' => Welcome_Heading,
		'section' => 'lookway_welcome_section',
		'settings' => 'lookway_welcome_Heading',
		'priority' => 1,
			))
	);
	$wp_customize->add_setting( 'lookway_welcome_description', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_welcome_description', array(
		'label' => Welcome_Description,
		'section' => 'lookway_welcome_section',
		'settings' => 'lookway_welcome_description',
		'priority' => 2,
			))
	);
/***WELCOME SECTION SETTINGS END***/
/***FEATURE AREA  SECTION SETTINGS***/
	$wp_customize->add_section( 'lookway_feature_area_section', array(
		'title' => Feature_Area_Setting,
		'priority' => 40,
		'description' => Feature_Area_Setting_desc,
	) );
	/***Add feature area selection***/
	$wp_customize->add_setting( 'lookway_feature_setting', array(
		'type' => 'theme_mod',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'lookway_sanitize_checkbox',
		'default' => true,
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'lookway_feature_setting', array(
		'settings' => 'lookway_feature_setting',
		'label' => Show_feature_area,
		'section' => 'lookway_feature_area_section',
		'type' => 'checkbox',
		'priority' => 1,
	) ) );
	/***Add feature area main Heading***/
	$wp_customize->add_setting( 'lookway_feature_area_heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_area_heading', array(
		'label' => Feature_Section_Heading,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_area_heading',
		'priority' => 2,
			)
			)
	);
	/***Add first feature area***/
	$wp_customize->add_setting( 'lookway_feature_image_1', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_feature_image_1', array(
		'label' => First_Feature_Image,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_image_1',
		'priority' => 3,
	) ) );
	$wp_customize->add_setting( 'lookway_feature_heading_1', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_heading_1', array(
		'label' => First_Feature_Heading,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_heading_1',
		'priority' => 4,
			))
	);
	$wp_customize->add_setting( 'lookway_feature_link_1', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( 'lookway_feature_link_1', array(
		'label' => First_Feature_Link,
		'section' => 'lookway_feature_area_section',
		'type' => 'text',
		'settings' => 'lookway_feature_link_1',
		'priority' => 5,
	) );
	$wp_customize->add_setting( 'lookway_feature_description_1', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_description_1', array(
		'label' => First_Feature_Description,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_description_1',
		'priority' => 6,
			))
	);
	/***Add second feature area***/
	$wp_customize->add_setting( 'lookway_feature_image_2', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_feature_image_2', array(
		'label' => Second_Feature_Image,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_image_2',
		'priority' => 7,
	) ) );
	$wp_customize->add_setting( 'lookway_feature_heading_2', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_heading_2', array(
		'label' => Second_Feature_Heading,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_heading_2',
		'priority' => 8,
			))
	);
	$wp_customize->add_setting( 'lookway_feature_link_2', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( 'lookway_feature_link_2', array(
		'label' => Second_Feature_Link,
		'section' => 'lookway_feature_area_section',
		'type' => 'text',
		'settings' => 'lookway_feature_link_2',
		'priority' => 9,
	) );
	$wp_customize->add_setting( 'lookway_feature_description_2', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_description_2', array(
		'label' => Second_Feature_Description,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_description_2',
		'priority' => 10,
			))
	);
	/***Add third feature area***/
	$wp_customize->add_setting( 'lookway_feature_image_3', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_feature_image_3', array(
		'label' => Third_Feature_Image,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_image_3',
		'priority' => 11,
	) ) );
	$wp_customize->add_setting( 'lookway_feature_heading_3', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_heading_3', array(
		'label' => Third_Feature_Heading,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_heading_3',
		'priority' => 12,
			))
	);
	$wp_customize->add_setting( 'lookway_feature_link_3', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( 'lookway_feature_link_3', array(
		'label' => Third_Feature_Link,
		'section' => 'lookway_feature_area_section',
		'type' => 'text',
		'settings' => 'lookway_feature_link_3',
		'priority' => 13,
	) );
	$wp_customize->add_setting( 'lookway_feature_description_3', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_description_3', array(
		'label' => Third_Feature_Description,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_description_3',
		'priority' => 14,
			))
	);
	/***Add fourth feature area***/
	$wp_customize->add_setting( 'lookway_feature_image_4', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_feature_image_4', array(
		'label' => Fourth_Feature_Image,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_image_4',
		'priority' => 15,
	) ) );
	$wp_customize->add_setting( 'lookway_feature_heading_4', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_feature_heading_4', array(
		'label' => Fourth_Feature_Heading,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_heading_4',
		'priority' => 16,
			))
	);
	$wp_customize->add_setting( 'lookway_feature_link_4', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( 'lookway_feature_link_4', array(
		'label' => Fourth_Feature_Link,
		'section' => 'lookway_feature_area_section',
		'type' => 'text',
		'settings' => 'lookway_feature_link_4',
		'priority' => 17,
	) );
	$wp_customize->add_setting( 'lookway_feature_description_4', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
		new lookway_Customize_Textarea_Control(
		$wp_customize, 'lookway_feature_description_4', array(
		'label' => Fourth_Feature_Description,
		'section' => 'lookway_feature_area_section',
		'settings' => 'lookway_feature_description_4',
		'priority' => 18,
			))	
			);

/***FEATURE AREA  SECTION SETTINGS END***/
/***PROJECT ABOUT US  SECTION SETTINGS***/
	$wp_customize->add_section( 'lookway_middle_section', array(
		'title' => Project_About_Us_Setting,
		'priority' => 45,
	) );
	$wp_customize->add_setting( 'lookway_middle_setting', array(
		'type' => 'theme_mod',
		'sanitize_callback' => 'lookway_sanitize_checkbox',
		'default' => true,
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'lookway_middle_setting', array(
		'settings' => 'lookway_middle_setting',
		'label' => Show_this_section,
		'section' => 'lookway_middle_section',
		'type' => 'checkbox',
		'sanitize_callback' => 'lookway_sanitize_checkbox',
		'priority' => 1,
	) ) );
	$wp_customize->add_setting( 'lookway_aboutus_heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_aboutus_heading', array(
		'label' => AboutUs_Section_Heading,
		'section' => 'lookway_middle_section',
		'settings' => 'lookway_aboutus_heading',
		'priority' => 2,
			))
	);
	$wp_customize->add_setting( 'lookway_aboutus_description', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_aboutus_description', array(
		'label' => AboutUs_Section_Description,
		'section' => 'lookway_middle_section',
		'settings' => 'lookway_aboutus_description',
		'priority' => 3,
			))
	);
	$wp_customize->add_setting( 'lookway_project_Heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_project_Heading', array(
		'label' => Project_Section_Heading,
		'section' => 'lookway_middle_section',
		'settings' => 'lookway_project_Heading',
		'priority' => 4,
			))
	);
	$wp_customize->add_setting( 'lookway_project_image', array(
		'sanitize_callback' => 'esc_url',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'lookway_project_image', array(
		'label' => Project_Image,
		'section' => 'lookway_middle_section',
		'settings' => 'lookway_project_image',
		'priority' => 5,
	) ) );
/***PROJECT ABOUT US SECTION SETTINGS END***/
/***BLOG SECTION SETTINGS***/
	$wp_customize->add_section( 'lookway_blog_section', array(
		'title' => Blog_Post_Section,
		'priority' => 50,
	) );
	$wp_customize->add_setting( 'lookway_blog_setting', array(
		'type' => 'theme_mod',
		'sanitize_callback' => 'lookway_sanitize_checkbox',
		'default' => true,
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'lookway_blog_setting', array(
		'settings' => 'lookway_blog_setting',
		'label' => Show_blog_posts,
		'section' => 'lookway_blog_section',
		'type' => 'checkbox',
		'sanitize_callback' => 'lookway_sanitize_checkbox',
		'priority' => 1,
	) ) );
	$wp_customize->add_setting( 'lookway_blog_Heading', array(
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control(
			new lookway_Customize_Textarea_Control(
			$wp_customize, 'lookway_blog_Heading', array(
		'label' => Blog_Section_Heading,
		'section' => 'lookway_blog_section',
		'settings' => 'lookway_blog_Heading',
		'priority' => 2,
			))
	);
/***BLOG SECTION SETTINGS END***/
/***FOOTER SECTION SETTINGS***/
	$wp_customize->add_section( 'lookway_footer_section', array(
		'title' => Footer_Setting,
		'priority' => 55,
	) );
	$wp_customize->add_setting( 'lookway_footer_text', array(
		'default' => 'default_value',
		'sanitize_callback' => 'lookway_text_sanitize',
	) );
	$wp_customize->add_control( 'lookway_footer_text', array(
		'label' => Footer_Text_Setting,
		'section' => 'lookway_footer_section',
		'type' => 'text',
		'settings' => 'lookway_footer_text',
		'priority' => 1,
	) );
}
/***Checkbox Sanitization***/
function lookway_sanitize_checkbox( $input ) {
	if ( $input == 1 ) {
		return 1;
	} else {
		return '';
	}
}
function lookway_text_sanitize( $input ) {
	return strip_tags( sanitize_text_field( $input ) );
}
?>