<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
$functions_path = get_template_directory() . '/functions/';
require_once ($functions_path . 'define_template.php');
require_once ($functions_path . 'customizer_file.php');  // Customize theme
require_once ($functions_path . 'advance_function.php');  //
/* These files build out the theme specific options and associated functions. */
/* ----------------------------------------------------------------------------------- */
/* Styles Enqueue */
/* ----------------------------------------------------------------------------------- */

function lookway_add_stylesheet() {
	wp_enqueue_style( 'lookway_Main_Css', get_template_directory_uri() . "/style.css" );
	wp_enqueue_style( 'lookway_bootstrap_Css', get_template_directory_uri() . "/css/bootstrap.css" );
	wp_enqueue_style( 'lookway_animation_Css', get_template_directory_uri() . "/css/animate.css" );
	wp_enqueue_style( 'lookway_mobilemenu_Css', get_template_directory_uri() . "/css/meanmenu.min.css" );
}
add_action( 'wp_enqueue_scripts', 'lookway_add_stylesheet' );
/* ----------------------------------------------------------------------------------- */
/* jQuery Enqueue */
/* ----------------------------------------------------------------------------------- */
function lookway_wp_enqueue_scripts() {
	wp_enqueue_script( 'lookway-bootstrap', get_template_directory_uri() . '/js/bootstrap.js', array( 'jquery' ) );
	wp_enqueue_script( 'lookway-mobilemenu', get_template_directory_uri() . '/js/jquery.meanmenu.min.js', array( 'jquery' ) );
	wp_enqueue_script( 'lookway-custom-js', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ) );
	wp_enqueue_style( 'lookway_font-awesome', get_template_directory_uri() . '/fonts/font-awesome/css/font-awesome.css' );
	if ( is_singular() )
		wp_enqueue_script( 'comment-reply' );
}
add_action( 'wp_enqueue_scripts', 'lookway_wp_enqueue_scripts' );
/* ----------------------------------------------------------------------------------- */
/* Register Widget Area */
/* ----------------------------------------------------------------------------------- */
/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 *
 * @uses register_sidebar
 */
function lookway_widgets_init() {
//Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => PRIMARY_WIDGET,
		'id' => 'primary-widget-area',
		'description' => PRIMARY_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
//Area 2, located below the Primary Widget Area in the sidebar. Empty by default.
	register_sidebar( array(
		'name' => SECONDRY_WIDGET,
		'id' => 'secondary-widget-area',
		'description' => SECONDRY_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
//Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => FIRST_FOOTER_WIDGET,
		'id' => 'first-footer-widget-area',
		'description' => FIRST_FOOTER_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
//Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => SECONDRY_FOOTER_WIDGET,
		'id' => 'second-footer-widget-area',
		'description' => SECONDRY_FOOTER_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
//Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => THIRD_FOOTER_WIDGET,
		'id' => 'third-footer-widget-area',
		'description' => THIRD_FOOTER_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
//Area 6, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => FOURTH_FOOTER_WIDGET,
		'id' => 'fourth-footer-widget-area',
		'description' => FOURTH_FOOTER_WIDGET,
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	) );
}
/** Register sidebars by running lookway_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'lookway_widgets_init' );
/* ----------------------------------------------------------------------------------- */
/* Menu Registration */
/* ----------------------------------------------------------------------------------- */
add_action( 'after_setup_theme', 'lookway_register_my_menu' );
function lookway_register_my_menu() {
	register_nav_menus( array(
		'header_menu' => HOME_MENU,
		'frontpage-menu' => FRONT_MENU,
		'footer-menu' => FOOTER_MENU
			)
	);
}
/* ----------------------------------------------------------------------------------- */
/* Page Navigation */
/* ----------------------------------------------------------------------------------- */
if ( !function_exists( 'lookway_content_nav' ) ) :
	function lookway_content_nav( $html_id ) {
		global $wp_query;
		$html_id = esc_attr( $html_id );
		if ( $wp_query->max_num_pages > 1 ) :
			?>
			<nav id="<?php echo $html_id; ?>" class="navigation" role="navigation">
				<h3 class="assistive-text"><?php _e( 'Post navigation', 'lookway' ); ?></h3>
				<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'lookway' ) ); ?></div>
				<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'lookway' ) ); ?></div>
			</nav><!-- #<?php echo $html_id; ?> .navigation -->
			<?php
		endif;
	}
endif;
/* ----------------------------------------------------------------------------------- */
/* Breadcrumb html */
/* ----------------------------------------------------------------------------------- */
function lookway_breadcrum_block() {
	?>
	<div class="col-md-12">
		<div class="breadcrum">
			<h4><?php if ( function_exists( 'lookway_breadcrumbs' ) ) lookway_breadcrumbs(); ?></h4>
		</div>
	</div>
	<?php
}
/* ----------------------------------------------------------------------------------- */
/* Breadcrumbs code
  /*----------------------------------------------------------------------------------- */
function lookway_breadcrumbs() {
	echo '<div id="crumbs">';
	if ( !is_home() ) {
		echo '<a href="';
		echo esc_url( home_url() );
		;
		echo '">';
		esc_html( bloginfo( 'name' ) );
		echo "</a> | ";
		if ( is_category() || is_single() ) {
			if ( is_category() ) {
				//the_category('|');
				single_cat_title( '', true );
			} elseif ( is_single() ) {
				the_title();
			}
		} elseif ( is_page() ) {
			echo the_title();
		}
	}
	echo '</div>';
}
/* ----------------------------------------------------------------------------------- */
/* Pagination for single post */
/* ----------------------------------------------------------------------------------- */
function lookway_numeric_posts_nav() {
	if ( is_singular() )
		return;
	global $wp_query;
	/** Stop execution if there's only 1 page */
	if ( $wp_query->max_num_pages <= 1 )
		return;
	$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
	$max = intval( $wp_query->max_num_pages );
	/** Add current page to the array */
	if ( $paged >= 1 )
		$links[] = $paged;
	/** Add the pages around the current page to the array */
	if ( $paged >= 3 ) {
		$links[] = $paged - 1;
		$links[] = $paged - 2;
	}
	if ( ( $paged + 2 ) <= $max ) {
		$links[] = $paged + 2;
		$links[] = $paged + 1;
	}
	echo '<div class="navigation"><ul>' . "\n";
	/** Previous Post Link */
	if ( get_previous_posts_link() )
		printf( '<li>%s</li>' . "\n", get_previous_posts_link() );
	/** Link to first page, plus ellipses if necessary */
	if ( !in_array( 1, $links ) ) {
		$class = 1 == $paged ? ' class="active"' : '';
		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );
		if ( !in_array( 2, $links ) )
			echo '<li></li>';
	}
	/** Link to current page, plus 2 pages in either direction if necessary */
	sort( $links );
	foreach ( (array) $links as $link ) {
		$class = $paged == $link ? ' class="active"' : '';
		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
	}
	/** Link to last page, plus ellipses if necessary */
	if ( !in_array( $max, $links ) ) {
		if ( !in_array( $max - 1, $links ) )
			echo '<li></li>' . "\n";
		$class = $paged == $max ? ' class="active"' : '';
		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
	}
	/** Next Post Link */
	if ( get_next_posts_link() )
		printf( '<li>%s</li>' . "\n", get_next_posts_link() );
	echo '</ul></div>' . "\n";
}
/* --------------------------------------------------------------------- */
/* * ***Add CLASS attributes to the first <ul> occurence in wp_page_menu*** */
/* --------------------------------------------------------------------- */
function lookway_add_menuclass( $ulclass ) {
	return preg_replace( '/<ul>/', '<ul class="ddsmoothmenu">', $ulclass, 1 );
}
add_filter( 'wp_page_menu', 'lookway_add_menuclass' );
add_action( 'init', 'register_custom_menu' );
function register_custom_menu() {
	register_nav_menu( 'custom_menu', __( 'Main Menu', 'lookway' ) );
}
function lookway_nav() {
	if ( function_exists( 'wp_nav_menu' ) )
		wp_nav_menu( array( 'theme_location' => 'custom_menu', 'container_id' => 'menu', 'menu_class' => 'ddsmoothmenu', 'fallback_cb' => 'lookway_nav_fallback' ) );
	else
		lookway_nav_fallback();
}
function lookway_nav_fallback() {
	?>
	<div id="menu">
		<ul class="ddsmoothmenu">
	<?php
	wp_list_pages( 'title_li=&show_home=1&sort_column=menu_order' );
	?>
		</ul>
	</div>
	<?php
}
function lookway_get_current_menu() {
	if ( is_home() ) {
		print "";
	} else {
		if ( !is_active_sidebar( 'primary-widget-area' ) && !is_active_sidebar( 'secondary-widget-area' ) ) {
			print "<li>";
		} else {
			
		}
	}
}
function lookway_new_nav_menu_items( $items ) {
	if ( is_home() ) {
		$homelink = lookway_get_current_menu() . '<li class="current_page_item"><a href="' . home_url( '/' ) . '">' . __( 'Home', 'lookway' ) . '</a></li>';
	} else {
		$homelink = lookway_get_current_menu() . '<li><a href="' . home_url( '/' ) . '">' . __( 'Home', 'lookway' ) . '</a></li>';
	}
	$items = $homelink . $items;
	return $items;
}
add_filter( 'wp_list_pages', 'lookway_new_nav_menu_items' );
/* ----------------------------------------------------------------------------------- */
/* Required functions */
/* ----------------------------------------------------------------------------------- */
if ( !isset( $content_width ) )
	$content_width = 1024;
function lookway_custom_my_theme_setup() {
	add_editor_style( 'custom-editor-style.css' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "custom-background" );
	add_theme_support( "custom-header" );
	add_theme_support( 'html5', array( 'gallery', 'caption') );
	add_theme_support( "post-thumbnails" );
	add_theme_support( "title-tag" );
}
add_action( 'after_setup_theme', 'lookway_custom_my_theme_setup' );
?>
