<?php
/**
 * The template for displaying Category.
 *
 */
?>
<?php get_header(); ?>
<div class="page_content">
	<div class="heading_container">
		<?php lookway_breadcrum_block(); ?>
	</div>
	<div class="category-archieved">
		<div class="col-md-8">
			<?php if ( have_posts() ) : the_post(); ?>
				<h3 class="archive-title post-page-head"><?php printf( __( 'Category Archives: %s', 'lookway' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h3>

				<?php if ( category_description() ) : // Show an optional category description ?>
					<div class="archive-meta"><?php echo category_description(); ?></div>
				<?php endif;
				?>
				<?php
// If a user has filled out their description, show a bio on their entries.
				if ( get_the_author_meta( 'description' ) ) :
					?>
					<div id="entry-author-info">
						<div id="author-avatar"> <?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'lookway_author_bio_avatar_size', 60 ) ); ?> </div>
						<!-- #author-avatar -->
						<div id="author-description">
							<h2><?php printf( ABOUT, get_the_author() ); ?></h2>
							<?php the_author_meta( 'description' ); ?>
						</div>
						<!-- #author-description	-->
					</div>
					<!-- #entry-author-info -->
				<?php endif; ?>
				<?php
				/* Since we called the_post() above, we need to
				 * rewind the loop back to the beginning that way
				 * we can run the loop properly, in full.
				 */
				rewind_posts();
				/* Run the loop for the author archive page to output the authors posts
				 * If you want to overload this in a child theme then include a file
				 * called loop-author.php and that will be used instead.
				 */
				get_template_part( 'loop', 'category' );
				?>
				<div class="clear"></div>
				<?php lookway_numeric_posts_nav(); ?>
			<?php endif; ?>	
		</div>
		<div class="col-md-4">
			<?php get_sidebar(); ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>