<?php
/**
 * Customizer Control: color.
 *
 * @package     Kirki
 * @subpackage  Controls
 * @copyright   Copyright (c) 2016, Aristeides Stathopoulos
 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT
 * @since       1.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Kirki_Controls_Color_Control')) {

    /**
     * Adds a color & color-alpha control
     *
     * @see https://github.com/23r9i0/wp-color-picker-alpha
     */
    class Kirki_Controls_Color_Control extends Kirki_Customize_Control
    {

        /**
         * The control type.
         *
         * @access public
         * @var string
         */
        public $type = 'kirki-color';

        /**
         * Colorpicker palette
         *
         * @access public
         * @var bool
         */
        public $palette = true;


        /**
         * Refresh the parameters passed to the JavaScript via JSON.
         *
         * @access public
         */
        public function to_json()
        {
            parent::to_json();
            $this->json['palette'] = $this->palette;
            $this->choices['alpha'] = (isset($this->choices['alpha']) && $this->choices['alpha']) ? 'true' : 'false';
        }

        /**
         * Enqueue control related scripts/styles.
         *
         * @access public
         */
        public function enqueue()
        {
            wp_enqueue_script('kirki-color');
        }

        /**
         * An Underscore (JS) template for this control's content (but not its container).
         *
         * Class variables for this control class are available in the `data` JS object;
         * export custom variables by overriding {@see Kirki_Customize_Control::to_json()}.
         *
         * @see WP_Customize_Control::print_template()
         *
         * @access protected
         */
        protected function content_template()
        {
            ?>
            <# if ( data.tooltip ) { #>
                <a href="#" class="tooltip hint--left" data-hint="{{ data.tooltip }}"><span
                            class='dashicons dashicons-info'></span></a>
                <# } #>
                    <label>
				<span class="customize-control-title">
					{{{ data.label }}}
				</span>
                        <# if ( data.description ) { #>
                            <span class="description customize-control-description">{{{ data.description }}}</span>
                            <# } #>
                                <input type="text" data-palette="{{ data.palette }}"
                                       data-default-color="{{ data.default }}" data-alpha="{{ data.choices['alpha'] }}"
                                       value="{{ data.value }}" class="kirki-color-control color-picker" {{{ data.link
                                       }}}/>
                    </label>
            <?php
        }
    }
}
