<?php
//about theme info
add_action( 'admin_menu', 'logistic_transport_gettingstarted' );
function logistic_transport_gettingstarted() {    	
	add_theme_page( esc_html__('Theme Demo Content', 'logistic-transport'), esc_html__('Theme Demo Content', 'logistic-transport'), 'edit_theme_options', 'logistic_transport_guide', 'logistic_transport_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function logistic_transport_admin_theme_style() {
   wp_enqueue_style('logistic-transport-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/getstart.css');
   wp_enqueue_script('tabs', esc_url(get_template_directory_uri()) . '/inc/dashboard/js/tab.js');

   // Admin notice code START
	wp_register_script('logistic-transport-notice', esc_url(get_stylesheet_directory_uri()) . '/inc/dashboard/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('logistic-transport-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'logistic_transport_admin_theme_style');

//guidline for about theme
function logistic_transport_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'logistic-transport' );
?>

<div class="wrapper-info">  
	<div id="tc-header">
		<div class="tc-container main-header">
			<a class="tc-logo">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/logo.png" alt="" />
			</a>
			<span class="tc-header-action">
			<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customize', 'logistic-transport'); ?></a>
			<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'logistic-transport' ); ?></a>
			<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/transport-wordpress-theme'); ?>" target="_blank"> <?php esc_html_e( 'Get Premium', 'logistic-transport' ); ?></a>
			<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/wordpress-theme-bundle' ); ?>" class="bundle_btn" target="_blank"> <?php esc_html_e( 'Bundle of 220+ Themes at $99', 'logistic-transport' ); ?></a>
			</span>
		</div>
	</div>
	<div class="tc-container tab-sec">
		<div class="tc-tabs">
			<ul>
				<li class="tablinks home active" onclick="logistic_transport_openCity(event, 'tc_demo')">
					<a href="#">
						<?php esc_html_e( 'Theme Demo Import', 'logistic-transport' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="logistic_transport_openCity(event, 'tc_index')">
					<a href="#">
						<?php esc_html_e( 'Free Theme Information', 'logistic-transport' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="logistic_transport_openCity(event, 'tc_pro')">
					<a href="#">
						<?php esc_html_e( 'Premium Theme Information', 'logistic-transport' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="logistic_transport_openCity(event, 'tc_create')">
					<a href="#">
						<?php esc_html_e( 'Theme Support', 'logistic-transport' ); ?>
					</a>
				</li>
			</ul>
		</div><!-- END .tc-tabs -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_demo" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Logistic Transport', 'logistic-transport' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="demo">
					<h4><?php esc_html_e( 'Click the "Run Importer" button below to load demo content for Logistic Transport', 'logistic-transport' ); ?></h4>
					<?php /* Demo Import */ require get_parent_theme_file_path( '/inc/dashboard/demo-importer.php' );?>
				</div>
			</div><!-- END .tc-section -->
		</div>
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_index" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Logistic Transport Theme', 'logistic-transport' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="info-link">
					<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'logistic-transport' ); ?></a>
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'logistic-transport'); ?></a>
					<a class="get-pro" href="<?php echo esc_url( LOGISTIC_TRANSPORT_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'logistic-transport'); ?></a>
				</div>
				<div class="col-tc-6">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/screenshot.png" alt="" />
				</div>
				<div class="col-tc-6">
					<P><?php esc_html_e( 'Logistics Transport is a robust, professional, and versatile theme designed for transportation companies, packers and movers, logistics services, shipping firms, heavy equipment transport, courier and delivery agencies, transport insurance providers, cargo hubs, freight service providers, warehouses, postal services, home shifters, contractors, and multipurpose logistics businesses. Ideal for Sea Freight, Road Freight, Air Freight, trucking, fleet management, trailer services, heavy machinery operations, tower cranes, express delivery, shipment tracking, supplier services, freight forwarding, supply chain management, cargo tracking, intermodal transport, drayage, warehousing management, haulage, distribution services, logistics consulting, and dispatch solutions, the theme features a fully responsive layout built on a powerful Bootstrap framework, ensuring smooth performance across desktops, tablets, and mobile devices. With clean, secure, and SEO-optimized code, lightning-fast page load times, interactive Call to Action (CTA) buttons, stunning CSS animations, social media integration, footer widgets, full-width templates, sticky posts, and multiple personalization options, this theme allows easy customization without coding. WooCommerce compatibility enables online listings for shipping services or transport-related products, while multilingual support (Arabic, German, Spanish, French, Italian, Russian, Turkish, Chinese) broadens your reach globally; integration with Contact Form 7 ensures seamless inquiry handling, making it an all-in-one solution for professional and visually appealing logistics websites.', 'logistic-transport' ); ?></P>
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_pro" class="tabcontent">
				<h3><?php esc_html_e( 'Logistic Transport Theme Information', 'logistic-transport' ); ?></h3>
				<hr>
				<div class="info-link-pro">
					<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Buy Now', 'logistic-transport' ); ?></a>
					<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_LIVE_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Live Demo', 'logistic-transport' ); ?></a>
					<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_PRO_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Pro Documentation', 'logistic-transport' ); ?></a>
				</div>
				<div class="pro-image">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/dashboard/images/resize.png" alt="" />
				</div>
			<div class="col-pro-5">
				<h4><?php esc_html_e( 'Logistic Transport Pro Theme', 'logistic-transport' ); ?></h4>
				<P><?php esc_html_e( 'The transport WordPress theme is smart, engaging, enticing and feature-rich with a great use for logistics, packers and movers, warehousing and freight businesses. It focuses on several theme designing tools as well as business-boosting aspects, relieving you from the responsibilities that come with a website. As it has a responsive layout, your website will get easy access to everyone’s mobile, tablet and desktop. It is cross-browser compatible, translation ready and RTL supportive. This transport WordPress theme is easy to use and even easier to customize through theme customizer which allows changing its color, background, menu, logo, and layouts of the header, footer, sidebars, blogs and pages in just a few clicks. Our developers have used Font Awesome icons related to logistics to make the website look more interesting. The theme is designed keeping in mind the needs of a transportation website and sections are included accordingly. Each section has the option to switch it on or off anytime. It has a rich set of shortcodes to include specific functionality without involving in its coding part. This transport WP theme offers premium membership to its users wherein you will get access to regular theme updates and our dedicated support to help you out with your theme-related queries.', 'logistic-transport' ); ?></P>		
			</div>
			<div class="col-pro-6">				
				<h4><?php esc_html_e( 'Theme Features', 'logistic-transport' ); ?></h4>
				<ul>
					<li><?php esc_html_e( 'Theme Options using Customizer API', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Responsive design', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Favicon, Logo, title and tagline customization', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Advanced Color options', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( '100+ Font Family Options', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Background Image Option', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Simple Menu Option', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Additional section for products', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Enable-Disable options on All sections', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Home Page setting for different sections', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Advance Slider with unlimited slides', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Partner Section', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Promotional Banner Section for Products', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Seperate Newsletter Section', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Text and call to action button for each slides', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Pagination option', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Custom CSS option', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Translations Ready', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Custom Backgrounds, Colors, Headers, Logo & Menu', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Customizable Home Page', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Full-Width Template', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Footer Widgets & Editor Style', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Banner & Post Type Plugin Functionality', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Woo Commerce Compatible', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Multiple Inner Page Templates', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Product Sliders', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Slider', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Posttype', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Testimonial Listing With Shortcode', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Contact page template', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Contact Widget', 'logistic-transport' ); ?></li>
					<li><?php esc_html_e( 'Advance Social Media Feature', 'logistic-transport' ); ?></li>
				</ul>					
			</div>	
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_create" class="tabcontent">
				<div class="tab-cont">
					<h4><?php esc_html_e( 'Need Support?', 'logistic-transport' ); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'Our team is obliged to help you in every way possible whenever you face any type of difficulties and doubts.', 'logistic-transport' ); ?></P>
						<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support Forum', 'logistic-transport' ); ?></a>
					</div>
				</div>
				<div class="tab-cont">	
					<h4><?php esc_html_e('Reviews', 'logistic-transport'); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'It is commendable to have such a theme inculcated with amazing features and robust functionalities. I feel grateful to recommend this theme to one and all.', 'logistic-transport' ); ?></P>
						<a href="<?php echo esc_url( LOGISTIC_TRANSPORT_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'logistic-transport'); ?></a>
					</div>
				</div>

				<div class="tc-section large-section">
					<h2>Let‘s customize your website</h2>
					<p>There are many changes you can make to customize your website. Explore customization options and make it unique.</p>
					<div class="tc-buttons">
						<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="tc-btn primary large-button"><?php esc_html_e('Start Customizing', 'logistic-transport'); ?></a>
					</div><!-- END .tc-buttons -->
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>
</div>
<?php } ?>