<div class="theme-import">
	<?php 
        // Check if the demo import has been completed
        $logistic_transport_demo_import_completed = get_option('logistic_transport_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($logistic_transport_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'logistic-transport') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '"  class= "run-import view-site" target="_blank">' . esc_html__('VIEW SITE', 'logistic-transport') . '</a></span>';
        }

		// POST and update the customizer and other related data
        if (isset($_POST['submit'])) {

            // ------- Create Nav Menu --------
            $logistic_transport_menuname = 'Main Menus';
            $logistic_transport_bpmenulocation = 'primary';
            $logistic_transport_menu_exists = wp_get_nav_menu_object($logistic_transport_menuname);

            if (!$logistic_transport_menu_exists) {
                $logistic_transport_menu_id = wp_create_nav_menu($logistic_transport_menuname);

                // Create Home Page
                $logistic_transport_home_title = 'Home';
                $logistic_transport_home = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $logistic_transport_home_id = wp_insert_post($logistic_transport_home);
                // Assign Home Page Template
                add_post_meta($logistic_transport_home_id, '_wp_page_template', 'page-template/custom-frontpage.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $logistic_transport_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'logistic-transport'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create  About Page with Dummy Content
                $logistic_transport_pages_title = 'About';
                $logistic_transport_pages_content = '
                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p> 
';
                $logistic_transport_pages = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_pages_title,
                    'post_content' => $logistic_transport_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $logistic_transport_pages_id = wp_insert_post($logistic_transport_pages);
                // Add About Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('About', 'logistic-transport'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Services Page with Dummy Content
                $logistic_transport_about_title = 'Services';
                $logistic_transport_about_content = '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>';
                $logistic_transport_about = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_about_title,
                    'post_content' => $logistic_transport_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $logistic_transport_about_id = wp_insert_post($logistic_transport_about);
                // Add Services Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('Services', 'logistic-transport'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                 // Create Blog Page with Dummy Content
                $logistic_transport_about_title = 'Blog';
                $logistic_transport_about_content = '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>';
                $logistic_transport_about = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_about_title,
                    'post_content' => $logistic_transport_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $logistic_transport_about_id = wp_insert_post($logistic_transport_about);
                // Add Blog Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('Blog', 'logistic-transport'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                 // Create Pages Page with Dummy Content
                $logistic_transport_about_title = 'Pages';
                $logistic_transport_about_content = '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>';
                $logistic_transport_about = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_about_title,
                    'post_content' => $logistic_transport_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $logistic_transport_about_id = wp_insert_post($logistic_transport_about);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'logistic-transport'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                 // Create Contact Page with Dummy Content
                $logistic_transport_about_title = 'Contact';
                $logistic_transport_about_content = '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>';
                $logistic_transport_about = array(
                    'post_type' => 'page',
                    'post_title' => $logistic_transport_about_title,
                    'post_content' => $logistic_transport_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $logistic_transport_about_id = wp_insert_post($logistic_transport_about);
                // Add Contact Page to Menu
                wp_update_nav_menu_item($logistic_transport_menu_id, 0, array(
                    'menu-item-title' => __('Contact', 'logistic-transport'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $logistic_transport_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($logistic_transport_bpmenulocation)) {
                    $logistic_transport_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($logistic_transport_locations)) {
                        $logistic_transport_locations = array();
                    }
                    $logistic_transport_locations[$logistic_transport_bpmenulocation] = $logistic_transport_menu_id;
                    set_theme_mod('nav_menu_locations', $logistic_transport_locations);
                }
                
        }     

            // Social Icon
            set_theme_mod( 'logistic_transport_facebook_url', '#' ); 
            set_theme_mod( 'logistic_transport_twitter_url', '#' ); 
            set_theme_mod( 'logistic_transport_instagram_url', '#' ); 
            set_theme_mod( 'logistic_transport_linkdin_url', '#' ); 
            set_theme_mod( 'logistic_transport_youtube_url', '#' ); 

            //Header
            set_theme_mod( 'logistic_transport_topbar_hide', true );
            set_theme_mod( 'logistic_transport_call', '+00 123 456 7890' ); 
            set_theme_mod( 'logistic_transport_mail', 'xyz123@example.com' );
            set_theme_mod( 'logistic_transport_time', 'Mon To Fri 08:00 -18:00' );
            set_theme_mod( 'logistic_transport_request_btn_text', 'REQUEST A RATE' );
            set_theme_mod( 'logistic_transport_request_btn_url', '#' ); 

            //Slider
            set_theme_mod( 'logistic_transport_slider_hide_show', true );
            set_theme_mod( 'logistic_transport_slider_button_text', 'KNOW MORE' );
            set_theme_mod( 'logistic_transport_slider_button_link', '#' );

            $logistic_transport_slider_titles = [
                'WE ARE HERE TO MOVE',        
                'DELIVERING PROMISES',   
                'ON TIME, EVERY TIME',         
                'YOUR TRUSTED LOGISTICS PARTNER',
            ];            
            for($logistic_transport_i=1;$logistic_transport_i<=4;$logistic_transport_i++){
                $logistic_transport_slider_title = $logistic_transport_slider_titles[$logistic_transport_i - 1];
                $logistic_transport_slider_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard';
                // Create post object
                $logistic_transport_my_post = array(
                'post_title'    => wp_strip_all_tags( $logistic_transport_slider_title ),
                'post_content'  => $logistic_transport_slider_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
                );
 
                // Insert the post into the database
                $logistic_transport_post_id = wp_insert_post( $logistic_transport_my_post );
 
                if ($logistic_transport_post_id) {
                  // Set the theme mod for the slider page
                  set_theme_mod('logistic_transport_slider_page' . $logistic_transport_i, $logistic_transport_post_id);
 
                   $logistic_transport_image_url = get_template_directory_uri().'/images/Banner'.$logistic_transport_i.'.png';
 
                 $logistic_transport_image_id = media_sideload_image($logistic_transport_image_url, $logistic_transport_post_id, null, 'id');
 
                     if (!is_wp_error($logistic_transport_image_id)) {
                         // Set the downloaded image as the post's featured image
                         set_post_thumbnail($logistic_transport_post_id, $logistic_transport_image_id);
                     }
                 }
            } 

            //Services Section
            set_theme_mod( 'logistic_transport_service_hide_show', true );
            set_theme_mod( 'logistic_transport_services_button_text', 'LEARN MORE' );
            set_theme_mod( 'logistic_transport_services_category', 'category1' );
            $logistic_transport_category_names = array('category1', 'category2', 'category3');
            $logistic_transport_title_array = array(
                array("GROUND SHIPPING", "AIR DELIVERY", "SEA DELIVERY"),
                array("GROUND SHIPPING", "AIR DELIVERY", "SEA DELIVERY"),
                array("GROUND SHIPPING", "AIR DELIVERY", "SEA DELIVERY")
            );

            foreach ($logistic_transport_category_names as $logistic_transport_index => $logistic_transport_category_name) {
                // Create or retrieve the post category term ID
                $logistic_transport_term = term_exists($logistic_transport_category_name, 'category');
                
                if ($logistic_transport_term === 0 || $logistic_transport_term === null) {
                    // If the term does not exist, create it
                    $logistic_transport_term = wp_insert_term($logistic_transport_category_name, 'category');
                    
                    if (is_wp_error($logistic_transport_term)) {
                        error_log('Error creating category: ' . $logistic_transport_term->get_error_message());
                        continue; // Skip to the next iteration if category creation fails
                    }
                }

                // Iterate over the post titles for each category
                for ($logistic_transport_i = 0; $logistic_transport_i < 3; $logistic_transport_i++) {
                    // Create post content
                    $logistic_transport_title = $logistic_transport_title_array[$logistic_transport_index][$logistic_transport_i];
                    $logistic_transport_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';

                    // Create post object
                    $logistic_transport_my_post = array(
                        'post_title'   => wp_strip_all_tags($logistic_transport_title),
                        'post_content' => $logistic_transport_content,
                        'post_status'  => 'publish',
                        'post_type'    => 'post', // Post type set to 'post'
                    );

                    // Insert the post into the database
                    $logistic_transport_post_id = wp_insert_post($logistic_transport_my_post);

                    if (is_wp_error($logistic_transport_post_id)) {
                        error_log('Error creating post: ' . $logistic_transport_post_id->get_error_message());
                        continue; // Skip to the next post if creation fails
                    }

                    // Assign the category to the post
                    wp_set_post_categories($logistic_transport_post_id, array((int)$logistic_transport_term['term_id']));

                    // Handle the featured image using media_sideload_image
                    $logistic_transport_image_url = get_template_directory_uri() . '/images/learnmore-image' . ($logistic_transport_i + 1) . '.png';
                    $logistic_transport_image_id = media_sideload_image($logistic_transport_image_url, $logistic_transport_post_id, null, 'id');

                    if (is_wp_error($logistic_transport_image_id)) {
                        error_log('Error downloading image: ' . $logistic_transport_image_id->get_error_message());
                        continue; // Skip to the next post if image download fails
                    }
                    
                    // Assign featured image to post
                    set_post_thumbnail($logistic_transport_post_id, $logistic_transport_image_id);
                }
            } 

            //About Section
            set_theme_mod( 'logistic_transport_discover_post', 'ABOUT LOGISTIC' );
            $logistic_transport_service_titles = array(
                "ABOUT LOGISTIC",
                "LOREM IPSUM"
            );
            $logistic_transport_service_image_url = get_template_directory_uri() . '/images/about.png';
    
            for ($logistic_transport_i = 1; $logistic_transport_i <= 2; $logistic_transport_i++) {
                // Create post
                $logistic_transport_title = $logistic_transport_service_titles[$logistic_transport_i - 1];
                $logistic_transport_content = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.";
                $logistic_transport_post_data = array(
                    'post_title'   => wp_strip_all_tags($logistic_transport_title),
                    'post_content' => wp_strip_all_tags($logistic_transport_content),
                    'post_status'  => 'publish',
                    'post_type'    => 'post',
                );
                $logistic_transport_post_id = wp_insert_post($logistic_transport_post_data);
    
                if (!is_wp_error($logistic_transport_post_id)) {
                    // Add featured image
                    $logistic_transport_image_id = media_sideload_image($logistic_transport_service_image_url, $logistic_transport_post_id, null, 'id');
                    if (!is_wp_error($logistic_transport_image_id)) {
                        set_post_thumbnail($logistic_transport_post_id, $logistic_transport_image_id);
                    }
                    // Save post ID in theme mod
                    set_theme_mod('logistic_transport_discover_post' . $logistic_transport_i, $logistic_transport_post_id);
                }
            }

            //Copyright Text
            set_theme_mod( 'logistic_transport_footer_copy', 'By ThemesCaliber' ); 

            // Set the demo import completion flag
    		update_option('logistic_transport_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'logistic-transport') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="run-import site-btn" target="_blank">' . esc_html__('VIEW SITE', 'logistic-transport') . '</a></span>';

        }
    ?>
  
    <p class="note"><?php esc_html_e( 'Please Note: If your website is live and already contains data, we recommend creating a backup first. Running this importer will replace your current settings with the custom values from the demo.', 'logistic-transport' ); ?></p>
        <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=logistic_transport_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('logistic_transport_demo_import_completed')) : ?>
            <button type="submit" name="submit" class="run-import">
                    <?php esc_html_e('Run Importer','logistic-transport'); ?>
                    <span id="spinner" style="display: none;">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/spinner.gif" alt="Loading..." style="width:34px; height:34px; vertical-align: middle;" />
                    </span>
            </button>
        <?php endif; ?>
        </form>
        <script type="text/javascript">
            function validate(valid) {
                if(confirm("Do you really want to import the theme demo content?")){
                    document.getElementById('spinner').style.display = 'inline-block';
                }
                else {
                    return false;
                }
            }
        </script>
    </div>