<?php
/**
 * Pattern
 *
 * @author Themeisle
 * @package lmscourse-fse
 * @since 1.0.0
 *
 * slug: pricing-2
 * title: Pricing 2
 * categories: LMSCourseFSE
 * keywords: pricing, cover
 */

use LMSCourseFSE\Assets_Manager;

$lmscourse_fse_img09 = Assets_Manager::get_image_url( 'theme-img-09.webp' );

return array(
	'title'      => __( 'Pricing 2', 'lmscourse-fse' ),
	'categories' => array( 'lmscourse-fse' ),
	'keywords'   => array( 'pricing' ),
	'content'    => '

<!-- wp:cover {"url":"' . esc_url( $lmscourse_fse_img09 ) . '","id":150,"dimRatio":90,"overlayColor":"ti-bg-inv","isUserOverlayColor":true,"sizeSlug":"large","metadata":{"name":"Pricing-2"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--60)" id="enroll"><img class="wp-block-cover__image-background wp-image-150 size-large" alt="" src="' . esc_url( $lmscourse_fse_img09 ) . '" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-ti-bg-inv-background-color has-background-dim-90 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"wide","layout":{"type":"grid","minimumColumnWidth":"17rem"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"align":"wide","style":{"layout":{"columnSpan":2},"spacing":{"blockGap":"var:preset|spacing|80"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"textAlign":"left","align":"wide","fontSize":"huge"} -->
<h2 class="wp-block-heading alignwide has-text-align-left has-huge-font-size">Enroll Today!</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"large"} -->
<p class="has-large-font-size">Pickum chordis dolor sit fretboard, consectetur scale-tur adipiscing neck. Solo elit string-tremolo, slide do re mi.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","layout":{"type":"grid","minimumColumnWidth":"12rem"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|luminous-vivid-amber"}}}},"textColor":"luminous-vivid-amber","fontSize":"normal"} -->
<p class="has-text-align-left has-luminous-vivid-amber-color has-text-color has-link-color has-normal-font-size">★★★★★</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size">“After a month I\'m already playing my first songs!”</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"layout":{"columnSpan":1,"rowSpan":1}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|luminous-vivid-amber"}}}},"textColor":"luminous-vivid-amber","fontSize":"normal"} -->
<p class="has-text-align-left has-luminous-vivid-amber-color has-text-color has-link-color has-normal-font-size">★★★★★</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size">“The lessons are clear and easy to follow.”</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|luminous-vivid-amber"}}}},"textColor":"luminous-vivid-amber","fontSize":"normal"} -->
<p class="has-text-align-left has-luminous-vivid-amber-color has-text-color has-link-color has-normal-font-size">★★★★★</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size">“This course made everything click." </p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"border":{"radius":"8px"}},"backgroundColor":"ti-bg","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-ti-bg-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"style":{"spacing":{"blockGap":"0"},"elements":{"link":{"color":{"text":"var:preset|color|ti-fg"}}}},"textColor":"ti-fg","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-ti-fg-color has-text-color has-link-color"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.3"}},"fontSize":"huge"} -->
<p class="has-text-align-center has-huge-font-size" style="line-height:1.3">$199</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"}},"fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size" style="font-style:normal;font-weight:600;text-transform:uppercase">One-time Payment</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"},"elements":{"link":{"color":{"text":"var:preset|color|ti-fg"}}}},"textColor":"ti-fg","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-ti-fg-color has-text-color has-link-color"><!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Access to all material</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Downloadable resources</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Priority support</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"width":100,"className":"is-style-fill","fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill"><a class="wp-block-button__link has-medium-font-size has-custom-font-size wp-element-button">Enroll Now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover -->

',
);
