<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
        <meta charset="<?php bloginfo('charset'); ?>" />
        <title>
            <?php global $page, $paged; ?>
            <?php wp_title('|', true, 'right'); ?>
            <?php bloginfo('name'); ?>
            <?php $site_description = get_bloginfo('description', 'display'); ?>
            <?php if ($site_description && (is_home() || is_front_page())) : ?>
                <?php echo " | $site_description"; ?>
            <?php endif; ?>
            <?php if ($paged >= 2 || $page >= 2) : ?>
                <?php echo ' | '.sprintf(__('Page %s'), max($paged, $page)); ?>
            <?php endif; ?>
        </title>
        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('stylesheet_url'); ?>" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        <?php wp_head(); ?>
	</head>
    <body <?php body_class(); ?>>
    <div id="wrapper" class="hfeed">
        <div id="header">
            <div id="masthead">
				<div id="access">
					<?php wp_nav_menu(array('menu_class' => 'menu-header')); ?>
                </div><!-- #access -->
                <div id="branding">
                    <?php $heading_tag = (is_home() || is_front_page()) ? 'h1' : 'div'; ?>
                    <<?php echo $heading_tag; ?> id="site-title">
                        <span>
                            <a href="<?php echo home_url('/'); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>"><?php bloginfo('name'); ?></a>
                        </span>
                    </<?php echo $heading_tag; ?>>
                    <div id="site-description">
						<?php bloginfo('description'); ?>
                    </div>
					<img src="<?php bloginfo('stylesheet_directory'); ?>/images/maingraphic.jpg" width="884px" height="322px" />
                </div><!-- #branding -->
            </div><!-- #masthead -->
        </div><!-- #header -->
        <div id="main">