<?php
/*-----------------------------------------*/
/* litesite Wordpress Theme Setup
/*-----------------------------------------*/ 

/*-------------------------------------------------*/
/*	Add theme support 
/*-------------------------------------------------*/ 
function litesite_setup(){
	
	global $content_width;
	if ( ! isset( $content_width ) ) $content_width = 650;
	
	
	//// Make Menu
	  register_nav_menus(
		array(
		  'header-menu' => __( 'Header Menu', 'litesite' ),
		)
	  );
	/////////////

	//// Add Image Thumbnail Support in post/blog page
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 300, '', true );
	//add_image_size( 'full-width', 500, '' , true );

	add_image_size( 'litesite-featured-thumb', 300); //300 pixels wide (and unlimited height)	
	add_image_size( 'medium', 320, '', true); // Medium Thumbnail
    add_image_size( 'small', 50, 50 , true); // Small Thumbnail
    add_image_size( 'fullwidth', 540, null, true );
    add_image_size( 'slider', 900, 380, true );
	//////////////////

	///// Add support for other media files 
	add_theme_support( 'post-formats', array(
			'aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery',
		) );
	////

	// Add RSS feed links to <head> for posts and comments.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 
		'comment-form',
		'comment-list',
	) );
	
	
	add_theme_support( 'custom-background', array(
		'default-color' => 'eee',
	) );

}
add_action( 'after_setup_theme', 'litesite_setup' );
add_theme_support('woocommerce');


/*-------------------------------------------------*/
/*	Load stylesheet and scripts dynamically
/*-------------------------------------------------*/ 
function litesite_scripts() {
	//wp_enqueue_style( $handle, $src, $deps, $ver, $media );
	wp_enqueue_style( 'litesite-main', get_stylesheet_uri() );
	wp_enqueue_style( 'litesite-navigationCss', get_template_directory_uri() . '/css/dropmenu.css', '1.0' );
	wp_enqueue_style( 'litesite-responsive', get_template_directory_uri() . '/css/responsive.css', '1.0' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', '1.0' );
	// Using Google Fonts
	wp_enqueue_style( 'open-google-fonts', 'http://fonts.googleapis.com/css?family=Open+Sans', array(), null );
	wp_enqueue_style( 'roboto-google-fonts', 'http://fonts.googleapis.com/css?family=Roboto', array(), null );
	
	wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'dropmenu', get_template_directory_uri() . '/js/dropmenu.js', array(), '1.0.0', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'litesite_scripts' );


/*-------------------------------------------------*/
/*	Sidebar & Widgets
/*-------------------------------------------------*/ 
function litesite_widgets(){

		///// Sidebar Blog Widgets
	register_sidebar(array(
		'name' => __( 'Sidebar Blog', 'litesite'),
		'id' => 'sidebar-blog',
		'description' => __( 'Widgets in this area will be shown on the blog page sidebar.', 'litesite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>'
	));
	
	///// Sidebar Right Widgets
	register_sidebar(array(
		'name' => __( 'Sidebar', 'litesite'),
		'id' => 'sidebar',
		'description' => __( 'Widgets in this area will be shown on the sidebar.', 'litesite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>'
	));
	
	// Footer widgets
    register_sidebar(array(
        'name' => __('FooterWidget', 'litesite'),
        'description' => __('Add widget to your footer area (max 4 widgets)', 'litesite'),
        'id' => 'footer-widget',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
       'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>'
    ));
	////////////////////
   register_widget( 'social_widget' );
}
add_action( 'widgets_init', 'litesite_widgets' );
require_once get_template_directory() . '/social-widget.php';

// Replaces the excerpt "more" text by a link
function new_excerpt_more($more) {
       global $post;
	return ' <a class="linkred" href="'. get_permalink($post->ID) . '"> ... read more</a>';
}
add_filter('excerpt_more', 'new_excerpt_more');

// Customizer option to add logo and Intro text to the site
function litesite_theme_customizer( $wp_customize ) {
	//// Add a Logo 
    $wp_customize->add_section( 'litesite_logo_section' , array(
    'title'       => __( 'Logo', 'litesite' ),
    'priority'    => 30,
    'description' => 'Upload a logo to replace the default site name and description in the header',
	) );
	$wp_customize->add_setting( 'litesite_logo' );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'litesite_logo', array(
		'label'    => __( 'Logo', 'litesite' ),
		'section'  => 'litesite_logo_section',
		'settings' => 'litesite_logo',
		) ) );

	//// Add a Intro Text
	$wp_customize->add_section( 'litesite_introtext_section' , array(
    'title'       => __( 'Home Page Intro Text', 'litesite' ),
    'priority'    => 31,
    'description' => 'Write a Cool Intro Text for your website visitors.',
	) );
	$wp_customize->add_setting('litesite_introtext', array (
	'default' => 'Write something here',
	'sanitize_callback' => 'esc_attr'
	));
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'litesite_introtext', array(
		'label'    => __( 'Home Page Intro Text', 'litesite' ),
		'type'    =>'text',
		'section'  => 'litesite_introtext_section',
		'settings' => 'litesite_introtext',
	) ) );
}
add_action('customize_register', 'litesite_theme_customizer');