<?php
/**
 * The template for displaying home page when selected from admin
 *
 * @package WordPress
 * @subpackage litesite
 */
?>
<?php get_header(); ?>

<?php
//// Get Blog Posts if no front page is selected
if ( 'posts' == get_option( 'show_on_front' )): ?>

<?php if (have_posts()) : ?>

<div class="content-wrap page-wrap">

<div class="wrap">
	<div class="container">

<div class="pagetitle">
	<h1 style="">Blog</h1>
</div>

<div class="column-three-fourth">

<?php while (have_posts()) : the_post();
		
			get_template_part('content'); /// Get the posts

		endwhile;
	
	get_template_part('nav'); //// Get the posts navigation
	
	else : 
    
 get_template_part('content', 'none'); /// This will show when nothing is found ?> 

<?php endif; ?>

</div><!-- column-three-fourth ends -->

<div class="sidebar">
<?php 
if( is_active_sidebar('sidebar-blog' )) dynamic_sidebar( 'sidebar-blog' ); 
//get_sidebar(); ?>
</div>


<?php else:
//// Get Front page if Front page is selected
?>


<div class="wrap">
            <div class="banner">
            
<?php if ( get_theme_mod( 'litesite_introtext' ) ) : ?>
      <h1><?php echo esc_attr( get_theme_mod( 'litesite_introtext' ) ); ?></h1>
<?php else : ?>
        <h1>A Cool Intro About your company</h1>
<?php endif; ?>
            
            </div>
</div>


<div class="content-wrap">

<div class="wrap">
	<div class="container">
  
<?php
	/// Show sticky posts here as featured services etc
	get_template_part('content', 'featured');
?>

<div class="clear-10"></div>

<div class="pagetitle">
<h1 style=""><?php the_title(); ?></h1>
</div>
<div class="column-three-fourth">
<?php if ( have_posts()): while ( have_posts() ) : the_post(); ?>
<!-- post thumbnail -->

		<?php if ( has_post_thumbnail()) : ?>
<div class="page-featured-img">       
			<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
				<?php the_post_thumbnail();  ?>
			</a>
</div>       
		<?php endif; ?>

<!-- /post thumbnail -->

<?php the_content(); ?>

<div class="clear-10"></div>
<?php edit_post_link( __( 'Edit', 'litesite' ), '', '' ); ?>

	<?php
    // If comments are open or we have at least one comment, load up the comment template
    if ( comments_open() || '0' != get_comments_number() )  ?>
      
    <?php comments_template(); ?>

<?php endwhile; ?>

	<?php else: 
	
		 get_template_part('content', 'none'); /// This will show when nothing is found ?>
			
<?php endif; ?>
 
</div><!-- main -->

<?php get_sidebar(); ?>

<?php endif; ?>
<?php get_footer(); ?>