<?php
if ( ! get_theme_mod( 'majestic_blog_enable_banner_section', false ) ) {
	return;
}

$slider_content_ids  = array();
$slider_content_type = get_theme_mod( 'majestic_blog_banner_slider_content_type', 'post' );

if ( $slider_content_type === 'post' ) {
	for ( $i = 1; $i <= 3; $i++ ) {
		$slider_content_ids[] = get_theme_mod( 'majestic_blog_banner_slider_content_post_' . $i );
	}
	$slider_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $slider_content_ids ) ) ) {
		$slider_args['post__in'] = array_filter( $slider_content_ids );
		$slider_args['orderby']  = 'post__in';
	} else {
		$slider_args['orderby'] = 'date';
	}
} elseif ( $slider_content_type === 'category' ) {
	$cat_content_id = get_theme_mod( 'majestic_blog_banner_slider_content_category' );
	$slider_args    = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}
$slider_args = apply_filters( 'majestic_blog_slider_section_args', $slider_args );

majestic_blog_render_slider_section( $slider_args );

/**
 * Render Banner Section.
 */
function majestic_blog_render_slider_section( $slider_args ) {

	$slider_query = new WP_Query( $slider_args );
	if ( $slider_query->have_posts() ) {
		?>
		<section id="majestic_blog_banner_section" class="banner-section section-splitter banner-style-2">
			<?php
			if ( is_customize_preview() ) :
				majestic_blog_section_link( 'majestic_blog_banner_section' );
			endif;
			?>
			<div class="section-wrapper">
				<div class="banner-slider slick-button">
					<?php
					while ( $slider_query->have_posts() ) :
						$slider_query->the_post();
						?>
						<div class="blog-post-container tile-layout">
							<div class="blog-post-inner <?php echo esc_attr( has_post_thumbnail() ? 'has-thumbnail' : 'no-thumbnail' ); ?>">
								<?php if ( has_post_thumbnail() ) : ?>
									<div class="blog-post-image">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail( 'post-thumbnail' ); ?>
										</a>
									</div>
								<?php endif; ?>
								<div class="blog-post-detail">
									<ul class="post-categories">
										<?php majestic_blog_categories_list(); ?>
									</ul>
									<h3 class="post-main-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>
									<p class="post-excerpt">
										<?php echo esc_html( wp_trim_words( get_the_excerpt(), 20 ) ); ?>
									</p>
									<div class="post-meta">
										<div class="post-meta-wrapper">
											<?php
											majestic_blog_posted_by();
											majestic_blog_posted_on();
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
		</section>
		<?php
	}

}
