<?php
/**
 * Theme Customizer
 *
 * @package Lite Blog
 */

function lite_blog_customize_register( $wp_customize ) {

	// Upsell Section.
	$wp_customize->add_section(
		new Lite_Blog_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Lite Blog', 'lite-blog' ),
				'button_text'      => __( 'Buy Pro', 'lite-blog' ),
				'url'              => 'https://ascendoor.com/themes/lite-blog-pro/',
				'background_color' => '#d82958',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'lite_blog_customize_register' );

function lite_blog_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'lite-blog-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'majestic-blog-custom-controls-css' ), '1.0.0', 'all' );
	wp_enqueue_script( 'lite-blog-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'majestic-blog-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'lite_blog_custom_control_scripts' );

function lite_blog_admin_style() {

	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'lite-blog-demo-url', get_stylesheet_directory_uri() . '/assets/css/admin' . $min . '.css', array(), '1.0.0', 'all' );

}
add_action( 'admin_enqueue_scripts', 'lite_blog_admin_style' );

