<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Majestic Blog
 */

get_header();

if ( is_front_page() && is_home() ) {
	require get_theme_file_path() . '/home.php';
} elseif ( is_front_page() && ! is_home() ) {
	?>
	<main id="primary" class="site-main">
		<?php
		require get_template_directory() . '/sections/flash-articles.php';
		require get_theme_file_path() . '/inc/sections/banner.php';
		require get_theme_file_path() . '/inc/sections/categories.php';
		require get_template_directory() . '/sections/advertisement.php';
		?>
	</main><!-- #main -->
	<?php
}

if ( true === get_theme_mod( 'majestic_blog_enable_frontpage_content', false ) && 'page' === get_option( 'show_on_front' ) ) {
	?>
	<div class="majestic-blog-main-wrapper">
		<div class="section-wrapper">
			<div class="majestic-blog-container-wrapper">
				<main id="primary" class="site-main">
					<?php
					while ( have_posts() ) :
						the_post();

						get_template_part( 'template-parts/content', 'page' );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
					endif;

					endwhile; // End of the loop.
					?>
				</main><!-- #main -->
				<?php
				if ( majestic_blog_is_sidebar_enabled() ) {
					get_sidebar();
				}
				?>
			</div>
		</div>
	</div>
	<?php

}

get_footer();
