<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Lite Blog
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>
	<div id="page" class="site">

		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'lite-blog' ); ?></a>

		<div id="loader" class="loader-1">
			<div class="loader-container">
				<div id="preloader">
				</div>
			</div>
		</div><!-- #loader -->

		<header id="masthead" class="site-header">
			<div class="majestic-blog-header <?php echo esc_attr( get_header_image() ? 'header-image' : '' ); ?>">
				<?php
				$enable_topbar = get_theme_mod( 'majestic_blog_enable_topbar', false );
				if ( $enable_topbar === true ) {
					$social_menu_text_label = get_theme_mod( 'majestic_blog_header_social_menu_text_label', __( 'Follow Us', 'lite-blog' ) );
					?>
					<div class="majestic-blog-top-header">
						<div class="section-wrapper">
							<div class="top-header-container-wrapper">
								<?php if ( has_nav_menu( 'social' ) ) : ?>
									<div class="header-social-icon">
										<span><?php echo esc_html( $social_menu_text_label ); ?></span>
										<?php
										wp_nav_menu(
											array(
												'container'   => 'ul',
												'menu_class'  => 'social-links',
												'theme_location' => 'social',
												'link_before' => '<span class="screen-reader-text">',
												'link_after'  => '</span>',
											)
										);
										?>
									</div>
								<?php endif; ?>
								<div class="top-right-part">
									<span><?php echo esc_html( wp_date( 'j M Y' ) ); ?></span>
								</div>
							</div>
						</div>	
					</div>
				<?php } ?>	

				<div class="navigation-outer-wrapper">
					<div class="majestic-blog-navigation sticky-nav">
						<div class="section-wrapper">
							<div class="navigation-wrapper">
								<div class="site-branding">
									<?php if ( has_custom_logo() ) { ?>
										<div class="site-logo" style="max-width: var(--logo-size-custom);">
											<?php the_custom_logo(); ?>
										</div>
									<?php } ?>
									<div class="site-identity">
										<?php
										if ( is_front_page() && is_home() ) :
											?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
											<?php
									else :
										?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php
									endif;
									$majestic_blog_description = get_bloginfo( 'description', 'display' );
									if ( $majestic_blog_description || is_customize_preview() ) :
										?>
										<p class="site-description"><?php echo $majestic_blog_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
									<?php endif; ?>
								</div>	
							</div>
							<div class="majestic-blog-navigation-container">
								<div class="nav-wrapper">
									<nav id="site-navigation" class="main-navigation">
										<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
											<span class="ham-icon"></span>
											<span class="ham-icon"></span>
											<span class="ham-icon"></span>
										</button>
										<div class="navigation-area">
											<?php
											if ( has_nav_menu( 'primary' ) ) {
												wp_nav_menu(
													array(
														'theme_location' => 'primary',
														'menu_id' => 'primary-menu',
													)
												);
											}
											?>
										</div>
									</nav><!-- #site-navigation -->
								</div>
							</div>
							<div class="navigation-right-part">
								<div class="majestic-blog-header-search">
									<div class="header-search-wrap">
										<a href="#" class="search-icon"><i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i></a>
										<div class="header-search-form">
											<?php get_search_form(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>	
				</div>
			</div>
		</div>	
		<!-- end of navigation -->
	</header><!-- #masthead -->

	<?php
	if ( ! is_front_page() || is_home() ) {
		if ( is_front_page() ) {

			require get_template_directory() . '/sections/flash-articles.php';
			require get_theme_file_path() . '/inc/sections/banner.php';
			require get_theme_file_path() . '/inc/sections/categories.php';
			require get_template_directory() . '/sections/advertisement.php';

		}
		?>
		<div class="majestic-blog-main-wrapper">
			<div class="section-wrapper">
				<div class="majestic-blog-container-wrapper">
				<?php } ?>
