jQuery(function($) {

    /* -----------------------------------------
    rtl
    ----------------------------------------- */
    var isRTL = $("html").attr("dir") === "rtl";

    /* -----------------------------------------
    Sticky Header
    ----------------------------------------- */
    if ($(".majestic-blog-navigation").hasClass("sticky-nav")) {
        const header = document.querySelector(".sticky-nav");
        window.onscroll = function () {
            if (window.pageYOffset > 200) {
                header.classList.add("sticky-header");
            } else {
                header.classList.remove("sticky-header");
            }
        };
        $(document).ready(function () {
            var divHeight = $(".majestic-blog-navigation").height();
            $(".navigation-outer-wrapper").css("min-height", divHeight + "px");
        });
    }

    /* -----------------------------------------
    Main Slider
    ----------------------------------------- */
    $(".banner-style-2 .banner-slider").slick({
        dots: false,
        infinite: false,
        speed: 300,
        slidesToShow: 3,
        slidesToScroll: 1,
        infinite: true,
        rtl: isRTL,
        arrows: true,
        prevArrow: "<button class='fa fa-angle-left'</button>",
        nextArrow: "<button class='fa fa-angle-right'</button>",
        responsive: [
        {
        breakpoint: 768,
        settings: {
            slidesToShow: 2,
            slidesToScroll: 1,
            arrows: true,
            centerMode: false,
        },
        },
        {
        breakpoint: 600,
        settings: {
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: false,
            dots: true,
            centerMode: false,
        },
        },
        ],
    });

});