<?php
    $slider_title       = liora_get_option( 'slider_title' );
    $slider_subtitle       = liora_get_option( 'slider_subtitle' );
    $slider_content_type     = liora_get_option( 'slider_content_type' );
    $enable_dots     = liora_get_option( 'slider_dots_enable' );
    $enable_arrow     = liora_get_option( 'slider_arrow_enable' );
    $enable_autoplay     = liora_get_option( 'slider_autoplay_enable' );
    $enable_fade     = liora_get_option( 'slider_fade_enable' );
    $enable_infinite     = liora_get_option( 'slider_infinite_enable' );
    $enable_category     = liora_get_option( 'slider_category_enable' );
    $enable_content     = liora_get_option( 'slider_content_enable' );
    $enable_author     = liora_get_option( 'slider_author_enable' );
    $enable_posted_on     = liora_get_option( 'slider_posted_on_enable' );
    $number_of_slider_items  = liora_get_option( 'number_of_slider_items' );
    $slider_speed = liora_get_option( 'slider_speed' );
    $slider_category = liora_get_option( 'slider_category' );
    $header_font_size = liora_get_option( 'slider_font_size');
    $slider_column = liora_get_option('number_of_slider_column');
    $content_align = liora_get_option('slider_content_align');
    $excerpt_length =liora_get_option( 'slider_excerpt_length');
    $homepage_layout_options =liora_get_option( 'homepage_design_layout_options');

    $see_more_txt     = liora_get_option( 'slider_see_all_txt' );
    $see_more_url     = liora_get_option( 'slider_see_all_url' );

    for( $i=1; $i<=$number_of_slider_items; $i++ ) :
        $slider_page_posts[] = absint(liora_get_option( 'slider_page_'.$i ) );
        $slider_post_posts[] = absint(liora_get_option( 'slider_post_'.$i ) );
    endfor;

?>
<style>
    <?php if ($header_font_size != 0): ?>
        #slider .entry-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style> 

<div class="slider-wrapper" 
        data-slick='{"slidesToShow": <?php echo esc_attr( $slider_column) ?>,
         "slidesToScroll": 1, 
         "infinite": <?php if( true== $enable_infinite ){ echo 'true'; } else{ echo 'false'; } ?>, 
         "speed": <?php echo esc_attr( $slider_speed) ?>, 
         "dots": <?php if( true== $enable_dots ){ echo 'true'; } else{ echo 'false'; } ?>, 
         "arrows":<?php if( true== $enable_arrow ){ echo 'true'; } else{ echo 'false'; } ?>, 
         "autoplay": <?php if( true== $enable_autoplay ){ echo 'true'; } else{ echo 'false'; } ?>, 
         "fade": <?php if( true== $enable_fade && $slider_column==1){ echo 'true'; } else{ echo 'false'; } ?> }'>
    <?php 
        $args = array (
            'post_type'     => 'post',
            'post_per_page' => count( $slider_post_posts ),
            'post__in'      => $slider_post_posts,
            'orderby'       =>'post__in', 
            'ignore_sticky_posts' => true, 
        ); 
        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>        
                <article class="<?php echo has_post_thumbnail() ? 'has-post-thumbnail' : 'no-post-thumbnail' ; ?>">
                    <div class="slider-item-wrapper solid-border">
                         <?php if ( ($slider_content_type !== 'slider_page') && ($enable_category==true) ) : ?>
                            <div class="entry-meta entry-cat">
                                <?php liora_entry_meta(); ?>
                            </div><!-- .entry-meta -->
                        <?php endif; ?>
                        <div class="post-featured-image">
                            <div class="featured-image" style="background-image: url('<?php the_post_thumbnail_url( 'blog-thumbnails');?>');">
                                <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>                                    
                            </div><!-- .featured-image -->
                        </div>
                        <div class="entry-container <?php echo esc_attr($content_align); ?>">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                            </header>
                            <?php if (($enable_posted_on==true) || ($enable_author==true)) : ?>
                                <div class="entry-meta">
                                    <?php 
                                        if (($enable_posted_on==true)) {
                                            liora_posted_on();
                                        } 
                                        if (($enable_author==true)) {
                                            liora_author();
                                        }
                                     ?>
                                </div><!-- .entry-meta -->
                            <?php endif; ?>
                            <?php if (($enable_content==true)) : ?>
                                <div class="entry-content">
                                    <?php 
                                        $excerpt = liora_the_excerpt( $excerpt_length );
                                        echo wp_kses_post( wpautop( $excerpt ) );
                                    ?>
                                </div><!-- .entry-content -->
                            <?php endif; ?>  
                        </div><!-- .entry-container -->
                    </div>
                </article>

            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div>
