<?php
    $banner_title       = liora_get_option( 'banner_title' );
    $banner_subtitle       = liora_get_option( 'banner_subtitle' );
    $banner_content_type     = liora_get_option( 'banner_content_type' );
    $enable_category     = liora_get_option( 'banner_category_enable' );
    $enable_content     = liora_get_option( 'banner_content_enable' );
    $enable_author     = liora_get_option( 'banner_author_enable' );
    $enable_posted_on     = liora_get_option( 'banner_posted_on_enable' );
    $number_of_banner_items  = liora_get_option( 'number_of_banner_items' );
    $banner_category = liora_get_option( 'banner_category' );
    $header_font_size = liora_get_option( 'banner_font_size');
    $number_of_banner_column = liora_get_option('number_of_banner_column');
    $content_align = liora_get_option('banner_content_align');
    $excerpt_length =liora_get_option( 'banner_excerpt_length');
    $enable_views =liora_get_option( 'banner_views_enable');
    $enable_readtime =liora_get_option( 'banner_readtime_enable');

    $see_more_txt     = liora_get_option( 'banner_see_all_txt' );
    $see_more_url     = liora_get_option( 'banner_see_all_url' );

    for( $i=1; $i<=$number_of_banner_items; $i++ ) :
        $banner_page_posts[] = absint(liora_get_option( 'banner_page_'.$i ) );
        $banner_post_posts[] = absint(liora_get_option( 'banner_post_'.$i ) );
    endfor;

?>  
<style>
    <?php if ($header_font_size != 0): ?>
        #banner .section-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style>
<?php if(!empty($banner_title) ):?>
    <div class="section-header">
        <?php if (!empty($banner_title)): ?>
            <div class="section-inner-header">
                <h2 class="section-title"><?php echo esc_html($banner_title);?></h2>
            </div>
            <?php if (!empty($see_more_txt) && !empty($see_more_url)): ?>
                <div class="section-header-btn">
                    <a class="see-all" href="<?php echo esc_url($see_more_url) ?>"><?php echo esc_html($see_more_txt); ?></a>
                </div>
            <?php endif ?>
        <?php endif; ?>
    </div>       
<?php endif;?> 
<div class="banner-wrapper col-<?php echo esc_attr($number_of_banner_column); ?>">
    <?php 
        $args = array (

            'posts_per_page' =>absint( $number_of_banner_items ),              
            'post_type' => 'post',
            'post_status' => 'publish',
            'paged' => 1,
            'ignore_sticky_posts' => true, 
            );
            if ( absint( $banner_category ) > 0 ) {
                $args['cat'] = absint( $banner_category );
            }
        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>        
                <article class="<?php echo has_post_thumbnail() ? 'has-post-thumbnail' : 'no-post-thumbnail' ; ?>">
                    <div class="banner-item-wrapper solid-border">
                        <div class="post-featured-image">
                            <?php if (($enable_readtime==true) || ($enable_views==true)) { ?>
                                <div class="entry-readtime">
                                    <?php if (($enable_readtime==true)) { ?>
                                        <span class="post-readtime"><i class="fa fa-clock"></i><?php echo liora_time_interval(); ?><?php esc_html_e( 'min', 'liora' ); ?></span>
                                    <?php } ?>
                                    <?php if (($enable_views==true)) { ?>
                                        <span class="count-post-views"><i class="fa fa-eye"></i><?php echo liora_getPostViews( get_the_ID()); ?></span>    
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            <?php if (has_post_thumbnail()) : ?>
                            <div class="featured-image post-bg-image" style="background-image: url('<?php the_post_thumbnail_url();?>');">
                                <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                <?php $homepage_video_url = get_post_meta( get_the_ID(), 'liora-video-url', true ); ?>
                                <?php if (!empty($homepage_video_url)): ?>
                                   <a href="<?php the_permalink();?>"> <div class="homepage-video-icon"><i class="fa fa-play"></i></div></a>
                                <?php endif ?>
                            </div><!-- .featured-image -->
                            <?php endif; ?>
                            <div class="entry-container <?php echo esc_attr($content_align); ?>">
                                <?php if ( ($banner_content_type !== 'banner_page') && (($enable_category==true) || ($enable_readtime==true))) : ?>
                                    <div class="entry-meta entry-cat">
                                        <?php if ($enable_category==true) {
                                            liora_entry_meta(); 
                                        } ?>
                                        
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                </header>
                                <?php if (($enable_content==true)) : ?>
                                    <div class="entry-content">
                                        <?php 
                                            $excerpt = liora_the_excerpt( $excerpt_length );
                                            echo wp_kses_post( wpautop( $excerpt ) );
                                        ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?> 
                                <?php if ((($enable_author==true) || ($enable_posted_on==true))) : ?>
                                    <div class="entry-meta entry-footer solid-border">
                                        <?php 
                                            if (($enable_posted_on==true)) {
                                                liora_posted_on();
                                            } 
                                            if (($enable_author==true)) {
                                                liora_author();
                                            } ?>
                                            
                                    </div><!-- .entry-meta -->
                                <?php endif; ?> 
                            </div><!-- .entry-container -->
                        </div>
                    </div>
                </article>

            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div>