<?php 
/**
 * Template part for displaying Author Section
 *
 *@package Liora
 */
    $about_content_type     = liora_get_option( 'about_content_type' );
    $about_content_enable       = liora_get_option( 'about_content_enable' );
    $about_excerpt_enable       = liora_get_option( 'about_excerpt_enable' );
    $about_header_font_size = liora_get_option( 'about_font_size');
    $about_content_font_size = liora_get_option( 'about_content_font_size');
    $about_highlight_font_size = liora_get_option( 'about_highlight_title_font_size');
    $excerpt_length =liora_get_option( 'about_excerpt_length');
    $author_show_social =liora_get_option( 'author_social_link');
    $homepage_design_layout     = liora_get_option( 'homepage_design_layout_options' );
    $about_highlight_title     = liora_get_option( 'about_highlight_title' );
    $btn_text = liora_get_option( 'about_btn_text');
?>
<?php 
    $msg_title_class= '';
    if (!empty($about_highlight_title)) {
        $msg_title_class= 'enable-msg-highlight';
    } 
?>
    <style>
        <?php if ($about_header_font_size != 0): ?>
            #about .entry-title{
                font-size:<?php echo esc_html($about_header_font_size); ?>px;
            }
        <?php endif ?>
        <?php if ($about_content_font_size != 0): ?>
            #about .entry-content{
                font-size:<?php echo esc_html($about_content_font_size); ?>px;
            }
        <?php endif ?>
        <?php if ($about_highlight_font_size != 0): ?>
            @media screen and (min-width: 1260px)
                #about .featured-image,
                #about .upper-title{
                    font-size:<?php echo esc_html($about_highlight_font_size); ?>px;
                }
            }
        <?php endif ?>
    </style>
    <?php 
        $about_id = liora_get_option( 'about_page' );
            $args = array (
            'post_type'     => 'page',
            'posts_per_page' => 1,
            'p' => $about_id,
            
        );
        $the_query = new WP_Query( $args );

        // The Loop
        while ( $the_query->have_posts() ) : $the_query->the_post(); ?>  
            <div class="section-content">
               <?php if(has_post_thumbnail()) : ?>
                    <div class="featured-image <?php echo $msg_title_class; ?>" >
                        <?php if ( !empty($about_highlight_title)): ?>
                            <span class="author-name"><?php echo esc_html($about_highlight_title); ?></span>
                        <?php endif; ?>
                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="">
                    </div><!-- .author-thumbnail -->
                <?php endif ?>
                <div class="entry-container">
                    <div class="entry-title">
                        <?php the_title();?>    
                    </div><!-- .section-header -->
                    <h2 class="entry-content">
                        <?php  
                            $excerpt = liora_the_excerpt( $excerpt_length );
                            echo wp_kses_post( wpautop( $excerpt ) ); 
                         ?>
                    </h2><!-- .entry-content -->
                    <?php if ( !empty( $btn_text ) ) : ?>
                        <div class="read-more">
                            <a href="<?php the_permalink();?>" class="btn-text"> <?php echo esc_html($btn_text);?></a>
                        </div>
                    <?php endif; ?>

                    <div class="separator"></div>


                        <div class="share-about">
                            <ul class="social-icons">
                                <?php  for( $i=1; $i<=4; $i++ ){ ?>
                                    <?php $social_links= liora_get_option( 'author_social_links_'.$i);?>
                                    <?php if( !empty($social_links) ) { ?>
                                        <li><a href=" <?php echo esc_url($social_links); ?>"></a></li>
                                    <?php } ?>
                                <?php } 
                                ?>
                            </ul>
                        </div><!-- .share-about -->
                </div>
            </div><!-- .section-content --> 
        <?php endwhile; ?>
       <?php wp_reset_postdata(); ?>