<?php
/**
 * Register SideBar meta box(es).
 */
 
/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function liora_sidebar_callback( $post ) {
    // Display code/markup goes here. Don't forget to include nonces!

    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'liora_select_sidebar_save_meta_box', 'liora_select_sidebar_meta_box_nonce' );

    $liora_sidebar_meta = get_post_meta( $post->ID, 'liora-select-sidebar', true );
	$choices = array( 
			'right' => esc_html__( 'Right', 'liora' ),
            'left' => esc_html__( 'Left', 'liora' ), 
			'no'    => esc_html__( 'No Sidebar', 'liora' ), 
		);

		foreach ( $choices as $value => $name ) : ?>
	    	<p>
	    		<label>
					<input value="<?php echo esc_attr( $value ); ?>" <?php checked( $liora_sidebar_meta, $value, true ); ?> name="liora-select-sidebar" type="radio" />
					<?php echo esc_html( $name ); ?>
	    		</label>
			</p>	
		<?php endforeach; 

}
 
/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function liora_save_sidebar_meta_box( $post_id ) {
    // Save logic goes here. Don't forget to include nonce checks!

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // Check if our nonce is set.
    if ( ! isset( $_POST['liora-select-sidebar'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( sanitize_key( $_POST['liora_select_sidebar_meta_box_nonce'] ), 'liora_select_sidebar_save_meta_box' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    /* OK, it's safe for us to save the data now. */
    
    // Make sure that it is set.
    if ( isset( $_POST['liora-select-sidebar'] ) ) {
        // Sanitize user input.
        $liora_sidebar_meta = sanitize_text_field( wp_unslash( $_POST['liora-select-sidebar'] ) );
        // Update the meta field in the database.
        update_post_meta( $post_id, 'liora-select-sidebar', $liora_sidebar_meta );
    }
}
add_action( 'save_post', 'liora_save_sidebar_meta_box' );