<?php
/**
 * Liora metabox file.
 *
 * This is the template that includes all the other files for metaboxes of Liora theme
 *
 * @package Liora
 * @since Liora 0.1
 */
// Include Post subtitle meta
require get_template_directory() . '/inc/metabox/video-url.php'; 
// Include Post subtitle meta
require get_template_directory() . '/inc/metabox/sidebar.php'; 
// Include Post subtitle meta
require get_template_directory() . '/inc/metabox/container-width.php'; 




if ( ! function_exists( 'liora_custom_meta' ) ) : 
    /**
     * Adds meta box to the post editing screen
     */
    function liora_custom_meta() {
        $post_type = array( 'post', 'page' );

        // POST Subtitle 
        add_meta_box( 'liora_video_url', esc_html__( 'Video Links', 'liora' ), 'liora_video_url_callback', $post_type, 'side' );
        // POST Subtitle 
        add_meta_box( 'liora-select-site-width', esc_html__( 'Site Layout', 'liora' ), 'liora_site_width_callback', $post_type, 'side' );
        // POST Subtitle 
        add_meta_box( 'liora-select-sidebar', esc_html__( 'Sidebar', 'liora' ), 'liora_sidebar_callback', $post_type, 'side' );
               
    }
endif;
add_action( 'add_meta_boxes', 'liora_custom_meta' );



