<?php
/**
 * Register Site Width meta box.
 */
 
/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function liora_site_width_callback( $post ) {
    // Display code/markup goes here. Don't forget to include nonces!

    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'liora_select_site_width_save_meta_box', 'liora_select_site_width_meta_box_nonce' );

    $liora_site_width_meta = get_post_meta( $post->ID, 'liora-select-site-width', true );
	$choices = array( 
			'default-site-layout' => esc_html__( 'Default', 'liora' ),
            'full-layout' => esc_html__( 'Full Width', 'liora' ),
            'boxed-layout' => esc_html__( 'Boxed Width', 'liora' ), 
            'frame-layout' => esc_html__( 'Frame Width', 'liora' ), 
		);

		foreach ( $choices as $value => $name ) : ?>
	    	<p>
	    		<label>
					<input value="<?php echo esc_attr( $value ); ?>" <?php checked( $liora_site_width_meta, $value, true ); ?> name="liora-select-site-width" type="radio" />
					<?php echo esc_html( $name ); ?>
	    		</label>
			</p>	
		<?php endforeach; 

}
 
/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function liora_save_site_width_meta_box( $post_id ) {
    // Save logic goes here. Don't forget to include nonce checks!

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // Check if our nonce is set.
    if ( ! isset( $_POST['liora-select-site-width'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( sanitize_key( $_POST['liora_select_site_width_meta_box_nonce'] ), 'liora_select_site_width_save_meta_box' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    /* OK, it's safe for us to save the data now. */
    
    // Make sure that it is set.
    if ( isset( $_POST['liora-select-site-width'] ) ) {
        // Sanitize user input.
        $liora_site_width_meta = sanitize_text_field( wp_unslash( $_POST['liora-select-site-width'] ) );
        // Update the meta field in the database.
        update_post_meta( $post_id, 'liora-select-site-width', $liora_site_width_meta );
    }
}
add_action( 'save_post', 'liora_save_site_width_meta_box' );