<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package Liora
 */

if( ! function_exists( 'liora_site_branding' ) ) :
	/**
  	 * Site Branding
  	 *
  	 * @since 1.0.0
  	 */
function liora_site_branding() { ?>
    <?php $enable_header_background = liora_get_option('disable_header_background_section');
    $header_background_image = liora_get_option('header_background_image'); 
    $show_social  = liora_get_option( 'show_header_social_links' ); 
    $show_menu_social  = liora_get_option( 'show_menu_social_links' );
    $header_social_link =liora_get_option('header_social_link');
    $show_header_search =liora_get_option('show_header_search');
    $homelayout     = liora_get_option( 'homepage_design_layout_options' ); 
    $headerlayout= liora_get_option('header_layout_options');
    $header_ads_image =liora_get_option('header_ads_image');
    $header_ads_image_url =liora_get_option('header_ads_image_url'); 
    $show_header_contact = liora_get_option( 'enable_header_contact_info' );
    $location_address     = liora_get_option( 'header_location_address' );
    $email_address        = liora_get_option( 'header_email' );
    $phone_contact        = liora_get_option( 'header_phone_contact' );
    $location_text     = liora_get_option( 'header_location_text' );
    $email_text        = liora_get_option( 'header_email_text' );
    $phone_contact_text        = liora_get_option( 'header_phone_text' );
    $enable_menu_social =liora_get_option('enable_menu_social_links');
    $menu_social_link =liora_get_option('menu_social_link'); ?>
    
    <?php if ($headerlayout == 'modern-menu') { ?>
        <div class="site-menu" <?php if ($enable_header_background == true ) { ?> style="background-image: url('<?php echo esc_url($header_background_image) ?>');" <?php } ?> >
            <div class="overlay"></div>
            <div class="wrapper">
                <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php echo esc_attr__('Primary Menu', 'liora'); ?>">
                    <div class="header-menu-wrapper">
                        <button type="button" class="menu-toggle">
                            <span class="icon-bar"></span>
                            <span class="icon-bar close-bar"></span>
                            <span class="icon-bar"></span>
                        </button>

                        <?php
                        wp_nav_menu( array(
                            'theme_location' => 'primary',
                            'menu_id'        => 'primary-menu',
                            'menu_class'     => 'nav-menu',
                            'fallback_cb'    => 'liora_primary_navigation_fallback',
                        ) );
                        ?>
                    </div>
                </nav><!-- #site-navigation -->
                <div class="header-logo-ads">
                    <div class="site-branding" >
                        <div class="site-logo">
                            <?php if(has_custom_logo()):?>
                                <?php the_custom_logo();?>
                            <?php endif;?>
                        </div><!-- .site-logo -->

                        <div id="site-identity">
                            <h1 class="site-title">
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">  <?php bloginfo( 'name' ); ?></a>
                            </h1>

                            <?php 
                                $description = get_bloginfo( 'description', 'display' );
                                if ( $description || is_customize_preview() ) : ?>
                                <p class="site-description"><?php echo esc_html($description);?></p>
                            <?php endif; ?>
                        </div><!-- #site-identity -->
                    </div> <!-- .site-branding -->
                </div>
                
                <?php if ( $show_menu_social==true){ ?>
                   <div class="widget widget_social_icons">
                       <ul class="social-icons">
                            <?php 
                            $header_social_links = ! empty( $header_social_link ) ? explode( '|', ( $header_social_link ) ) : array();
                            foreach ($header_social_links as $social_links ) { 
                                if ( isset( $social_links ) ) { 
                                ?>
                                    <li><a href=" <?php echo esc_url($social_links); ?>"></a></li>
                                <?php }  
                            } ?>
                        </ul> 
                    </div><!-- .widget_social_icons -->
                <?php } ?>
            </div>
        </div><!-- .site-menu -->
    <?php } elseif ($headerlayout == 'header-nine') { ?>
        <div class="site-menu" <?php if ($enable_header_background == true ) { ?> style="background-image: url('<?php echo esc_url($header_background_image) ?>');" <?php } ?> >
            <div class="wrapper">
                <div class="header-logo-ads">
                    <div class="site-branding" >
                        <div class="site-logo">
                            <?php if(has_custom_logo()):?>
                                <?php the_custom_logo();?>
                            <?php endif;?>
                        </div><!-- .site-logo -->

                        <div id="site-identity">
                            <h1 class="site-title">
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">  <?php bloginfo( 'name' ); ?></a>
                            </h1>

                            <?php 
                                $description = get_bloginfo( 'description', 'display' );
                                if ( $description || is_customize_preview() ) : ?>
                                <p class="site-description"><?php echo esc_html($description);?></p>
                            <?php endif; ?>
                        </div><!-- #site-identity -->
                    </div> <!-- .site-branding -->
                </div>
                <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php echo esc_attr__('Primary Menu', 'liora'); ?>">
                    <div class="header-menu-wrapper">
                        <button type="button" class="menu-toggle">
                            <span class="icon-bar"></span>
                            <span class="icon-bar close-bar"></span>
                            <span class="icon-bar"></span>
                        </button>

                        <?php
                        wp_nav_menu( array(
                            'theme_location' => 'primary',
                            'menu_id'        => 'primary-menu',
                            'menu_class'     => 'nav-menu',
                            'fallback_cb'    => 'liora_primary_navigation_fallback',
                        ) );
                        ?>
                    </div>
                </nav><!-- #site-navigation -->
            </div>
        </div><!-- .site-menu -->
    <?php } else { ?>
        <div class="site-menu" <?php if ($enable_header_background == true ) { ?> style="background-image: url('<?php echo esc_url($header_background_image) ?>');" <?php } ?> >
            <div class="overlay"></div>
            <div class="wrapper">
                <div class="header-logo-ads">
                    <div class="site-branding" >
                        <div class="site-logo">
                            <?php if(has_custom_logo()):?>
                                <?php the_custom_logo();?>
                            <?php endif;?>
                        </div><!-- .site-logo -->

                        <div id="site-identity">
                            <h1 class="site-title">
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">  <?php bloginfo( 'name' ); ?></a>
                            </h1>

                            <?php 
                                $description = get_bloginfo( 'description', 'display' );
                                if ( $description || is_customize_preview() ) : ?>
                                <p class="site-description"><?php echo esc_html($description);?></p>
                            <?php endif; ?>
                        </div><!-- #site-identity -->
                    </div> <!-- .site-branding -->
                    <?php if ( !empty($header_ads_image) || ( ( ! empty( $email_address ) || ! empty( $phone_contact ) || ! empty( $location ) ) && $show_header_contact==true ) ) { ?>
                        <?php if (!empty($header_ads_image)): ?>
                            <div class="header_ads">
                               <a class="_blank" href="<?php echo esc_url($header_ads_image_url); ?>"><img src="<?php echo esc_url($header_ads_image) ?>"></a>
                            </div><!-- .widget_ads -->
                        <?php endif ?>
                        <?php if ( ( ! empty( $email_address ) || ! empty( $phone_contact ) || ! empty( $location_address ) ) && $show_header_contact==true ): ?>
                            <div class="widget widget_address_block">
                                <ul> 
                                    <?php if( ! empty( $location_address ) ){ ?>
                                        <li>
                                            <i class="fa fa-map-marker"></i>
                                            <div class="header-contact-info">
                                                <h5><?php echo esc_html( $location_text ); ?></h5>
                                                <span><?php echo esc_html( $location_address ); ?></span>
                                            </div>
                                        </li>
                                    <?php } ?>
                                    <?php if( ! empty( $phone_contact ) ){ ?>
                                        <li>
                                            <i class="fa fa-phone"></i>
                                            <div class="header-contact-info">
                                                <h5><?php echo esc_html( $phone_contact_text ); ?></h5>
                                                <span><a href="tel: <?php echo esc_attr( $phone_contact ) ?>"><?php echo esc_html( $phone_contact ) ?></a></span>
                                            </div>
                                        </li>
                                    <?php } ?>
                                    <?php if( ! empty( $email_address) ){ ?>
                                        <li>
                                            <i class="fa fa-envelope"></i>
                                            <div class="header-contact-info">
                                                <h5><?php echo esc_html( $email_text ); ?></h5>
                                                <span><a href=" <?php echo esc_url('mailto:' . sanitize_email($email_address)) ?>"><?php echo esc_html( $email_address) ?></a></span>
                                            </div>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div><!-- .widget_address_block -->
                        <?php endif ?>
                    <?php } ?>
                </div>
                <nav id="site-navigation" class="main-navigation <?php if(($enable_menu_social==true)){ ?> content-center <?php } ?>" role="navigation" aria-label="<?php echo esc_attr__('Primary Menu', 'liora'); ?>">
                <style type="text/css">
                    <?php  
                        $no_of_menu_items =liora_get_option( 'number_of_menu_items'); 
                        for ($i=0; $i <= $no_of_menu_items ; $i++) {
                            $menu_item_color =liora_get_option( 'menu_item_font_color_'.$i ); ?>
                        .kids-menu .main-navigation ul#primary-menu > li.fa:nth-child(<?php echo esc_attr($i) ?>):after,
                        .kids-menu .main-navigation ul#primary-menu > li.far:nth-child(<?php echo esc_attr($i) ?>):after,
                        .kids-menu .main-navigation ul#primary-menu > li.fab:nth-child(<?php echo esc_attr($i) ?>):after,
                        .kids-menu .main-navigation ul#primary-menu > li.fas:nth-child(<?php echo esc_attr($i) ?>):after {
                            border-color: <?php echo esc_attr($menu_item_color) ?>;
                        }
                        .kids-menu .main-navigation ul > li:nth-child(<?php echo esc_attr($i) ?>) ul li:hover > a,
                        .kids-menu .main-navigation ul > li:nth-child(<?php echo esc_attr($i) ?>) ul li.focus > a{
                            background-color: <?php echo esc_attr($menu_item_color) ?>;
                        }
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>):before {
                            background-color: <?php echo esc_attr($menu_item_color) ?>;
                            border-color: <?php echo esc_attr($menu_item_color) ?>;
                        }
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>):hover:before,
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>):focus:before,
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>):hover > a,
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>).focus > a {
                            color: <?php echo esc_attr($menu_item_color) ?>;
                        } 
                        .kids-menu .main-navigation ul#primary-menu > li:nth-child(<?php echo esc_attr($i) ?>):hover:before {
                            background-color: transparent;
                        }
                    <?php } ?>
                </style>
                <div class="header-menu-wrapper">
                    <?php if (($homelayout=='home-normal-magazine' || $homelayout=='home-magazine') && ($headerlayout=='header-two'||$headerlayout=='header-three')): ?>
                        <div class="home-icon"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><i
                        class="fa fa-home"></i></a></div>
                    <?php endif; ?>
                        <button type="button" class="menu-toggle">
                            <span class="icon-bar"></span>
                            <span class="icon-bar close-bar"></span>
                            <span class="icon-bar"></span>
                        </button>

                        <?php
                        wp_nav_menu( array(
                            'theme_location' => 'primary',
                            'menu_id'        => 'primary-menu',
                            'menu_class'     => 'nav-menu',
                            'fallback_cb'    => 'liora_primary_navigation_fallback',
                        ) );
                        ?>
                </div>
                </nav><!-- #site-navigation -->
                <?php 
                if ( ($enable_menu_social==true) && ($headerlayout == 'header-one') && (!empty($menu_social_link)) ){ ?>
                   <div class="menu-social-icons">
                       <ul class="social-icons">
                            <?php 
                                $menu_social_links = ! empty( $menu_social_link ) ? explode( '|', ( $menu_social_link ) ) : array();
                                foreach ($menu_social_links as $social_links ) { 
                                    if ( isset( $social_links ) ) { ?>
                                        <li><a href=" <?php echo esc_url($social_links); ?>"></a></li>
                                    <?php }  
                                } 
                            ?>
                        </ul> 
                    </div><!-- .menu-social-icons -->
                <?php } ?>
            </div>
        </div><!-- .site-menu -->
    <?php } ?>
<?php }
endif;
add_action( 'liora_action_header', 'liora_site_branding', 10 );

if ( ! function_exists( 'liora_subscription_section' ) ) :

  /**
   * Top  Footer 
   *
   * @since 1.0.0
   */
function liora_subscription_section() {
    $disable_subscription_section = liora_get_option( 'disable_subscription_section' );
    $subscription_bg_image = liora_get_option( 'subscription_background_image' );
    if( true ==$disable_subscription_section): ?>
        <section id="subscription" class="relative page-section">
            <div class="wrapper">
                <?php get_template_part( 'inc/sections/section-subscription' ); ?>
            </div>
        </section>
    <?php endif; 

 }
endif;

add_action( 'liora_action_subscription', 'liora_subscription_section', 10 );

if ( ! function_exists( 'liora_footer_top_section' ) ) :

  /**
   * Top  Footer 
   *
   * @since 1.0.0
   */
  function liora_footer_top_section() {
      $footer_sidebar_data = liora_footer_sidebar_class();
      $footer_sidebar    = $footer_sidebar_data['active_sidebar'];
      $footer_class      = $footer_sidebar_data['class'];
      $enable_footer_background   = liora_get_option( 'enable_footer_background_image' );
      $footer_background     = liora_get_option( 'footer_background_image' );
      if ( empty( $footer_sidebar ) ) {
        return;
      }      ?>
      <div class="footer-widgets-area page-section <?php echo esc_attr( $footer_class ); ?>" > <!-- widget area starting from here -->
            <div class="wrapper">
                <?php
                  for ( $i = 1; $i <= 4 ; $i++ ) {
                    if ( is_active_sidebar( 'footer-' . $i ) ) {
                    ?>
                      <div class="hentry">
                        <?php dynamic_sidebar( 'footer-' . $i ); ?>
                      </div>
                      <?php
                    }
                  }
                ?>
            </div>
      </div> <!-- widget area starting from here -->
    <?php
 }
endif;
add_action( 'liora_action_footer', 'liora_footer_top_section', 10 );

/**
 * 
 * Subscription Section
 * 
 * */
if ( ! function_exists( 'liora_subscription_section' ) ) :

  /**
   * Top  Footer 
   *
   * @since 1.0.0
   */
  function liora_subscription_section() {
     $disable_subscription_section = liora_get_option( 'disable_subscription_section' );
           if( true ==$disable_subscription_section): ?>
              <section id="subscription" class="relative page-section">
                <div class="wrapper">
                    <?php get_template_part( 'inc/sections/section-subscription' ) ; ?>
                </div>
              </section>
      <?php endif; 

 }
endif;
add_action( 'liora_action_subscription', 'liora_subscription_section', 10 );

/**
 * 
 * Related Post Section
 * 
 * */
if ( ! function_exists( 'liora_single_related_posts_section' ) ) :
    function liora_single_related_posts_section() {
        if ( is_singular( 'post' ) &&  (liora_get_option( 'liora_single_related_posts' ) ==true) ) {
             global $post;
            $args = array(
                'posts_per_page' => 4,
                'post__not_in'   => array( $post->ID ),
                'orderby'        => 'rand',
            );

            $cat_content_id = get_the_category( $post->ID );
            if ( ! empty( $cat_content_id ) ) {
                $args['cat'] = $cat_content_id[0]->term_id;
            }

            $query = new WP_Query( $args );

            if ( $query->have_posts() ) :
                $related_post_title = liora_get_option( 'liora_single_related_post_title' );
                ?>
                <div id="single-related-posts" class="single-related-posts wrapper relative clear">
                    <?php if ( ! empty( $related_post_title ) ) : ?>
                        <h2 class="related-posts-title"><?php echo esc_html( $related_post_title ); ?></h2>
                    <?php endif; ?>
                    <div class="related-posts-wrapper col-4">
                        <?php
                        while ( $query->have_posts() ) :
                            $query->the_post();
                            ?>
                            <article id="post-<?php the_ID(); ?>" class="" >
                                <div class="related-post-inner">
                                    <span class="post-readtime"><i class="fa fa-clock"></i><?php echo liora_time_interval(); ?><?php esc_html_e( 'min', 'liora' ); ?></span>
                                    <span class="count-post-views"><i class="fa fa-eye"></i><?php echo liora_getPostViews( get_the_ID()); ?></span>
                                    <div class="post-featured-image">   
                                        <div class="featured-image post-bg-image" style="background-image: url('<?php the_post_thumbnail_url( 'full' ); ?>');">
                                            <a href="<?php the_permalink(); ?>" class="post-thumbnail-link"></a>
                                        </div><!-- .featured-image -->
                                    </div>
                                    <div class="entry-container content-left">
                                        <header class="entry-header">
                                            
                                            <div class="entry-meta post-cat">
                                                <?php liora_entry_meta(); ?>
                                            </div><!-- .entry-meta -->
                                            
                                            <?php

                                                the_title( '<h2 class="entry-title" ><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                             ?>
                                        </header><!-- .entry-header -->
                                    </div><!-- .entry-container -->
                                </div>
                            </article><!-- #post-## -->
                            <?php
                        endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <?php
            endif;
        }
    }
endif;
add_action( 'liora_single_post_related_posts', 'liora_single_related_posts_section', 10 );

/**
 * 
 * Must Read Section
 * 
 * */
if ( ! function_exists( 'liora_mustread_section' ) ) :

  /**
   * Mustread 
   *
   * @since 1.0.0
   */
  function liora_mustread_section() {
    $disable_mustread_section = liora_get_option( 'disable_mustread_section' );
    if( true ==$disable_mustread_section): ?>
        <section id="mustread" class="relative page-section">
            <div class="wrapper">
                <?php get_template_part( 'inc/sections/section-mustread' ); ?>
            </div>
        </section>
    <?php endif; 

 }
endif;
add_action( 'liora_action_mustread', 'liora_mustread_section', 10 );
/**
 * 
 * Featuredpost Section
 * 
 * */
if ( ! function_exists( 'liora_featuredpost_section' ) ) :

  /**
   * Featuredpost
   *
   * @since 1.0.0
   */
  function liora_featuredpost_section() {

        $disable_featuredpost_section = liora_get_option( 'disable_featuredpost_section' );
        $featuredpost_lite_dark_background = liora_get_option( 'featuredpost_lite_dark_background' );
        if( true ==$disable_featuredpost_section): ?>
            <section id="featuredpost" class="relative page-section <?php echo esc_attr($featuredpost_lite_dark_background) ?>">
                <div class="wrapper">
                    <?php get_template_part( 'inc/sections/section-featuredpost'); ?>
                </div>
            </section> 
        <?php endif; 

 }
endif;
add_action( 'liora_action_featuredpost', 'liora_featuredpost_section', 10 );

/**
 * 
 * Instagram Section
 * 
 * */
if ( ! function_exists( 'liora_instagram_section' ) ) :

  /**
   * instagram 
   *
   * @since 1.0.0
   */
  function liora_instagram_section() {
     $disable_instagram_section = liora_get_option( 'disable_instagram_section' );
           if( true ==$disable_instagram_section): ?>
              <section id="instagram" class="relative page-section">
                  <?php get_template_part( 'inc/sections/section-instagram' ); ?>
              </section>
      <?php endif; 

 }
endif;
add_action( 'liora_action_instagram', 'liora_instagram_section', 10 );

/**
 * Footer Section
 * */
if ( ! function_exists( 'liora_footer_section' ) ) :
  /**
   * Footer copyright
   *
   * @since 1.0.0
   */
  function liora_footer_section() { ?>
        <div class="site-info">
            <?php 
                $copyright_footer = liora_get_option('copyright_text'); 
                $powered_by_footer = liora_get_option('powered_by_text'); 
                if ( ! empty( $copyright_footer ) ) {
                  $copyright_footer = wp_kses_data( $copyright_footer );
                }
                // Powered by content.
                if ( ! empty( $powered_by_footer ) ) {
                  $powered_by_text = wp_kses_post( $powered_by_footer);
                }
            ?>
            <div class="wrapper">
                <span class="copy-right"><?php echo esc_html($copyright_footer);?><?php echo esc_html( $powered_by_text);?></span>
            </div> 
        </div> <!-- site generator ends here -->
        
    <?php }
endif;
add_action( 'liora_action_footer', 'liora_footer_section', 20 );

/**
 * 
 * Footer Widgets
 * 
 * */
if ( ! function_exists( 'liora_footer_sidebar_class' ) ) :
  /**
   * Count the number of footer sidebars to enable dynamic classes for the footer
   *
   * @since Liora 0.1
   */
  function liora_footer_sidebar_class() {
    $data = array();
    $active_sidebar = array();
      $count = 0;

      if ( is_active_sidebar( 'footer-1' ) ) {
        $active_sidebar[]   = 'footer-1';
          $count++;
      }

      if ( is_active_sidebar( 'footer-2' ) ){
        $active_sidebar[]   = 'footer-2';
          $count++;
    }

      if ( is_active_sidebar( 'footer-3' ) ){
        $active_sidebar[]   = 'footer-3';
          $count++;
      }

      if ( is_active_sidebar( 'footer-4' ) ){
        $active_sidebar[]   = 'footer-4';
          $count++;
      }

      $class = '';

      switch ( $count ) {
          case '1':
            $class = 'col-1';
            break;
          case '2':
            $class = 'col-2';
            break;
          case '3':
            $class = 'col-3';
            break;
            case '4':
            $class = 'col-4';
            break;
      }

    $data['active_sidebar'] = $active_sidebar;
    $data['class']        = $class;

      return $data;
  }
endif;

/**
 * 
 * Excerpt Length
 * 
 * */
if ( ! function_exists( 'liora_excerpt_length' ) ) :
  /**
   * Implement excerpt length.
   *
   * @since 1.0.0
   *
   * @param int $length The number of words.
   * @return int Excerpt length.
   */
  function liora_excerpt_length( $length ) {

    if ( is_admin() ) {
      return $length;
    }

    $excerpt_length = liora_get_option( 'excerpt_length' );

    if ( absint( $excerpt_length ) > 0 ) {
      $length = absint( $excerpt_length );
    }

    return $length;
  }
endif;
add_filter( 'excerpt_length', 'liora_excerpt_length', 999 );

/**
 * 
 * Banner Header
 * 
 * */
if( ! function_exists( 'liora_banner_header
  ' ) ) :
    /**
     * Page Header
    */
    function liora_banner_header() { 

        if ( is_front_page() && is_home() ){ 
            $header_image = get_header_image();
            $header_image_url = ! empty( $header_image ) ?  $header_image : get_template_directory_uri() . '/assets/images/default-header.jpg';
        }
        elseif( is_front_page() ) {
            return;
        }
        else {
            $header_image_url = liora_banner_image( $image_url = '' );
        } ?>
        <div id="page-site-header" style="background-image: url('<?php echo esc_url( $header_image_url ); ?>');">
            <div class="overlay"></div>
            <header class='page-header'> 
                <div class="wrapper">
                    <?php liora_banner_title();?>
                </div><!-- .wrapper -->
            </header>
        </div><!-- #page-site-header -->
        <?php echo '<div class= "page-section">'; ?>
    <?php }
endif;
add_action( 'liora_banner_header', 'liora_banner_header', 10 );

/**
 * Remove Category text from archive page
 * remove_category_text_archive_page
*/
if (true == liora_get_option( 'remove_category_text_archive_page' )) :
    add_filter( 'get_the_archive_title', function ($title) {
      if ( is_category() ) {
        $title = single_cat_title( '', false );
      } 
      return $title; 
    });
endif;

if( ! function_exists( 'liora_banner_title' ) ) :
/**
 * Page Header
*/
function liora_banner_title(){ 
  $latest_posts_title = liora_get_option( 'latest_posts_title' );
  $single_post_title = liora_get_option( 'single_post_header_title_enable' ); 
  $single_page_title = liora_get_option( 'single_page_header_title_enable' );
  $blog_post_title_enable = liora_get_option( 'blog_post_header_title_enable' );
  $archive_post_title = liora_get_option( 'archive_post_header_title_enable' );
    if ( (( is_front_page() && is_home() ) || is_home() ) && !empty($latest_posts_title && $blog_post_title_enable==true) ){ ?>
        <h2 class="page-title"><?php echo esc_html($latest_posts_title); ?></h2><?php
    }

    if( is_single() && $single_post_title==true) {
        the_title( '<h2 class="page-title">', '</h2>' );
    }
    if( is_page() && $single_page_title==true) {
        the_title( '<h2 class="page-title">', '</h2>' );
    }       
    if( is_archive() && $archive_post_title==true ){
        the_archive_description( '<div class="archive-description">', '</div>' );
        the_archive_title( '<h2 class="page-title">', '</h2>' );
    }

    if( is_search() ){ ?>
        <h2 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'liora' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
    <?php }
    
    if( is_404() ) {
        echo '<h2 class="page-title">' . esc_html__( 'Error 404', 'liora' ) . '</h2>';
    }
}
endif;

if( ! function_exists( 'liora_banner_image' ) ) :
/**
 * Banner Header Image
*/
function liora_banner_image( $image_url ){
    global $post;

    $search_header = liora_get_option( 'search_header_image' );
    $header_404 = liora_get_option( '404_header_image' );
     $post_header_image_condition = liora_get_option( 'single_post_header_image_as_header_image_enable' );
    $page_header_image_condition = liora_get_option( 'single_page_header_image_as_header_image_enable' );

    if ( is_home() && ! is_front_page() ){ 
        $image_url      = get_the_post_thumbnail_url( get_option( 'page_for_posts' ), 'full' );
        $header_image = get_header_image();
        $fallback_image = ! empty( $header_image ) ?  $header_image : get_template_directory_uri() . '/assets/images/default-header.jpg';
        $image_url      = ( ! empty( $image_url) ) ? $image_url : $fallback_image;
    }
    elseif( is_single() ){
        $image_url      = get_the_post_thumbnail_url( $post->ID, 'full' );
        $header_image = get_header_image();
        $fallback_image = ! empty( $header_image ) ?  $header_image : get_template_directory_uri() . '/assets/images/default-header.jpg';
        $image_url      = ( ! empty( $image_url) && $post_header_image_condition==false ) ? $image_url : $fallback_image;
    }
    elseif( is_page() ){
        $image_url      = get_the_post_thumbnail_url( $post->ID, 'full' );
        $header_image = get_header_image();
        $fallback_image = ! empty( $header_image ) ?  $header_image : get_template_directory_uri() . '/assets/images/default-header.jpg';
        $image_url      = ( ! empty( $image_url) && $page_header_image_condition==false ) ? $image_url : $fallback_image;
    }
    elseif( is_archive() ){
         if (function_exists('z_taxonomy_image_url') && !empty(z_taxonomy_image_url())){
              $archive_header = z_taxonomy_image_url(); 
            } else{
                $archive_header = get_header_image();
            }
        $image_url = ( ! empty( $archive_header) ) ? $archive_header : get_template_directory_uri() . '/assets/images/default-header.jpg';
    }
    elseif( is_search() ){ 
        $image_url = ( ! empty( $search_header) ) ? $search_header : get_template_directory_uri() . '/assets/images/default-header.jpg';
    }
    elseif( is_404() ) {
        $image_url = ( ! empty( $header_404) ) ? $header_404 : get_template_directory_uri() . '/assets/images/default-header.jpg';
    }
    return $image_url;
}
endif;

/**
 * 
 * Preloader
 * 
 * */
if ( ! function_exists( 'liora_preloader' ) ) :
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    function liora_preloader() { 
        $loader_options = liora_get_option( 'preloader_loader_options' );?>
        <?php if ($loader_options=='loader-1'): ?>
            <div class="middle">
              <div class="bar bar1"></div>
              <div class="bar bar2"></div>
              <div class="bar bar3"></div>
              <div class="bar bar4"></div>
              <div class="bar bar5"></div>
              <div class="bar bar6"></div>
              <div class="bar bar7"></div>
              <div class="bar bar8"></div>
            </div>
        <?php endif; ?>
        <?php if ($loader_options=='loader-2'): ?>
            <div class="loader2">
              <p class="loader2">l</p>
              <p class="loader2">o</p>
              <p class="loader2">a</p>
              <p class="loader2">d</p>
              <p class="loader2">i</p>
              <p class="loader2">n</p>
              <p class="loader2">g</p>
            </div>
        <?php endif; ?>
        <?php if ($loader_options=='loader-3'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-3.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-4'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-4.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-5'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-5.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-6'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-6.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-7'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-7.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-8'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-8.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-9'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-9.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-10'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-10.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-11'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-11.gif' ); ?>">
        <?php endif; ?>
        <?php if ($loader_options=='loader-12'): ?>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/loader-12.gif' ); ?>">
        <?php endif; ?>
    <?php }
endif;

if ( ! function_exists( 'liora_posts_tags' ) ) :
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    function liora_posts_tags() {
        // Hide category and tag text for pages.
        if ( 'post' === get_post_type() && has_tag() ) { ?>
                <div class="tags-links">

                    <?php /* translators: used between list items, there is a space after the comma */
                    $tags = get_the_tags();
                    if ( $tags ) {

                        foreach ( $tags as $tag ) {
                            echo '<span><a href="' . esc_url( get_tag_link( $tag->term_id ) ) .'">' . esc_html( $tag->name ) . '</a></span>'; // WPCS: XSS OK.
                        }
                    } ?>
                </div><!-- .tags-links -->
        <?php } 
    }
endif;

function liora_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<p class="menu-item-description">' . $item->description . '</p>' . $args->link_after . '</a>', $item_output );
    }
 
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'liora_nav_description', 10, 4 );

/**
 * 
 * Sortable Section
 * 
 * */
if ( ! function_exists( 'liora_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function liora_sortable_sections() {
        $sections = array(
            'featured-slider'   =>  esc_html__( 'Slider Section', 'liora' ),
            'message'   => esc_html__( 'Author info', 'liora' ),
            'galleryview'   => esc_html__( 'Featured', 'liora' ),
            'travel'    => esc_html__( 'Two column Section', 'liora' ),
            'subscription'   =>esc_html__( 'Popular Section', 'liora' ), 
        );
        return apply_filters( 'liora_sortable_sections', $sections );
    }
endif;

/**
 * 
 * Pagination
 * 
 * */
if ( ! function_exists( 'liora_pagination' ) ) :
  /**
   * blog/archive pagination.
   *
   * @return pagination type value
   */
  function liora_pagination() {
    $pagination = liora_get_option( 'pagination_type' );
    if ( $pagination == 'default' ) :
      the_posts_navigation();
    elseif ( $pagination == 'numeric' ) :
      the_posts_pagination( array(
          'mid_size' => 4,
          // 'prev_text' => ,
          // 'next_text' => ,
      ) );
    endif;
  }
endif;
add_action( 'liora_pagination_action', 'liora_pagination', 10 );
