<?php
/**
 * Slider Post options.
 *
 * @package Liora
 */

$default = liora_get_default_theme_options();
$homepage_design_layout     = liora_get_option( 'homepage_design_layout_options' );

// Slider Post Section
$wp_customize->add_section( 'section_home_slider',
	array(
		'title'      => __( 'Slider', 'liora' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_slider_section]',
	array(
		'default'           => $default['disable_slider_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'liora_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Liora_Switch_Control( $wp_customize, 'theme_options[disable_slider_section]',
    array(
		'label' 			=> __('Enable/Disable Slider Post Section', 'liora'),
		'section'    		=> 'section_home_slider',
		 'settings'  		=> 'theme_options[disable_slider_section]',
		'on_off_label' 		=> liora_switch_options(),
    )
) );

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_content_align]', array(
	'default'           => $default['slider_content_align'],
	'sanitize_callback' => 'liora_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[slider_content_align]', array(
	'label'             => esc_html__( 'Choose Content Align', 'liora' ),
	'section'           => 'section_home_slider',
	'type'              => 'radio',
	'active_callback' => 'liora_slider_active',
	'choices'				=> array( 
		'content-right'     => esc_html__( 'Right Side', 'liora' ), 
		'content-center'     => esc_html__( 'Center Side', 'liora' ), 
		'content-left'     => esc_html__( 'Left Side', 'liora' ), 
		'content-justify'     => esc_html__( 'Justify', 'liora' )
		)
) );

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_category_enable]', array(
	'default'           => $default['slider_category_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_category_enable]', array(
	'label'             => esc_html__( 'Enable Category', 'liora' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_content_enable]', array(
	'default'           => $default['slider_content_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_content_enable]', array(
	'label'             => esc_html__( 'Enable Content', 'liora' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_posted_on_enable]', array(
	'default'           => $default['slider_posted_on_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date', 'liora' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_author_enable]', array(
	'default'           => $default['slider_author_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'liora' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_arrow_enable]', array(
	'default'           => $default['slider_arrow_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_arrow_enable]', array(
	'label'             => esc_html__( 'Enable Slider Arrow', 'liora' ),
	'section'           => 'section_featured_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add autoplay enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_autoplay_enable]', array(
	'default'           => $default['slider_autoplay_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_autoplay_enable]', array(
	'label'             => esc_html__( 'Enable Slider Autoplay', 'liora' ),
	'section'           => 'section_featured_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add autoplay enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_infinite_enable]', array(
	'default'           => $default['slider_infinite_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_infinite_enable]', array(
	'label'             => esc_html__( 'Enable Slider Slide Infinite', 'liora' ),
	'section'           => 'section_featured_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );

// Add autoplay enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_fade_enable]', array(
	'default'           => $default['slider_fade_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_fade_enable]', array(
	'label'             => esc_html__( 'Enable Slider Fade Effect', 'liora' ),
	'section'           => 'section_featured_slider',
	'type'              => 'checkbox',
	'active_callback' => 'liora_slider_active',
) );
// Number of items
$wp_customize->add_setting('theme_options[slider_speed]', 
	array(
	'default' 			=> $default['slider_speed'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'liora_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[slider_speed]', 
	array(
	'label'       => __('Slider Speed', 'liora'),
	'description' => __('Slider Speed Default speed 800', 'liora'),
	'section'     => 'section_featured_slider',   
	'settings'    => 'theme_options[slider_speed]',		
	'type'        => 'number',
	'active_callback' => 'liora_slider_active',
	)
);

// Number of items
$wp_customize->add_setting('theme_options[slider_excerpt_length]', 
	array(
	'default' 			=> $default['slider_excerpt_length'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'liora_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[slider_excerpt_length]', 
	array(
	'label'       => __('Excerpt Length', 'liora'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 1000.', 'liora'),
	'section'     => 'section_home_slider',   
	'settings'    => 'theme_options[slider_excerpt_length]',		
	'type'        => 'number',
	'active_callback' => 'liora_slider_active',
	'input_attrs' => array(
			'min'	=> 0,
			'max'	=> 1000,
			'step'	=> 1,
		),
	)
);

$number_of_slider_items = liora_get_option( 'number_of_slider_items' );

for( $i=1; $i<=$number_of_slider_items; $i++ ){

	//
	$wp_customize->add_setting('theme_options[slider_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'liora_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[slider_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'liora'), $i),
		'section'     => 'section_home_slider',   
		'settings'    => 'theme_options[slider_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => liora_post_choices(),
		'active_callback' => 'liora_slider_active',
		)
	);
}