<?php
/**
 * Must Read Post options.
 *
 * @package Liora
 */

$default = liora_get_default_theme_options();
$homepage_design_layout     = liora_get_option( 'homepage_design_layout_options' );

// Must Read Post Section
$wp_customize->add_section( 'section_home_mustread',
	array(
		'title'      => __( 'Must Read News', 'liora' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_mustread_section]',
	array(
		'default'           => $default['disable_mustread_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'liora_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Liora_Switch_Control( $wp_customize, 'theme_options[disable_mustread_section]',
    array(
		'label' 			=> __('Enable/Disable Must Read Post Section', 'liora'),
		'section'    		=> 'section_home_mustread',
		 'settings'  		=> 'theme_options[disable_mustread_section]',
		'on_off_label' 		=> liora_switch_options(),
    )
) );

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[mustread_content_align]', array(
	'default'           => $default['mustread_content_align'],
	'sanitize_callback' => 'liora_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[mustread_content_align]', array(
	'label'             => esc_html__( 'Choose Content Align', 'liora' ),
	'section'           => 'section_home_mustread',
	'type'              => 'radio',
	'active_callback' => 'liora_mustread_active',
	'choices'				=> array( 
		'content-right'     => esc_html__( 'Right Side', 'liora' ), 
		'content-center'     => esc_html__( 'Center Side', 'liora' ), 
		'content-left'     => esc_html__( 'Left Side', 'liora' ), 
		'content-justify'     => esc_html__( 'Justify', 'liora' )
		)
) );

//Must Read Post Section title
$wp_customize->add_setting('theme_options[mustread_title]', 
	array(
	'default'           => $default['mustread_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[mustread_title]', 
	array(
	'label'       => __('Section Title', 'liora'),
	'section'     => 'section_home_mustread',   
	'settings'    => 'theme_options[mustread_title]',
	'active_callback' => 'liora_mustread_active',		
	'type'        => 'text'
	)
);

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[mustread_category_enable]', array(
	'default'           => $default['mustread_category_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[mustread_category_enable]', array(
	'label'             => esc_html__( 'Enable Category', 'liora' ),
	'section'           => 'section_home_mustread',
	'type'              => 'checkbox',
	'active_callback' => 'liora_mustread_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[mustread_content_enable]', array(
	'default'           => $default['mustread_content_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[mustread_content_enable]', array(
	'label'             => esc_html__( 'Enable Content', 'liora' ),
	'section'           => 'section_home_mustread',
	'type'              => 'checkbox',
	'active_callback' => 'liora_mustread_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[mustread_posted_on_enable]', array(
	'default'           => $default['mustread_posted_on_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[mustread_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date', 'liora' ),
	'section'           => 'section_home_mustread',
	'type'              => 'checkbox',
	'active_callback' => 'liora_mustread_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[mustread_author_enable]', array(
	'default'           => $default['mustread_author_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[mustread_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'liora' ),
	'section'           => 'section_home_mustread',
	'type'              => 'checkbox',
	'active_callback' => 'liora_mustread_active',
) );

// Number of items
$wp_customize->add_setting('theme_options[mustread_excerpt_length]', 
	array(
	'default' 			=> $default['mustread_excerpt_length'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'liora_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[mustread_excerpt_length]', 
	array(
	'label'       => __('Excerpt Length', 'liora'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 1000.', 'liora'),
	'section'     => 'section_home_mustread',   
	'settings'    => 'theme_options[mustread_excerpt_length]',		
	'type'        => 'number',
	'active_callback' => 'liora_mustread_active',
	'input_attrs' => array(
			'min'	=> 0,
			'max'	=> 1000,
			'step'	=> 1,
		),
	)
);

$number_of_mustread_items = liora_get_option( 'number_of_mustread_items' );

for( $i=1; $i<=$number_of_mustread_items; $i++ ){

	// News
	$wp_customize->add_setting('theme_options[mustread_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'liora_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[mustread_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'liora'), $i),
		'section'     => 'section_home_mustread',   
		'settings'    => 'theme_options[mustread_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => liora_post_choices(),
		'active_callback' => 'liora_mustread_active',
		)
	);
}

?>