<?php
/**
 * Category List options.
 *
 * @package Liora
 */

$default = liora_get_default_theme_options();
$homepage_design_layout     = liora_get_option( 'homepage_design_layout_options' );

// Category List Author Section
$wp_customize->add_section( 'section_home_catlist',
	array(
		'title'      => __( 'Category List', 'liora' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_catlist_section]',
	array(
		'default'           => $default['disable_catlist_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'liora_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Liora_Switch_Control( $wp_customize, 'theme_options[disable_catlist_section]',
    array(
		'label' 			=> __('Enable/Disable Category List Section', 'liora'),
		'section'    		=> 'section_home_catlist',
		'settings'  		=> 'theme_options[disable_catlist_section]',
		'on_off_label' 		=> liora_switch_options(),
    )
) );
	
// Setting  Team Category.
$wp_customize->add_setting( 'theme_options[catlist_category]',
	array(

	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'liora_sanitize_category_list',
	)
);
$wp_customize->add_control(
	new Liora_Dropdown_Multiple_Chooser( $wp_customize, 'theme_options[catlist_category]',
		array(
		'label'    => __( 'Select Categories', 'liora' ),
		'description' => __('Press Ctrl and select categories for multiple categories', 'liora'),
		'section'  => 'section_home_catlist',
		'settings' => 'theme_options[catlist_category]',
		'type'           	=> 'dropdown_multiple_chooser',
		'choices'  => liora_category_choices(),
		'active_callback' => 'liora_catlist_active',		
		)
	)
);
