<?php
/**
 * Author options.
 *
 * @package Liora
 */

$default = liora_get_default_theme_options();
$homepage_design_layout     = liora_get_option( 'homepage_design_layout_options' );

// Author section
$wp_customize->add_section( 'section_home_about',
	array(
		'title'      => __( 'Author Section', 'liora' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_about_section]',
	array(
		'default'           => $default['disable_about_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'liora_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Liora_Switch_Control( $wp_customize, 'theme_options[disable_about_section]',
    array(
		'label' 			=> __('Disable Author section', 'liora'),
		'section'    		=> 'section_home_about',
		'on_off_label' 		=> liora_switch_options(),
    )
) );
// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[about_content_enable]', array(
	'default'           => $default['about_content_enable'],
	'sanitize_callback' => 'liora_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[about_content_enable]', array(
	'label'             => esc_html__( 'Enable Author Content Area', 'liora' ),
	'section'           => 'section_home_about',
	'type'              => 'checkbox',
	'active_callback' => 'liora_about_active',
) );

// Number of items
$wp_customize->add_setting('theme_options[about_excerpt_length]', 
	array(
	'default' 			=> $default['about_excerpt_length'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'liora_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[about_excerpt_length]', 
	array(
	'label'       => __('Content Excerpt Length', 'liora'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 1000.', 'liora'),
	'section'     => 'section_home_about',   
	'settings'    => 'theme_options[about_excerpt_length]',		
	'type'        => 'number',
	'active_callback' => 'liora_about_active',
	'input_attrs' => array(
			'min'	=> 0,
			'max'	=> 1000,
			'step'	=> 1,
		),
	)
);

// Author Highlight Title
$wp_customize->add_setting('theme_options[about_highlight_title]', 
	array(
	'default' 			=> $default['about_highlight_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[about_highlight_title]', 
	array(
	'label'       => __('Author Highlight Title', 'liora'),
	'section'     => 'section_home_about',   
	'settings'    => 'theme_options[about_highlight_title]',
	'active_callback' => 'liora_about_active',		
	'type'        => 'text'
	)
);

// Additional Information First Page
$wp_customize->add_setting('theme_options[about_page]', 
	array(
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'liora_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[about_page]', 
	array(
	'label'       => __('Select Page', 'liora'),
	'section'     => 'section_home_about',   
	'settings'    => 'theme_options[about_page]',		
	'type'        => 'dropdown-pages',
	'active_callback' => 'liora_about_active',
	)
);

// Author Button Text
$wp_customize->add_setting('theme_options[about_btn_text]', 
	array(
	'default' 			=> $default['about_btn_text'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[about_btn_text]', 
	array(
	'label'       => __('Author Button Text', 'liora'),
	'section'     => 'section_home_about',   
	'settings'    => 'theme_options[about_btn_text]',
	'active_callback' => 'liora_about_active',		
	'type'        => 'text'
	)
);

for( $i=1; $i<=4; $i++ ){

	//Social icon setting and control
	$wp_customize->add_setting('theme_options[author_social_links_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control('theme_options[author_social_links_'.$i.']', 
		array(
		'label'       => sprintf( __('Social Link #%1$s', 'liora'), $i),
		'section'     => 'section_home_about',   
		'settings'    => 'theme_options[author_social_links_'.$i.']',		
		'type'        => 'url',
		'active_callback' => 'liora_about_active',
		)
	);
}