<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function liora_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'liora' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'liora_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function liora_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'liora' ),
            'off'       => esc_html__( 'Disable', 'liora' )
        );
        return apply_filters( 'liora_switch_options', $arr );
    }
endif;

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function liora_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'liora' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}
if ( ! function_exists( 'liora_get_woo_product' ) ) {
    /**
     * Get product.
     */
    function liora_get_woo_product() {
        $args = array(
            'posts_per_page' => -1,
        );
         
        $choices = array( '' => esc_html__( '--Select--', 'liora' ) );
        $products = wc_get_products( $args );
        foreach ( $products as $product ) {
            $id = $product->get_id();
            $title = $product->get_name();
            $choices[ $id ] = $title;
        }
        return $choices;
    }
}




 /**
 * Get an array of google fonts.
 * 
 */
function liora_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'liora' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'liora_font_choices', $font_family_arr );
}

if ( ! function_exists( 'liora_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'header-font-1'   => esc_html__( 'Raleway', 'liora' ),
            'header-font-2'   => esc_html__( 'Poppins', 'liora' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'liora' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'liora' ),
            'header-font-5'   => esc_html__( 'Lato', 'liora' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'header-font-8'   => esc_html__( 'Lora', 'liora' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'header-font-10'   => esc_html__( 'Muli', 'liora' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'header-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'liora' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'liora' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'liora' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'liora' ),
            'header-font-21'   => esc_html__( 'Courgette', 'liora' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'liora' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'liora' ),
            'header-font-24'   => esc_html__( 'Righteous', 'liora' ),
            'header-font-25'   => esc_html__( 'Dosis', 'liora' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'liora' ),
            'header-font-27'   => esc_html__( 'Faster one', 'liora' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'liora' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'liora' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'liora' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'liora' ),
        );

        $output = apply_filters( 'liora_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'body-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'body-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'body-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'body-font-5'     => esc_html__( 'Lato', 'liora' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'body-font-8'   => esc_html__( 'Lora', 'liora' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'body-font-10'   => esc_html__( 'Muli', 'liora' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'body-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'liora_archive_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_archive_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'header-font-1'   => esc_html__( 'Raleway', 'liora' ),
            'header-font-2'   => esc_html__( 'Poppins', 'liora' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'liora' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'liora' ),
            'header-font-5'   => esc_html__( 'Lato', 'liora' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'header-font-8'   => esc_html__( 'Lora', 'liora' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'header-font-10'   => esc_html__( 'Muli', 'liora' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'header-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'liora' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'liora' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'liora' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'liora' ),
            'header-font-21'   => esc_html__( 'Courgette', 'liora' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'liora' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'liora' ),
            'header-font-24'   => esc_html__( 'Righteous', 'liora' ),
            'header-font-25'   => esc_html__( 'Dosis', 'liora' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'liora' ),
            'header-font-27'   => esc_html__( 'Faster one', 'liora' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'liora' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'liora' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'liora' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'liora' ),
        );

        $output = apply_filters( 'liora_archive_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_archive_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_archive_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'body-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'body-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'body-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'body-font-5'     => esc_html__( 'Lato', 'liora' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'body-font-8'   => esc_html__( 'Lora', 'liora' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'body-font-10'   => esc_html__( 'Muli', 'liora' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'body-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_archive_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_page_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_page_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'header-font-1'   => esc_html__( 'Raleway', 'liora' ),
            'header-font-2'   => esc_html__( 'Poppins', 'liora' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'liora' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'liora' ),
            'header-font-5'   => esc_html__( 'Lato', 'liora' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'header-font-8'   => esc_html__( 'Lora', 'liora' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'header-font-10'   => esc_html__( 'Muli', 'liora' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'header-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'liora' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'liora' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'liora' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'liora' ),
            'header-font-21'   => esc_html__( 'Courgette', 'liora' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'liora' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'liora' ),
            'header-font-24'   => esc_html__( 'Righteous', 'liora' ),
            'header-font-25'   => esc_html__( 'Dosis', 'liora' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'liora' ),
            'header-font-27'   => esc_html__( 'Faster one', 'liora' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'liora' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'liora' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'liora' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'liora' ),
        );

        $output = apply_filters( 'liora_page_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_page_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_page_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'body-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'body-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'body-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'body-font-5'     => esc_html__( 'Lato', 'liora' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'body-font-8'   => esc_html__( 'Lora', 'liora' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'body-font-10'   => esc_html__( 'Muli', 'liora' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'body-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_page_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_post_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_post_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'header-font-1'   => esc_html__( 'Raleway', 'liora' ),
            'header-font-2'   => esc_html__( 'Poppins', 'liora' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'liora' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'liora' ),
            'header-font-5'   => esc_html__( 'Lato', 'liora' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'header-font-8'   => esc_html__( 'Lora', 'liora' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'header-font-10'   => esc_html__( 'Muli', 'liora' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'header-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'liora' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'liora' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'liora' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'liora' ),
            'header-font-21'   => esc_html__( 'Courgette', 'liora' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'liora' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'liora' ),
            'header-font-24'   => esc_html__( 'Righteous', 'liora' ),
            'header-font-25'   => esc_html__( 'Dosis', 'liora' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'liora' ),
            'header-font-27'   => esc_html__( 'Faster one', 'liora' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'liora' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'liora' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'liora' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'liora' ),
        );

        $output = apply_filters( 'liora_post_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_post_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_post_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'body-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'body-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'body-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'body-font-5'     => esc_html__( 'Lato', 'liora' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'body-font-8'   => esc_html__( 'Lora', 'liora' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'body-font-10'   => esc_html__( 'Muli', 'liora' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'body-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_post_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'liora_site_title_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_site_title_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'site-font-1'   => esc_html__( 'Raleway', 'liora' ),
            'site-font-2'   => esc_html__( 'Poppins', 'liora' ),
            'site-font-3'   => esc_html__( 'Montserrat', 'liora' ),
            'site-font-4'   => esc_html__( 'Open Sans', 'liora' ),
            'site-font-5'   => esc_html__( 'Lato', 'liora' ),
            'site-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'site-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'site-font-8'   => esc_html__( 'Lora', 'liora' ),
            'site-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'site-font-10'   => esc_html__( 'Muli', 'liora' ),
            'site-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'site-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'site-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'site-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'site-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'site-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'site-font-17'   => esc_html__( 'Henny Penny', 'liora' ),
            'site-font-18'   => esc_html__( 'Orbitron' , 'liora' ),
            'site-font-19'   => esc_html__( 'Marck Script', 'liora' ),
            'site-font-20'   => esc_html__( 'Kaushan Script', 'liora' ),
            'site-font-21'   => esc_html__( 'Courgette', 'liora' ),
            'site-font-22'   => esc_html__( 'Rajdhani', 'liora' ),
            'site-font-23'   => esc_html__( 'Bad Script', 'liora' ),
            'site-font-24'   => esc_html__( 'Righteous', 'liora' ),
            'site-font-25'   => esc_html__( 'Dosis', 'liora' ),
            'site-font-26'   => esc_html__( 'Cinzel Decorative', 'liora' ),
            'site-font-27'   => esc_html__( 'Faster one', 'liora' ),
            'site-font-28'   => esc_html__( 'Tangerine', 'liora' ),
            'site-font-29'   => esc_html__( 'Fredericka the Great', 'liora' ),
            'site-font-30'   => esc_html__( 'Shadows Into Light', 'liora' ),
            'site-font-31'   => esc_html__( 'Gloria Hallelujah', 'liora' ),
        );

        $output = apply_filters( 'liora_site_title_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_site_tagline_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_site_tagline_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'tagline-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'tagline-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'tagline-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'tagline-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'tagline-font-5'     => esc_html__( 'Lato', 'liora' ),
            'tagline-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'tagline-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'tagline-font-8'   => esc_html__( 'Lora', 'liora' ),
            'tagline-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'tagline-font-10'   => esc_html__( 'Muli', 'liora' ),
            'tagline-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'tagline-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'tagline-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'tagline-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'tagline-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'tagline-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'tagline-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'tagline-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_site_tagline_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'liora_header_menu_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function liora_header_menu_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'liora' ),
            'menu-font-1'     => esc_html__( 'Raleway', 'liora' ),
            'menu-font-2'     => esc_html__( 'Poppins', 'liora' ),
            'menu-font-3'     => esc_html__( 'Roboto', 'liora' ),
            'menu-font-4'     => esc_html__( 'Open Sans', 'liora' ),
            'menu-font-5'     => esc_html__( 'Lato', 'liora' ),
            'menu-font-6'   => esc_html__( 'Ubuntu', 'liora' ),
            'menu-font-7'   => esc_html__( 'Playfair Display', 'liora' ),
            'menu-font-8'   => esc_html__( 'Lora', 'liora' ),
            'menu-font-9'   => esc_html__( 'Titillium Web', 'liora' ),
            'menu-font-10'   => esc_html__( 'Muli', 'liora' ),
            'menu-font-11'   => esc_html__( 'Oxygen', 'liora' ),
            'menu-font-12'   => esc_html__( 'Nunito Sans', 'liora' ),
            'menu-font-13'   => esc_html__( 'Maven Pro', 'liora' ),
            'menu-font-14'   => esc_html__( 'Cairo', 'liora' ),
            'menu-font-15'   => esc_html__( 'Philosopher', 'liora' ),
            'menu-font-16'   => esc_html__( 'Quicksand', 'liora' ),
            'menu-font-17'   => esc_html__( 'Dancing Script ', 'liora' ),
            'menu-font-18'   => esc_html__( 'Rajdhani', 'liora' ),
        );

        $output = apply_filters( 'liora_header_menu_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>