<?php
/**
 * LineDrawing Theme Customizer
 *
 * @package LineDrawing
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function linedrawing_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	
	/* Add a logo image with customizer */
	$wp_customize->add_section( 'linedrawing_logo_section' , array(
		'title' 	=>__( 'Logo', 'linedrawing' ),
		'priority' 	=> 30,
		'description'	=> 'Upload your own logo to replace the default one.'
	) );
	
	$wp_customize->add_setting( 'linedrawing_logo', array (
                                    'sanitize_callback' => 'linedrawing_sanitize_logo'
                                    ));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'linedrawing_logo', array(
		'label'		=>__( 'Logo Image', 'linedrawing' ),
		'section'	=> 'linedrawing_logo_section',
		'settings'	=> 'linedrawing_logo'
	) ) );
	$wp_customize->add_setting( 'linedrawing_logo_width', array (
                                    'sanitize_callback' => 'linedrawing_sanitize_logo_width'
                                    ));
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'logo_width', array (
		'label'		=>__( 'Logo Width (in pixels)', 'linedrawing' ),
		'section'	=>'linedrawing_logo_section',
		'settings'	=>'linedrawing_logo_width',
		'type'		=>'text'
	) ) );
		
	
}
add_action( 'customize_register', 'linedrawing_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function linedrawing_customize_preview_js() {
	wp_enqueue_script( 'linedrawing_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'linedrawing_customize_preview_js' );

/** 
 * Add Custom CSS to Header 
 */
function linedrawing_customize_css() {
	$logo_width = intval(get_theme_mod('linedrawing_logo_width', '240'));
	if ($logo_width < 1) {$logo_width = 240;} /*Sometimes the default does not register*/
	$mobile_width = $logo_width * 0.79;
	$margin = $logo_width + 10;
	$mobile_margin = $margin * 0.79;
	?>
		<style type="text/css">
			.site-branding { width: <?php echo $logo_width."px"; ?>; }
			#restofheader { margin-left: <?php echo $margin."px"; ?>; }
			@media only screen and (max-width:768px) {
				.site-branding {
					width: <?php echo $mobile_width."px"; ?>;
				}
				#restofheader {
					margin-left: <?php echo $mobile_margin."px"; ?>;
				}
			}
		</style>
		
	<?php
}
add_action( 'wp_head', 'linedrawing_customize_css');

// functions to sanitize customizer input

function linedrawing_sanitize_logo ($input) {
    return esc_url_raw($input);
}

function linedrawing_sanitize_logo_width ($input) {
    $width = intval($input);
    if ($width < 1)
        return 240;
    else 
        return $width;
}