<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package LineDrawing
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">

	<div id="inner-page"> <!--Everything but footer. Allows footer to be full width. -->

	<header id="masthead" class="site-header" role="banner">
		<div class="site-branding">
		
			<!--Display logo user sets in customizer -->
			<?php if ( get_theme_mod( 'linedrawing_logo' ) ) : ?>
				<a href='<?php echo esc_url( home_url( '/' ) ); ?>'
					title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'
					rel='home'><img src='<?php echo esc_url( get_theme_mod( 'linedrawing_logo' ) ); ?>'
					alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'>
				</a>
				
			<!--Otherwise, display standard text header -->
			<?php else : ?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
			<?php endif; ?>
		</div> <!-- .site-branding -->
		
		
		<div id="restofheader">
		
			<!-- Menu for small screens -->
			<nav id="mobile-navigation" role="navigation">
				<p class="menu-toggle"></p>
				<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'linedrawing' ); ?></a>

				<?php wp_nav_menu( array( 'theme_location' => 'primary',
							  'container_class' => 'mobile-menu' ) ); ?>
			</nav><!-- #mobile-navigation -->
			
		</div> <!-- #restofheader -->
		
	</header><!-- #masthead -->

	<div id="content" class="site-content">
		<div id="left-bar"></div>
