<?php
/**
 * @package LineDrawing
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>

		<div class="entry-meta">
			<?php linedrawing_posted_on(); ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content">
		 <!-- Featured Image -->
		 <?php if ( '' != get_the_post_thumbnail() ):
			$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); ?>
			
			<img class="featured-image" src="<?php echo $thumbnail[0]; ?>" alt="">
		<?php endif; ?>
	
	
	
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'linedrawing' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	
	<hr class="post-divider"/> <!-- divide content from footer -->

	<footer class="entry-footer">
		<?php
                    //Catagories
		    $categories_list = get_the_category_list( __( ' ', 'linedrawing' ) );
		    if ( $categories_list ) {
		    ?>
		      <span class="catagories-label">
			  <?php printf( __( 'Posted in', 'linedrawing' ) ); ?>
		      </span>
		      <span class="categories-links">
			  <?php printf( __( '%1$s', 'linedrawing' ), $categories_list ); ?>
		      </span>
		      <br><br>
		      
		      <?php
		      }
	
			/* translators: used between list items, seperated by a space */
			$tags_list = get_the_tag_list( '', __( ' ', 'linedrawing' ) );
			if ( $tags_list ) : ?>
			<span class="tags-label">
			  <?php printf( __( 'Tagged', 'linedrawing' ) ); ?>
			</span>
			
			<span class="tags-links">
				<?php printf( __( '%1$s', 'linedrawing' ), $tags_list ); ?>
			</span>
			<?php endif; // End if $tags_list 
		?>
		
		<?php edit_post_link( __( 'Edit', 'linedrawing' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
