;
(function(window, document) {
    window.addEventListener('load', initilate)

    let urlRegex = /.*url\(['"]*(.*?)['"]*\).*/g;
    let elements = []

    function initilate() {
        elements = document.getElementsByClassName('vk-prlx')
        if (elements.length < 1) return;

        Array.prototype.forEach.call(
            elements,
            (i) => {
                let url = i.style.backgroundImage.replace(urlRegex, '$1')
                if (url != 'none') {
                    let img = new Image();
                    img.src = url;
                    i.setAttribute('image_rate', img.width / img.height)
                    i.setAttribute('image_w', img.width)
                    i.setAttribute('image_h', img.height)
                }
            }
        )
        window.addEventListener('scroll', prlx_scr)
        window.addEventListener('resize', prlx_scr)
    }

    function prlx_scr() {
        let scrled_Y = window.pageYOffset || document.documentElement.scrollTop
        let window_H = document.documentElement.clientHeight

        Array.prototype.forEach.call(
            elements,
            (i) => {
                let url = i.style.backgroundImage.replace(urlRegex, '$1')
                let img_rate = i.getAttribute('image_rate')
                if (img_rate) {
                    let img_W = i.getAttribute('image_w')
                    let img_H = i.getAttribute('image_h')
                    let area_W = i.offsetWidth
                    let area_H = i.offsetHeight
                    let area_rate = area_W / area_H
                    let bg_W = 0
                    let bg_H = 0
                    let scrl_rate = -1
                    let need_H = 0
                    if (0 < scrl_rate) {
                        need_H = area_H + (area_H * scrl_rate)
                    } else {
                        need_H = area_H + (area_H * -scrl_rate)
                    }
                    if (need_H < img_H) {
                        bg_H = img_H
                        bg_W = img_H * img_rate
                    } else {
                        bg_H = need_H
                        bg_W = need_H * img_rate
                    }
                    if (bg_W < area_W) {
                        bg_W = area_W
                        bg_H = area_W / img_rate
                    }
                    let rect = i.getBoundingClientRect()
                    let posi_Y = rect.top + scrled_Y
                    let prlx_start_Y = posi_Y - window_H
                    let bg_over_H = bg_H - area_H
                    let prlx_area_H = window_H + area_H
                    let bg_need_over_H = bg_H - need_H
                    let bg_offset_distance = (need_H - area_H) / prlx_area_H
                    let over_offset_H = 0
                    if (prlx_start_Y < scrled_Y) {
                        let prlx_scrled_Y = (scrled_Y - prlx_start_Y)
                        let bg_posi_Y = prlx_scrled_Y * bg_offset_distance
                        if (need_H < bg_H) {
                            over_offset_H = bg_need_over_H / 2
                        }
                        if (0 < scrl_rate) {
                            bg_posi_Y = -bg_posi_Y
                            bg_posi_Y = bg_posi_Y - over_offset_H
                        } else if (0 > scrl_rate) {
                            let bottom_offset = -(need_H - area_H)
                            bg_posi_Y = bottom_offset + bg_posi_Y
                            bg_posi_Y = bg_posi_Y - over_offset_H
                        }
                        let backgroundPosition = "center " + bg_posi_Y + "px"
                        i.style.backgroundPosition = backgroundPosition
                    }
                    i.style.backgroundSize = bg_W + 'px ' + bg_H + 'px'
                }
            }
        )
    }
})(window, document);