<?php

/**
 * Register widget area.
 *
 * @since lightblog 1.0
 *
 * @link https://codex.wordpress.org/Function_Reference/register_sidebar
 */
function lightblogkt_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__(  'Primary Sidebar', 'lightblogkt' ),
		'id'            => 'primary-sidebar',
		'description'   => esc_html__(  'Add widgets here to appear in your sidebar.', 'lightblogkt' ),
		'before_widget' => '<aside id="%1$s" class="widget-container %2$s"><div class="box">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );

}
add_action( 'widgets_init', 'lightblogkt_widgets_init' );