<?php
/**
 * Enqueue scripts and styles.
 *
 * @since lightblog 1.0
 */
 
if ( ! function_exists( 'lightblogkt_fonts_url' ) ) :
/**
 * Register Google fonts for lightblog.
 *
 * Create your own lightblogkt_fonts_url() function to override in a child theme.
 *
 * @since lightblog 1.0
 *
 * @return string Google fonts URL for the theme.
 */
function lightblogkt_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Noto Sans, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Noto Sans font: on or off', 'lightblogkt' ) ) {
		$fonts[] = 'Noto Sans:400,400italic,700,700italic';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return $fonts_url;
}
endif;
 
 
function lightblogkt_scripts() {
	
	
	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'lightblogkt-fonts', lightblogkt_fonts_url(), array(), null );
	
	// Load our stylesheet.
	wp_enqueue_style('lightblogkt-skeleton', get_template_directory_uri().'/css/skeleton.css', array(), '1.0');
	
	wp_enqueue_style('lightblogkt-style', get_stylesheet_uri() );
	wp_enqueue_style('lightblogkt-fixedmenu', get_template_directory_uri().'/css/fixedmenu.css', '', '', 'screen, all');
	wp_enqueue_style('lightblogkt-layout', get_template_directory_uri().'/css/layout.css', array(), '2.6.0');
	
	// Load our scripts.
	wp_enqueue_script('superfish', get_template_directory_uri().'/js/superfish.js', array('jquery'), '1.7.7', true);
	wp_enqueue_script('supersubs', get_template_directory_uri().'/js/supersubs.js', array('jquery'), '0.3', true);
	wp_enqueue_script('tinynav', get_template_directory_uri().'/js/tinynav.js', array('jquery'), '1.2', true);
	
	wp_enqueue_script('lightblogkt-custom', get_template_directory_uri().'/js/lightblogkt-custom.js', array('jquery'), '1.0', true);
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	
}
add_action( 'wp_enqueue_scripts', 'lightblogkt_scripts' );
