<?php
/**
 * The Header for our theme.
 *
 *
 * @package lightblog
 * @since lightblog 1.0
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="bodychild">
	<div id="outercontainer">
    
        <!-- HEADER -->
        <div id="outerheader" class="fixedmenu">
        	<div id="headercontainer">
                <div class="container">
                    <div class="row">
                    <div class="twelve columns">
                    <header id="top">
                        
                        <div id="logo">
                            <?php lightblogkt_the_custom_logo(); ?> 
                        </div>
                        <section id="navigation">
                            <nav id="top-nav-wrap">
                                <?php wp_nav_menu(array('container' => 'ul','menu_class' => 'sf-menu','theme_location' => 'primary')); ?>
                            </nav><!-- nav -->	
                        </section>
                        
                        <div class="clear"></div>
                    </header>
                    </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
		</div>
        <!-- END HEADER -->
        